/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.AssociatedObjectsLowering;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/AssociatedObjectsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCurrentFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "setCurrentFile", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "lower", "", "irFile", "visitor", "org/jetbrains/kotlin/backend/wasm/lower/AssociatedObjectsLowering$visitor$1", "Lorg/jetbrains/kotlin/backend/wasm/lower/AssociatedObjectsLowering$visitor$1;", "backend.wasm"})
public final class AssociatedObjectsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    public IrFile currentFile;
    @NotNull
    private final visitor.1 visitor;

    public AssociatedObjectsLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.visitor = new IrVisitorVoid(this){
            final /* synthetic */ AssociatedObjectsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof IrClass) {
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }
            }

            public void visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                super.visitClass(declaration);
                List associatedObjects = new ArrayList<E>();
                for (IrConstructorCall klassAnnotation : declaration.getAnnotations()) {
                    IrClass associatedObject;
                    IrClass annotationClass;
                    if (IrUtilsKt.getParentClassOrNull((IrDeclaration)klassAnnotation.getSymbol().getOwner()) == null || klassAnnotation.getArguments().size() != 1 || IrUtilsKt.isEffectivelyExternal(declaration) || AnnotationUtilsKt.associatedObject(klassAnnotation) == null) continue;
                    ((Collection)associatedObjects).add(new Pair((Object)annotationClass, (Object)associatedObject));
                }
                if (!((Collection)associatedObjects).isEmpty()) {
                    this.this$0.getContext().getFileContext(this.this$0.getCurrentFile()).getClassAssociatedObjects().put(declaration, associatedObjects);
                }
            }
        };
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFile getCurrentFile() {
        IrFile irFile = this.currentFile;
        if (irFile != null) {
            return irFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentFile");
        return null;
    }

    public final void setCurrentFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"<set-?>");
        this.currentFile = irFile;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.setCurrentFile(irFile);
        IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, this.visitor);
    }
}

