/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.steps.CachingContext;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.jspecify.annotations.Nullable;

public class InputChangesContext
extends ValidationFinishedContext
implements CachingContext {
    private final @Nullable InputChangesInternal inputChanges;
    private final CachingState cachingState;

    public InputChangesContext(ValidationFinishedContext parent, @Nullable InputChangesInternal inputChanges, CachingState cachingState) {
        super(parent);
        this.inputChanges = inputChanges;
        this.cachingState = cachingState;
    }

    protected InputChangesContext(InputChangesContext parent) {
        this(parent, parent.getInputChanges().orElse(null), parent.getCachingState());
    }

    public Optional<InputChangesInternal> getInputChanges() {
        return Optional.ofNullable(this.inputChanges);
    }

    public boolean isIncrementalExecution() {
        return this.inputChanges != null && this.inputChanges.isIncremental();
    }

    @Override
    public CachingState getCachingState() {
        return this.cachingState;
    }
}

