/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.detection.TestDetector;
import org.gradle.api.internal.tasks.testing.processors.RootTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.WorkerLeaseService;

public class TestMainAction
implements Runnable {
    private final TestDetector detector;
    private final TestClassProcessor processor;
    private final TestResultProcessor resultProcessor;
    private final WorkerLeaseService workerLeaseService;
    private final Clock clock;
    private final Object rootTestSuiteId;
    private final String displayName;

    public TestMainAction(TestDetector detector, TestClassProcessor processor, TestResultProcessor resultProcessor, WorkerLeaseService workerLeaseService, Clock clock, Object rootTestSuiteId, String displayName) {
        this.detector = detector;
        this.processor = processor;
        this.resultProcessor = new AttachParentTestResultProcessor(resultProcessor);
        this.workerLeaseService = workerLeaseService;
        this.clock = clock;
        this.rootTestSuiteId = rootTestSuiteId;
        this.displayName = displayName;
    }

    @Override
    public void run() {
        RootTestSuiteDescriptor suite = new RootTestSuiteDescriptor(this.rootTestSuiteId, this.displayName);
        this.resultProcessor.started((TestDescriptorInternal)suite, new TestStartEvent(this.clock.getCurrentTime()));
        try {
            this.processor.startProcessing(this.resultProcessor);
            try {
                this.detector.detect();
            }
            catch (Throwable throwable) {
                this.workerLeaseService.blocking(new Runnable(){

                    @Override
                    public void run() {
                        TestMainAction.this.processor.stop();
                    }
                });
                throw throwable;
            }
            this.workerLeaseService.blocking(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable ex) {
            this.resultProcessor.failure(suite.getId(), DefaultTestFailure.fromTestFrameworkStartupFailure((Throwable)ex));
        }
        finally {
            this.resultProcessor.completed(suite.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }
}

