/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.AssertionFailureDetails;
import org.gradle.api.internal.tasks.testing.AssumptionFailureDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestFailureDetails;
import org.gradle.api.internal.tasks.testing.FileComparisonFailureDetails;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestFailureDetails;
import org.gradle.internal.serialize.PlaceholderExceptionSupport;
import org.jspecify.annotations.Nullable;

public class DefaultTestFailure
extends TestFailure {
    private final Throwable rawFailure;
    private final TestFailureDetails details;
    private final List<TestFailure> causes;

    public DefaultTestFailure(Throwable rawFailure, TestFailureDetails details, List<TestFailure> causes) {
        this.rawFailure = rawFailure;
        this.details = details;
        this.causes = causes;
    }

    @Override
    public Throwable getRawFailure() {
        return this.rawFailure;
    }

    @Override
    public TestFailureDetails getDetails() {
        return this.details;
    }

    @Override
    public List<TestFailure> getCauses() {
        return this.causes;
    }

    public String toString() {
        return "test failure {rawFailure=" + this.rawFailure.getClass().getCanonicalName() + ", causes=" + this.causes.size() + ", details=" + this.details + '}';
    }

    public static TestFailure fromTestAssumptionFailure(Throwable failure) {
        AssumptionFailureDetails details = new AssumptionFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure));
        return new DefaultTestFailure(failure, details, Collections.emptyList());
    }

    public static TestFailure fromTestAssertionFailure(Throwable failure, String expected, String actual, @Nullable List<TestFailure> causes) {
        AssertionFailureDetails details = new AssertionFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure), expected, actual);
        return new DefaultTestFailure(failure, details, DefaultTestFailure.emptyIfNull(causes));
    }

    public static TestFailure fromFileComparisonTestAssertionFailure(Throwable failure, String expected, String actual, @Nullable List<TestFailure> causes, byte[] expectedContent, byte[] actualContent) {
        FileComparisonFailureDetails details = new FileComparisonFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure), expected, actual, expectedContent, actualContent);
        return new DefaultTestFailure(failure, details, DefaultTestFailure.emptyIfNull(causes));
    }

    public static TestFailure fromTestFrameworkFailure(Throwable failure, @Nullable List<TestFailure> causes) {
        DefaultTestFailureDetails details = new DefaultTestFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure));
        return new DefaultTestFailure(failure, details, DefaultTestFailure.emptyIfNull(causes));
    }

    public static TestFailure fromTestFrameworkStartupFailure(Throwable failure) {
        DefaultTestFailureDetails details = new DefaultTestFailureDetails(DefaultTestFailure.messageOf(failure), DefaultTestFailure.classNameOf(failure), DefaultTestFailure.stacktraceOf(failure));
        return new DefaultTestFailure(failure, details, Collections.emptyList());
    }

    private static List<TestFailure> emptyIfNull(@Nullable List<TestFailure> causes) {
        return causes == null ? Collections.emptyList() : causes;
    }

    private static String messageOf(Throwable throwable) {
        try {
            return throwable.getMessage();
        }
        catch (Throwable t) {
            return DefaultTestFailure.createFailedToReadThrowableException("message", throwable, t).getMessage();
        }
    }

    private static String classNameOf(Throwable failure) {
        return failure instanceof PlaceholderExceptionSupport ? ((PlaceholderExceptionSupport)failure).getExceptionClassName() : failure.getClass().getName();
    }

    private static String stacktraceOf(Throwable throwable) {
        try {
            StringWriter out = new StringWriter();
            PrintWriter wrt = new PrintWriter(out);
            throwable.printStackTrace(wrt);
            return out.toString();
        }
        catch (Exception t) {
            return DefaultTestFailure.stacktraceOf(DefaultTestFailure.createFailedToReadThrowableException("stacktrace", throwable, t));
        }
    }

    private static Throwable createFailedToReadThrowableException(String part, Throwable original, Throwable cause) {
        return new GradleException(String.format("Could not determine failure %s for exception of type %s: %s", part, DefaultTestFailure.classNameOf(original), cause), cause);
    }
}

