/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.MutableTerminalSize;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.TerminalSize;
import net.rubygrapefruit.platform.terminal.Terminals;

public class AnsiTerminal
extends AbstractTerminal {
    private static final byte[] BOLD = "\u001b[1m".getBytes();
    static final byte[] DIM_ON = "\u001b[2m".getBytes();
    private static final byte[] NORMAL_INTENSITY = "\u001b[22m".getBytes();
    private static final byte[] DEFAULT_FG = "\u001b[39m".getBytes();
    private static final byte[] RESET = "\u001b[0m".getBytes();
    private static final byte[] START_OF_LINE = "\u001b[1G".getBytes();
    private static final byte[] CLEAR_TO_END_OF_LINE = "\u001b[0K".getBytes();
    private static final List<byte[]> FOREGROUND = new ArrayList<byte[]>();
    static final List<byte[]> BRIGHT_FOREGROUND = new ArrayList<byte[]>();
    private TerminalOutput.Color foreground;
    private boolean bright;
    private final Terminals.Output output;
    private final OutputStream outputStream;

    public AnsiTerminal(OutputStream outputStream, Terminals.Output output) {
        this.outputStream = outputStream;
        this.output = output;
    }

    public AnsiTerminal(Terminals.Output output) {
        this(AnsiTerminal.streamForOutput(output), output);
    }

    public String toString() {
        return String.format("ANSI terminal on %s", this.getOutputDisplay());
    }

    private String getOutputDisplay() {
        return this.output.toString().toLowerCase();
    }

    @Override
    protected void init() {
    }

    @Override
    public boolean supportsTextAttributes() {
        return true;
    }

    @Override
    public boolean supportsColor() {
        return true;
    }

    @Override
    public boolean supportsCursorMotion() {
        return true;
    }

    @Override
    public boolean supportsCursorVisibility() {
        return false;
    }

    @Override
    public TerminalSize getTerminalSize() throws NativeException {
        return new MutableTerminalSize();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public TerminalOutput foreground(TerminalOutput.Color color) throws NativeException {
        try {
            if (this.bright) {
                this.outputStream.write(BRIGHT_FOREGROUND.get(color.ordinal()));
            } else {
                this.outputStream.write(FOREGROUND.get(color.ordinal()));
            }
            this.foreground = color;
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not set foreground color on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput defaultForeground() throws NativeException {
        try {
            this.outputStream.write(DEFAULT_FG);
            this.foreground = null;
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not switch to bold output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput bright() throws NativeException {
        try {
            this.bright = true;
            if (this.foreground != null) {
                this.outputStream.write(BRIGHT_FOREGROUND.get(this.foreground.ordinal()));
            }
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not set foreground color on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput dim() throws NativeException {
        try {
            this.outputStream.write(DIM_ON);
            this.bright = false;
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not set foreground color on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput bold() throws NativeException {
        try {
            this.outputStream.write(BOLD);
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not switch to bold output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput normal() throws NativeException {
        try {
            this.outputStream.write(NORMAL_INTENSITY);
            if (this.foreground != null && this.bright) {
                this.outputStream.write(FOREGROUND.get(this.foreground.ordinal()));
            }
            this.bright = false;
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not switch to normal output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput reset() throws NativeException {
        try {
            this.outputStream.write(RESET);
            this.foreground = null;
            this.bright = false;
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not reset output on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput hideCursor() throws NativeException {
        return this;
    }

    @Override
    public TerminalOutput showCursor() throws NativeException {
        return this;
    }

    @Override
    public TerminalOutput cursorLeft(int count) throws NativeException {
        if (count == 0) {
            return this;
        }
        try {
            String esc = String.format("\u001b[%sD", count);
            this.outputStream.write(esc.getBytes());
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput cursorRight(int count) throws NativeException {
        if (count == 0) {
            return this;
        }
        try {
            String esc = String.format("\u001b[%sC", count);
            this.outputStream.write(esc.getBytes());
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput cursorUp(int count) throws NativeException {
        if (count == 0) {
            return this;
        }
        try {
            String esc = String.format("\u001b[%sA", count);
            this.outputStream.write(esc.getBytes());
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput cursorDown(int count) throws NativeException {
        if (count == 0) {
            return this;
        }
        try {
            String esc = String.format("\u001b[%sB", count);
            this.outputStream.write(esc.getBytes());
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput cursorStartOfLine() throws NativeException {
        try {
            this.outputStream.write(START_OF_LINE);
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not move cursor on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    @Override
    public TerminalOutput clearToEndOfLine() throws NativeException {
        try {
            this.outputStream.write(CLEAR_TO_END_OF_LINE);
        }
        catch (IOException e) {
            throw new NativeException(String.format("Could not clear to end of line on %s.", this.getOutputDisplay()), e);
        }
        return this;
    }

    static {
        for (TerminalOutput.Color color : TerminalOutput.Color.values()) {
            FOREGROUND.add(String.format("\u001b[%sm", 30 + color.ordinal()).getBytes());
            BRIGHT_FOREGROUND.add(String.format("\u001b[%sm", 90 + color.ordinal()).getBytes());
        }
    }
}

