/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.gradle.internal.UncheckedException;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.streams.ExecOutputHandleRunner;
import org.gradle.util.internal.DisconnectableInputStream;

public class ForwardStdinStreamsHandler
implements StreamsHandler {
    private final InputStream input;
    private final CountDownLatch completed = new CountDownLatch(1);
    private Executor executor;
    private ExecOutputHandleRunner standardInputWriter;

    public ForwardStdinStreamsHandler(InputStream input) {
        this.input = input;
    }

    public void connectStreams(Process process, String processName, Executor executor) {
        this.executor = executor;
        DisconnectableInputStream instr = new DisconnectableInputStream(this.input);
        this.standardInputWriter = new ExecOutputHandleRunner("write standard input to " + processName, instr, process.getOutputStream(), this.completed);
    }

    public void start() {
        this.executor.execute(this.standardInputWriter);
    }

    public void removeStartupContext() {
    }

    public void stop() {
        this.disconnect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void disconnect() {
        try {
            this.standardInputWriter.closeInput();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

