/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.ConventionReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.internal.serialization.Cached;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractProjectBasedReportTask<T>
extends ConventionReportTask {
    private final Cached<ProjectBasedReportModel<T>> reportModels = Cached.of(this::calculateReportModel);

    private ProjectBasedReportModel<T> calculateReportModel() {
        LinkedHashMap<ProjectDetails, T> map = new LinkedHashMap<ProjectDetails, T>();
        for (Project project : this.getProjects()) {
            map.put(ProjectDetails.of(project), this.calculateReportModelFor(project));
        }
        return new ProjectBasedReportModel(map);
    }

    protected abstract T calculateReportModelFor(Project var1);

    @Incubating
    protected void generateReportHeaderFor(Map<ProjectDetails, T> modelsByProjectDetails) {
    }

    protected abstract void generateReportFor(ProjectDetails var1, T var2);

    @Incubating
    protected void generateReportFooterFor(Map<ProjectDetails, T> modelsByProjectDetails) {
    }

    @TaskAction
    void action() {
        Map modelsByProjectDetails = ((ProjectBasedReportModel)this.reportModels.get()).modelsByProjectDetails;
        if (Boolean.getBoolean("org.gradle.internal.dependencies.infinity")) {
            while (true) {
                this.reportGenerator().generateReport(modelsByProjectDetails.entrySet(), Map.Entry::getKey, () -> this.generateReportHeaderFor(modelsByProjectDetails), entry -> {
                    this.generateReportFor((ProjectDetails)entry.getKey(), entry.getValue());
                    this.logClickableOutputFileUrl();
                }, () -> this.generateReportFooterFor(modelsByProjectDetails));
            }
        }
        this.reportGenerator().generateReport(modelsByProjectDetails.entrySet(), Map.Entry::getKey, () -> this.generateReportHeaderFor(modelsByProjectDetails), entry -> {
            this.generateReportFor((ProjectDetails)entry.getKey(), entry.getValue());
            this.logClickableOutputFileUrl();
        }, () -> this.generateReportFooterFor(modelsByProjectDetails));
    }

    private static class ProjectBasedReportModel<T> {
        private final Map<ProjectDetails, T> modelsByProjectDetails;

        private ProjectBasedReportModel(Map<ProjectDetails, T> modelsByProjectDetails) {
            this.modelsByProjectDetails = modelsByProjectDetails;
        }
    }
}

