/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jetbrains.kotlin.js.backend.JsConstructExpressionVisitor;
import org.jetbrains.kotlin.js.backend.JsFirstExpressionVisitor;
import org.jetbrains.kotlin.js.backend.JsPrecedenceVisitor;
import org.jetbrains.kotlin.js.backend.JsRequiresSemiVisitor;
import org.jetbrains.kotlin.js.backend.NoOpSourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.SourceLocationConsumer;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBigIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsComment;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExport;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsNumberLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsOperator;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.JsYield;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.util.TextOutput;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CLASS = "class".toCharArray();
    private static final char[] CHARS_CONSTRUCTOR = "constructor".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_YIELD = "yield".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_EXTENDS = "extends".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_STATIC = "static".toCharArray();
    private static final char[] CHARS_GET = "get".toCharArray();
    private static final char[] CHARS_SET = "set".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_SUPER = "super".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    @NotNull
    private final SourceLocationConsumer sourceLocationConsumer;
    @NotNull
    private final List<Object> sourceInfoStack;
    protected boolean insideComments;
    protected boolean needSemi;
    private boolean lineBreakAfterBlock;
    private Set<JsBlock> globalBlocks;
    @NotNull
    protected final TextOutput p;

    public static CharSequence javaScriptString(String value2) {
        return JsToStringGenerationVisitor.javaScriptString(value2, false);
    }

    public static CharSequence javaScriptString(CharSequence chars, boolean forceDoubleQuote) {
        int n2 = chars.length();
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i2 = 0; i2 < n2; ++i2) {
            switch (chars.charAt(i2)) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuilder result2 = new StringBuilder(n2 + 16);
        char quoteChar = quoteCount < aposCount || forceDoubleQuote ? (char)'\"' : '\'';
        result2.append(quoteChar);
        for (int i3 = 0; i3 < n2; ++i3) {
            int hexSize;
            char c2 = chars.charAt(i3);
            if (' ' <= c2 && c2 <= '~' && c2 != quoteChar && c2 != '\\') {
                result2.append(c2);
                continue;
            }
            int escape = -1;
            switch (c2) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result2.append('\\');
                result2.append((char)escape);
                continue;
            }
            if (c2 < '\u0100') {
                result2.append("\\x");
                hexSize = 2;
            } else {
                result2.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c2 >> shift;
                result2.append(HEX_DIGITS[digit]);
            }
        }
        result2.append(quoteChar);
        JsToStringGenerationVisitor.escapeClosingTags(result2);
        return result2;
    }

    private static void escapeClosingTags(StringBuilder str) {
        if (str == null) {
            return;
        }
        int index = 0;
        while ((index = str.indexOf("</", index)) != -1) {
            str.insert(index + 1, '\\');
        }
    }

    public JsToStringGenerationVisitor(@NotNull TextOutput out, @NotNull SourceLocationConsumer sourceLocationConsumer) {
        if (out == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(0);
        }
        if (sourceLocationConsumer == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(1);
        }
        this.sourceInfoStack = new ArrayList<Object>();
        this.insideComments = false;
        this.needSemi = true;
        this.lineBreakAfterBlock = true;
        this.globalBlocks = new ObjectOpenHashSet<JsBlock>();
        this.p = out;
        this.sourceLocationConsumer = sourceLocationConsumer;
    }

    public JsToStringGenerationVisitor(@NotNull TextOutput out) {
        if (out == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(2);
        }
        this(out, NoOpSourceLocationConsumer.INSTANCE);
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(3);
        }
        this.printCommentsBeforeNode(x2);
        this.pushSourceInfo(x2.getSource());
        this.printPair(x2, x2.getArrayExpression());
        this.leftSquare();
        this.accept(x2.getIndexExpression());
        this.rightSquare();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(4);
        }
        this.printCommentsBeforeNode(x2);
        this.pushSourceInfo(x2.getSource());
        this.leftSquare();
        this.printExpressions(x2.getExpressions());
        this.rightSquare();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    private void printExpressions(List<JsExpression> expressions) {
        boolean notFirst = false;
        for (JsExpression expression2 : expressions) {
            notFirst = this.sepCommaSpace(notFirst) && !(expression2 instanceof JsDocComment);
            boolean isEnclosed = this.parenPushIfCommaExpression(expression2);
            this.accept(expression2);
            if (!isEnclosed) continue;
            this.rightParen();
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation binaryOperation) {
        boolean isParenOpened;
        if (binaryOperation == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(5);
        }
        this.printCommentsBeforeNode(binaryOperation);
        this.pushSourceInfo(binaryOperation.getSource());
        JsBinaryOperator operator = binaryOperation.getOperator();
        JsExpression arg1 = binaryOperation.getArg1();
        boolean isExpressionEnclosed = this.parenPush(binaryOperation, arg1, !operator.isLeftAssociative());
        this.accept(arg1);
        if (operator.isKeyword()) {
            this._parenPopOrSpace(binaryOperation, arg1, !operator.isLeftAssociative());
        } else if (operator != JsBinaryOperator.COMMA) {
            if (isExpressionEnclosed) {
                this.rightParen();
            }
            this.space();
        }
        this.p.print(operator.getSymbol());
        JsExpression arg2 = binaryOperation.getArg2();
        if (operator == JsBinaryOperator.COMMA) {
            isParenOpened = false;
            this.space();
        } else if (arg2 instanceof JsBinaryOperation && ((JsBinaryOperation)arg2).getOperator() == JsBinaryOperator.AND) {
            this.space();
            this.leftParen();
            isParenOpened = true;
        } else if (JsToStringGenerationVisitor.spaceCalc(operator, arg2)) {
            isParenOpened = this._parenPushOrSpace(binaryOperation, arg2, operator.isLeftAssociative());
        } else {
            this.space();
            isParenOpened = this.parenPush(binaryOperation, arg2, operator.isLeftAssociative());
        }
        this.accept(arg2);
        if (isParenOpened) {
            this.rightParen();
        }
        this.printCommentsAfterNode(binaryOperation);
        this.popSourceInfo();
    }

    @Override
    public void visitBlock(@NotNull JsBlock x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(6);
        }
        this.printJsBlock(x2, true, null);
    }

    @Override
    public void visitBoolean(@NotNull JsBooleanLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(7);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        if (x2.getValue()) {
            this.p.print(CHARS_TRUE);
        } else {
            this.p.print(CHARS_FALSE);
        }
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitBreak(@NotNull JsBreak x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(8);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_BREAK);
        this.continueOrBreakLabel(x2);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitContinue(@NotNull JsContinue x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(9);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_CONTINUE);
        this.continueOrBreakLabel(x2);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitYield(@NotNull JsYield x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(10);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_YIELD);
        JsExpression expression2 = x2.getExpression();
        if (expression2 != null) {
            this.space();
            this.accept(x2.getExpression());
        }
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    private void continueOrBreakLabel(JsContinue x2) {
        JsNameRef label = x2.getLabel();
        if (label != null) {
            this.space();
            this.p.print(label.getIdent());
        }
    }

    @Override
    public void visitCase(@NotNull JsCase x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(11);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_CASE);
        this.space();
        this.accept(x2.getCaseExpression());
        this._colon();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        this.newline();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printSwitchMemberStatements(x2);
        this.sourceLocationConsumer.popSourceInfo();
    }

    private void printSwitchMemberStatements(JsSwitchMember x2) {
        this.p.indentIn();
        for (JsStatement stmt : x2.getStatements()) {
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this.semi();
            }
            this.newline();
        }
        this.p.indentOut();
        this.needSemi = false;
    }

    @Override
    public void visitCatch(@NotNull JsCatch x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(12);
        }
        this.printCommentsBeforeNode(x2);
        this.pushSourceInfo(x2.getSource());
        this.space();
        this.p.print(CHARS_CATCH);
        this.space();
        this.leftParen();
        this.nameDef(x2.getParameter().getName());
        JsExpression catchCond = x2.getCondition();
        if (catchCond != null) {
            this.space();
            this._if();
            this.space();
            this.accept(catchCond);
        }
        this.rightParen();
        this.space();
        this.popSourceInfo();
        this.printCommentsAfterNode(x2);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(x2.getBody());
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitConditional(@NotNull JsConditional x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(13);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.printPair(x2, x2.getTestExpression(), true);
        this.space();
        this.p.print('?');
        this.space();
        this.printPair(x2, x2.getThenExpression());
        this.space();
        this._colon();
        this.space();
        this.printPair(x2, x2.getElseExpression());
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    private void printPair(JsExpression parent2, JsExpression expression2, boolean wrongAssoc) {
        boolean isNeedParen = JsToStringGenerationVisitor.parenCalc(parent2, expression2, wrongAssoc);
        if (isNeedParen) {
            this.leftParen();
        }
        this.accept(expression2);
        if (isNeedParen) {
            this.rightParen();
        }
    }

    private void printPair(JsExpression parent2, JsExpression expression2) {
        this.printPair(parent2, expression2, false);
    }

    @Override
    public void visitDebugger(@NotNull JsDebugger x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(14);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_DEBUGGER);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitDefault(@NotNull JsDefault x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(15);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_DEFAULT);
        this._colon();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        this.newline();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printSwitchMemberStatements(x2);
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitWhile(@NotNull JsWhile x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(16);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this._while();
        this.space();
        this.leftParen();
        this.accept(x2.getCondition());
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        JsStatement body = JsToStringGenerationVisitor.materialize(x2.getBody());
        this.nestedPush(body);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(body);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body);
    }

    @Override
    public void visitDoWhile(@NotNull JsDoWhile x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(17);
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_DO);
        JsStatement body = JsToStringGenerationVisitor.materialize(x2.getBody());
        this.nestedPush(body);
        this.accept(body);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body);
        this.pushSourceInfo(x2.getCondition().getSource());
        if (this.needSemi) {
            this.semi();
            this.newline();
        } else {
            this.space();
            this.needSemi = true;
        }
        this._while();
        this.space();
        this.leftParen();
        this.accept(x2.getCondition());
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitEmpty(@NotNull JsEmpty x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(18);
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x2) {
        JsLocationWithSource source;
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(19);
        }
        if ((source = x2.getSource()) == null && !(x2.getExpression() instanceof JsFunction)) {
            source = x2.getExpression().getSource();
        }
        this.pushSourceInfo(source);
        this.printCommentsBeforeNode(x2);
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x2);
        if (surroundWithParentheses) {
            this.leftParen();
        }
        this.accept(x2.getExpression());
        if (surroundWithParentheses) {
            this.rightParen();
        }
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitFor(@NotNull JsFor x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(20);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this._for();
        this.space();
        this.leftParen();
        if (x2.getInitExpression() != null) {
            this.accept(x2.getInitExpression());
        } else if (x2.getInitVars() != null) {
            this.accept(x2.getInitVars());
        }
        this.semi();
        if (x2.getCondition() != null) {
            this.space();
            this.accept(x2.getCondition());
        }
        this.semi();
        if (x2.getIncrementExpression() != null) {
            this.space();
            this.accept(x2.getIncrementExpression());
        }
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        JsStatement body = JsToStringGenerationVisitor.materialize(x2.getBody());
        this.nestedPush(body);
        if (body != null) {
            this.sourceLocationConsumer.pushSourceInfo(null);
            this.accept(body);
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.nestedPop(body);
    }

    @Override
    public void visitForIn(@NotNull JsForIn x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(21);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this._for();
        this.space();
        this.leftParen();
        if (x2.getIterVarName() != null) {
            this.var();
            this.space();
            this.nameDef(x2.getIterVarName());
            if (x2.getIterExpression() != null) {
                this.space();
                this.assignment();
                this.space();
                this.accept(x2.getIterExpression());
            }
        } else {
            this.accept(x2.getIterExpression());
        }
        this.space();
        this.p.print(CHARS_IN);
        this.space();
        this.accept(x2.getObjectExpression());
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        JsStatement body = JsToStringGenerationVisitor.materialize(x2.getBody());
        this.nestedPush(body);
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(body);
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(body);
    }

    @Override
    public void visitFunction(@NotNull JsFunction x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(22);
        }
        this.printCommentsBeforeNode(x2);
        if (x2.isEs6Arrow()) {
            this.printEs6Arrow(x2);
        } else {
            this.p.print(CHARS_FUNCTION);
            this.space();
            this.printFunction(x2);
        }
        this.printCommentsAfterNode(x2);
    }

    private void printFunctionParameterList(@NotNull List<JsParameter> parameters) {
        if (parameters == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(23);
        }
        this.leftParen();
        boolean notFirst = false;
        this.sourceLocationConsumer.pushSourceInfo(null);
        for (JsParameter param : parameters) {
            notFirst = this.sepCommaSpace(notFirst);
            this.accept(param);
        }
        this.sourceLocationConsumer.popSourceInfo();
        this.rightParen();
    }

    private void printFunction(@NotNull JsFunction x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(24);
        }
        if (x2.isStatic()) {
            this.p.print(CHARS_STATIC);
            this.space();
        }
        if (x2.isGetter()) {
            this.p.print(CHARS_GET);
            this.space();
        } else if (x2.isSetter()) {
            this.p.print(CHARS_SET);
            this.space();
        }
        if (x2.isGenerator()) {
            this.p.print('*');
        }
        if (x2.getName() != null) {
            this.nameOf(x2);
        }
        this.pushSourceInfo(x2.getSource());
        this.printFunctionParameterList(x2.getParameters());
        this.space();
        this.lineBreakAfterBlock = false;
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printJsBlock(x2.getBody(), true, x2.getBody().getSource());
        this.sourceLocationConsumer.popSourceInfo();
        this.popSourceInfo();
        this.needSemi = true;
    }

    private void printEs6Arrow(@NotNull JsFunction x2) {
        JsStatement singleStatement;
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(25);
        }
        this.pushSourceInfo(x2.getSource());
        this.printFunctionParameterList(x2.getParameters());
        this.space();
        this.arrow();
        this.space();
        JsBlock body = x2.getBody();
        if (body.getStatements().size() == 1 && (singleStatement = body.getStatements().get(0)) instanceof JsReturn) {
            JsReturn jsReturn = (JsReturn)singleStatement;
            jsReturn.getExpression().accept(this);
            return;
        }
        this.lineBreakAfterBlock = false;
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.printJsBlock(body, true, x2.getBody().getSource());
        this.sourceLocationConsumer.popSourceInfo();
        this.popSourceInfo();
        this.needSemi = true;
    }

    @Override
    public void visitClass(@NotNull JsClass x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(26);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_CLASS);
        this.space();
        if (x2.getName() != null) {
            this.nameOf(x2);
        }
        if (x2.getBaseClass() != null) {
            this.space();
            this.p.print(CHARS_EXTENDS);
            this.space();
            this.accept(x2.getBaseClass());
        }
        this.space();
        if (x2.getConstructor() == null && x2.getMembers().isEmpty()) {
            this.p.print("{}");
            this.newline();
        } else {
            this.blockOpen();
            if (x2.getConstructor() != null) {
                this.p.print(CHARS_CONSTRUCTOR);
                x2.getConstructor().setName(null);
                this.printFunction(x2.getConstructor());
                this.newline();
            }
            for (JsFunction m2 : x2.getMembers()) {
                this.printFunction(m2);
                this.newline();
            }
            this.blockClose();
        }
        this.needSemi = false;
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitIf(@NotNull JsIf x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(27);
        }
        this.printCommentsBeforeNode(x2);
        this.pushSourceInfo(x2.getSource());
        this._if();
        this.space();
        this.leftParen();
        this.accept(x2.getIfExpression());
        this.rightParen();
        this.popSourceInfo();
        this.printCommentsAfterNode(x2);
        JsStatement thenStmt = x2.getThenStatement();
        JsStatement elseStatement = x2.getElseStatement();
        if (elseStatement != null && JsToStringGenerationVisitor.isIfWithoutElse(thenStmt)) {
            thenStmt = new JsBlock(thenStmt);
        }
        this.nestedPush(thenStmt);
        if (thenStmt instanceof JsBlock && elseStatement != null) {
            this.lineBreakAfterBlock = false;
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(JsToStringGenerationVisitor.materialize(thenStmt));
        this.sourceLocationConsumer.popSourceInfo();
        this.nestedPop(thenStmt);
        if (elseStatement != null) {
            if (this.needSemi) {
                this.semi();
                this.newline();
            } else {
                this.space();
                this.needSemi = true;
            }
            this.p.print(CHARS_ELSE);
            boolean elseIf = elseStatement instanceof JsIf;
            if (!elseIf) {
                this.nestedPush(elseStatement);
            } else {
                this.space();
            }
            this.sourceLocationConsumer.pushSourceInfo(null);
            this.accept(JsToStringGenerationVisitor.materialize(elseStatement));
            this.sourceLocationConsumer.popSourceInfo();
            if (!elseIf) {
                this.nestedPop(elseStatement);
            }
        }
    }

    private static boolean isIfWithoutElse(@NotNull JsStatement statement) {
        if (statement == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(28);
        }
        while (statement instanceof JsIf) {
            JsIf ifStatement = (JsIf)statement;
            if (ifStatement.getElseStatement() == null) {
                return true;
            }
            statement = ifStatement.getElseStatement();
        }
        return false;
    }

    private static JsStatement materialize(JsStatement statement) {
        return statement instanceof JsCompositeBlock ? new JsBlock(statement) : statement;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(29);
        }
        this.pushSourceInfo(invocation.getSource());
        this.printCommentsBeforeNode(invocation);
        this.printPair(invocation, invocation.getQualifier());
        this.leftParen();
        this.printExpressions(invocation.getArguments());
        this.rightParen();
        this.printCommentsAfterNode(invocation);
        this.popSourceInfo();
    }

    @Override
    public void visitLabel(@NotNull JsLabel x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(30);
        }
        this.nameOf(x2);
        this._colon();
        this.space();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.accept(x2.getStatement());
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(31);
        }
        this.visitNameRef(nameRef, true);
    }

    public void visitNameRef(@NotNull JsNameRef nameRef, boolean withQualifier) {
        if (nameRef == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(32);
        }
        this.printCommentsBeforeNode(nameRef);
        this.p.maybeIndent();
        JsExpression qualifier = nameRef.getQualifier();
        if (qualifier != null && withQualifier) {
            boolean enclose = qualifier instanceof JsLiteral.JsValueLiteral ? qualifier instanceof JsNumberLiteral : JsToStringGenerationVisitor.parenCalc(nameRef, qualifier, false);
            if (enclose) {
                this.leftParen();
            }
            this.accept(qualifier);
            if (enclose) {
                this.rightParen();
            }
            this.p.print('.');
        }
        this.pushSourceInfo(nameRef.getSource());
        this.p.print(nameRef.getIdent());
        this.popSourceInfo();
        this.printCommentsAfterNode(nameRef);
    }

    @Override
    public void visitNew(@NotNull JsNew x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(33);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_NEW);
        this.space();
        JsExpression constructorExpression = x2.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(constructorExpression);
        if (needsParens) {
            this.leftParen();
        }
        this.accept(constructorExpression);
        if (needsParens) {
            this.rightParen();
        }
        this.leftParen();
        this.printExpressions(x2.getArguments());
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(34);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_NULL);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitInt(@NotNull JsIntLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(35);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(x2.value);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitDouble(@NotNull JsDoubleLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(36);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(x2.value);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitBigInt(@NotNull JsBigIntLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(37);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(x2.getValue().toString());
        this.p.print('n');
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral objectLiteral) {
        if (objectLiteral == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(38);
        }
        this.pushSourceInfo(objectLiteral.getSource());
        this.printCommentsBeforeNode(objectLiteral);
        this.p.print('{');
        if (objectLiteral.isMultiline()) {
            this.p.indentIn();
        }
        boolean notFirst = false;
        for (JsPropertyInitializer item : objectLiteral.getPropertyInitializers()) {
            if (notFirst) {
                this.p.print(',');
            }
            if (objectLiteral.isMultiline()) {
                this.newline();
            } else if (notFirst) {
                this.space();
            }
            notFirst = true;
            this.pushSourceInfo(item.getSource());
            JsExpression labelExpr = item.getLabelExpr();
            if (labelExpr instanceof JsStringLiteral) {
                JsStringLiteral stringLiteral = (JsStringLiteral)labelExpr;
                String value2 = stringLiteral.getValue();
                if (IdentifierPolicyKt.isValidES5Identifier(value2)) {
                    String escaped = IdentifierPolicyKt.getRESERVED_KEYWORDS().contains(value2) ? "'" + value2 + "'" : value2;
                    labelExpr = (JsExpression)new JsNameRef(escaped).withMetadataFrom(stringLiteral);
                }
                this.accept(labelExpr);
            } else if (labelExpr instanceof JsNumberLiteral || labelExpr instanceof JsBigIntLiteral) {
                this.accept(labelExpr);
            } else {
                this.leftSquare();
                this.accept(labelExpr);
                this.rightSquare();
            }
            this._colon();
            this.space();
            JsExpression valueExpr = item.getValueExpr();
            boolean wasEnclosed = this.parenPushIfCommaExpression(valueExpr);
            this.accept(valueExpr);
            if (wasEnclosed) {
                this.rightParen();
            }
            this.popSourceInfo();
        }
        if (objectLiteral.isMultiline()) {
            this.p.indentOut();
            this.newline();
        }
        this.p.print('}');
        this.printCommentsAfterNode(objectLiteral);
        this.popSourceInfo();
    }

    @Override
    public void visitParameter(@NotNull JsParameter x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(39);
        }
        this.pushSourceInfo(x2.getSource());
        this.nameOf(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(40);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        JsUnaryOperator op = x2.getOperator();
        JsExpression arg = x2.getArg();
        this.printPair(x2, arg);
        this.p.print(op.getSymbol());
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(41);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        JsUnaryOperator op = x2.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x2.getArg();
        if (JsToStringGenerationVisitor.spaceCalc(op, arg)) {
            this.space();
        }
        this.printPair(x2, arg);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitProgram(@NotNull JsProgram x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(42);
        }
        x2.acceptChildren(this);
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(43);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.slash();
        this.p.print(x2.getPattern());
        this.slash();
        String flags = x2.getFlags();
        if (flags != null) {
            this.p.print(flags);
        }
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitReturn(@NotNull JsReturn x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(44);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_RETURN);
        JsExpression expr = x2.getExpression();
        if (expr != null) {
            this.space();
            this.accept(expr);
        }
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(45);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(JsToStringGenerationVisitor.javaScriptString(x2.getValue()));
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visit(@NotNull JsSwitch x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(46);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_SWITCH);
        this.space();
        this.leftParen();
        this.accept(x2.getExpression());
        this.rightParen();
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
        this.sourceLocationConsumer.pushSourceInfo(null);
        this.space();
        this.blockOpen();
        this.acceptList(x2.getCases());
        this.blockClose();
        this.sourceLocationConsumer.popSourceInfo();
    }

    @Override
    public void visitThis(@NotNull JsThisRef x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(47);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_THIS);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitSuper(@NotNull JsSuperRef x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(48);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_SUPER);
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitThrow(@NotNull JsThrow x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(49);
        }
        this.pushSourceInfo(x2.getSource());
        this.printCommentsBeforeNode(x2);
        this.p.print(CHARS_THROW);
        this.space();
        this.accept(x2.getExpression());
        this.printCommentsAfterNode(x2);
        this.popSourceInfo();
    }

    @Override
    public void visitTry(@NotNull JsTry x2) {
        if (x2 == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(50);
        }
        this.printCommentsBeforeNode(x2);
        this.pushSourceInfo(x2.getSource());
        this.p.print(CHARS_TRY);
        this.space();
        this.lineBreakAfterBlock = false;
        this.popSourceInfo();
        this.accept(x2.getTryBlock());
        this.acceptList(x2.getCatches());
        JsBlock finallyBlock = x2.getFinallyBlock();
        if (finallyBlock != null) {
            this.p.print(CHARS_FINALLY);
            this.space();
            this.accept(finallyBlock);
        }
        this.printCommentsAfterNode(x2);
    }

    @Override
    public void visit(@NotNull JsVars.JsVar var) {
        if (var == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(51);
        }
        this.pushSourceInfo(var.getSource());
        this.printCommentsBeforeNode(var);
        this.nameOf(var);
        JsExpression initExpr = var.getInitExpression();
        if (initExpr != null) {
            this.space();
            this.assignment();
            this.space();
            boolean isEnclosed = this.parenPushIfCommaExpression(initExpr);
            this.accept(initExpr);
            if (isEnclosed) {
                this.rightParen();
            }
        }
        this.printCommentsAfterNode(var);
        this.popSourceInfo();
    }

    @Override
    public void visitVars(@NotNull JsVars vars) {
        if (vars == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(52);
        }
        this.pushSourceInfo(vars.getSource());
        this.printCommentsBeforeNode(vars);
        this.var();
        this.space();
        boolean sep = false;
        for (JsVars.JsVar var : vars) {
            if (sep) {
                if (vars.isMultiline()) {
                    this.newline();
                }
                this.p.print(',');
                this.space();
            } else {
                sep = true;
            }
            this.accept(var);
        }
        this.printCommentsAfterNode(vars);
        this.popSourceInfo();
    }

    @Override
    public void visitSingleLineComment(@NotNull JsSingleLineComment comment) {
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(53);
        }
        if (this.needSemi && this.insideComments) {
            this.semi();
            this.space();
        }
        this.p.print("//");
        this.p.print(comment.getText());
        this.newline();
        this.needSemi = false;
    }

    @Override
    public void visitMultiLineComment(@NotNull JsMultiLineComment comment) {
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(54);
        }
        List lines = StringsKt.lines((CharSequence)comment.getText());
        this.p.print("/*");
        this.p.print(((String)lines.get(0)).trim());
        for (int i2 = 1; i2 < lines.size(); ++i2) {
            this.newline();
            this.p.print(((String)lines.get(i2)).trim());
        }
        this.p.print("*/");
    }

    @Override
    public void visitDocComment(@NotNull JsDocComment comment) {
        boolean asSingleLine;
        if (comment == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(55);
        }
        boolean bl = asSingleLine = comment.getTags().size() == 1;
        if (!asSingleLine) {
            this.newline();
        }
        this.p.print("/**");
        if (asSingleLine) {
            this.space();
        } else {
            this.newline();
        }
        boolean notFirst = false;
        for (Map.Entry<String, Object> entry : comment.getTags().entrySet()) {
            if (notFirst) {
                this.newline();
                this.p.print(' ');
                this.p.print('*');
            } else {
                notFirst = true;
            }
            this.p.print('@');
            this.p.print(entry.getKey());
            Object value2 = entry.getValue();
            if (value2 != null) {
                this.space();
                if (value2 instanceof CharSequence) {
                    this.p.print((CharSequence)value2);
                } else {
                    this.visitNameRef((JsNameRef)value2);
                }
            }
            if (asSingleLine) continue;
            this.newline();
        }
        if (asSingleLine) {
            this.space();
        } else {
            this.newline();
        }
        this.p.print('*');
        this.p.print('/');
        if (asSingleLine) {
            this.space();
        }
    }

    @Override
    public void visitExport(@NotNull JsExport export) {
        if (export == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(56);
        }
        this.p.print("export");
        this.space();
        JsExport.Subject subject = export.getSubject();
        if (subject instanceof JsExport.Subject.All) {
            this.p.print("*");
        } else if (subject instanceof JsExport.Subject.Elements) {
            this.blockOpen();
            List<JsExport.Element> elements = ((JsExport.Subject.Elements)subject).getElements();
            for (JsExport.Element element : elements) {
                this.visitNameRef(element.getName());
                JsName alias = element.getAlias();
                if (alias != null) {
                    this.p.print(" as ");
                    this.nameDef(alias);
                }
                this.p.print(',');
                this.p.newline();
            }
            this.p.indentOut();
            this.p.print('}');
        }
        if (export.getFromModule() != null) {
            this.p.print(" from ");
            this.p.print(JsToStringGenerationVisitor.javaScriptString(export.getFromModule()));
        }
        this.needSemi = true;
    }

    @Override
    public void visitImport(@NotNull JsImport jsImport) {
        if (jsImport == null) {
            JsToStringGenerationVisitor.$$$reportNull$$$0(57);
        }
        JsImport.Target target = jsImport.getTarget();
        this.p.print("import ");
        if (target instanceof JsImport.Target.Default) {
            this.visitNameRef(((JsImport.Target.Default)target).getName());
        } else if (target instanceof JsImport.Target.All) {
            this.p.print("* as ");
            this.visitNameRef(((JsImport.Target.All)target).getAlias());
        } else if (target instanceof JsImport.Target.Elements) {
            List<JsImport.Element> elements = ((JsImport.Target.Elements)target).getElements();
            this.p.print("{");
            boolean isMultiline = elements.size() > 1;
            this.p.indentIn();
            if (isMultiline) {
                this.newline();
            } else {
                this.space();
            }
            for (JsImport.Element element : elements) {
                this.nameDef(element.getName());
                JsNameRef alias = element.getAlias();
                if (alias != null) {
                    this.p.print(" as ");
                    this.visitNameRef(alias);
                }
                if (isMultiline) {
                    this.p.print(',');
                    this.newline();
                    continue;
                }
                this.space();
            }
            this.p.indentOut();
            this.p.print("}");
        }
        if (target != JsImport.Target.Effect.INSTANCE) {
            this.p.print(" from ");
        }
        this.p.print(JsToStringGenerationVisitor.javaScriptString(jsImport.getModule()));
    }

    private void newline() {
        this.p.newline();
        this.sourceLocationConsumer.newLine();
    }

    private void pushSourceInfo(JsLocationWithSource location) {
        this.p.maybeIndent();
        this.sourceInfoStack.add(location);
        if (location != null) {
            this.sourceLocationConsumer.pushSourceInfo(location);
        }
    }

    private void printCommentsBeforeNode(JsNode x2) {
        this.printComments(x2.getCommentsBeforeNode(), false);
    }

    private void printCommentsAfterNode(JsNode x2) {
        this.printComments(x2.getCommentsAfterNode(), true);
    }

    private void printComments(List<JsComment> comments, boolean isAfterNode) {
        if (comments == null) {
            return;
        }
        boolean previousNeedSemi = this.needSemi;
        this.needSemi = isAfterNode;
        this.insideComments = true;
        for (JsComment comment : comments) {
            comment.accept(this);
        }
        this.insideComments = false;
        if (!isAfterNode) {
            this.needSemi = previousNeedSemi;
        }
    }

    private void popSourceInfo() {
        if (!this.sourceInfoStack.isEmpty() && this.sourceInfoStack.remove(this.sourceInfoStack.size() - 1) != null) {
            this.sourceLocationConsumer.popSourceInfo();
        }
    }

    private void printJsBlock(JsBlock x2, boolean finalNewline, @Nullable JsLocationWithSource defaultClosingBraceLocation) {
        boolean needBraces;
        if (!this.lineBreakAfterBlock) {
            finalNewline = false;
            this.lineBreakAfterBlock = true;
        }
        this.printCommentsBeforeNode(x2);
        boolean bl = needBraces = !x2.isTransparent();
        if (needBraces) {
            this.sourceLocationConsumer.pushSourceInfo(x2.getSource());
            this.blockOpen();
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.sourceLocationConsumer.pushSourceInfo(null);
        Iterator<JsStatement> iterator2 = x2.getStatements().iterator();
        while (iterator2.hasNext()) {
            boolean lastStatement;
            boolean isGlobal = x2.isTransparent() || this.globalBlocks.contains(x2);
            JsStatement statement = iterator2.next();
            if (statement instanceof JsEmpty) continue;
            this.needSemi = true;
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && statement instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)statement);
            }
            this.accept(statement);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(statement);
            }
            if (!this.needSemi) continue;
            boolean functionStmt = statement instanceof JsExpressionStatement && ((JsExpressionStatement)statement).getExpression() instanceof JsFunction;
            boolean bl2 = lastStatement = !iterator2.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(statement);
            if (functionStmt) {
                if (lastStatement) {
                    this.newline();
                    continue;
                }
                this.newline();
                continue;
            }
            if (lastStatement) {
                this.p.print(';');
            } else {
                this.semi();
            }
            this.newline();
        }
        if (needBraces) {
            this.p.indentOut();
            this.sourceLocationConsumer.popSourceInfo();
            JsLocationWithSource closingBraceLocation = x2.getClosingBraceSource();
            if (closingBraceLocation == null) {
                closingBraceLocation = defaultClosingBraceLocation;
            }
            if (closingBraceLocation != null) {
                this.pushSourceInfo(closingBraceLocation);
            }
            this.p.print('}');
            if (closingBraceLocation != null) {
                this.popSourceInfo();
            }
            if (finalNewline) {
                this.newline();
            }
        } else {
            this.sourceLocationConsumer.popSourceInfo();
        }
        this.needSemi = false;
        this.printCommentsAfterNode(x2);
    }

    private void assignment() {
        this.p.print('=');
    }

    private void arrow() {
        this.p.print("=>");
    }

    private void blockClose() {
        this.p.indentOut();
        this.p.print('}');
        this.newline();
    }

    private void blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this.newline();
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void leftParen() {
        this.p.print('(');
    }

    private void leftSquare() {
        this.p.print('[');
    }

    private void nameDef(JsName name2) {
        this.p.print(name2.getIdent());
    }

    private void nameOf(HasName hasName) {
        this.nameDef(hasName.getName());
    }

    private boolean nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean nestedPush(JsStatement statement) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            this.newline();
            this.p.indentIn();
        } else {
            this.space();
        }
        return push;
    }

    private static boolean parenCalc(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent2);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean _parenPopOrSpace(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPop = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPop) {
            this.rightParen();
        } else {
            this.space();
        }
        return doPop;
    }

    private boolean parenPush(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean parenPushIfCommaExpression(JsExpression x2) {
        boolean doPush;
        boolean bl = doPush = x2 instanceof JsBinaryOperation && ((JsBinaryOperation)x2).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent2, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent2, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        } else {
            this.space();
        }
        return doPush;
    }

    private void rightParen() {
        this.p.print(')');
    }

    private void rightSquare() {
        this.p.print(']');
    }

    private void semi() {
        this.p.print(';');
    }

    private boolean sepCommaSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this.space();
        }
        return true;
    }

    private void slash() {
        this.p.print('/');
    }

    private void space() {
        this.p.print(' ');
    }

    private static boolean spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            return binary.getOperator().getPrecedence() > op.getPrecedence() && JsToStringGenerationVisitor.spaceCalc(op, binary.getArg1());
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && (op2 == JsUnaryOperator.DEC || op2 == JsUnaryOperator.NEG) || op == JsBinaryOperator.ADD && op2 == JsUnaryOperator.INC;
        }
        if ((arg instanceof JsNumberLiteral || arg instanceof JsBigIntLiteral) && (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG)) {
            if (arg instanceof JsIntLiteral) {
                return ((JsIntLiteral)arg).value < 0;
            }
            if (arg instanceof JsBigIntLiteral) {
                return ((JsBigIntLiteral)arg).getValue().compareTo(BigInteger.ZERO) < 0;
            }
            assert (arg instanceof JsDoubleLiteral);
            return ((JsDoubleLiteral)arg).value < 0.0;
        }
        return false;
    }

    private void var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLocationConsumer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryOperation";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "export";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsImport";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/backend/JsToStringGenerationVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArray";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBoolean";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBreak";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitContinue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitYield";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCatch";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditional";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDebugger";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDefault";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEmpty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpressionStatement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForIn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunction";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "printFunctionParameterList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "printFunction";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "printEs6Arrow";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClass";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIf";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "isIfWithoutElse";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvocation";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLabel";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameRef";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNew";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNull";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInt";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDouble";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBigInt";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectLiteral";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParameter";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixOperation";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixOperation";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "visitProgram";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRegExp";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturn";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "visitString";
                break;
            }
            case 46: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThis";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSuper";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThrow";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTry";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVars";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSingleLineComment";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMultiLineComment";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocComment";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExport";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "visitImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

