/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CapabilitiesResolution;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.CachePolicy;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ModuleComponentSelectorParsers;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.DefaultComponentSelectionRules;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ModuleForcingResolveRule;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NormalizedTimeUnit;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TimeUnitsParser;
import org.gradle.vcs.internal.VcsResolver;
import org.jspecify.annotations.Nullable;

public class DefaultResolutionStrategy
implements ResolutionStrategyInternal {
    private static final String ASSUME_FLUID_DEPENDENCIES = "org.gradle.resolution.assumeFluidDependencies";
    private static final NotationParser<Object, Set<ModuleComponentSelector>> FORCED_MODULES_PARSER = ModuleComponentSelectorParsers.multiParser("force()");
    private final Set<Object> forcedModules = new LinkedHashSet<Object>();
    private @Nullable Set<ModuleComponentSelector> parsedForcedModules;
    private ConflictResolution conflictResolution = ConflictResolution.latest;
    private final DefaultComponentSelectionRules componentSelectionRules;
    private final CachePolicy cachePolicy;
    private final DependencySubstitutionsInternal dependencySubstitutions;
    private final GlobalDependencyResolutionRules globalDependencySubstitutionRules;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final VcsResolver vcsResolver;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final CapabilitiesResolutionInternal capabilitiesResolution;
    private final ObjectFactory objectFactory;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private boolean dependencyLockingEnabled = false;
    private boolean assumeFluidDependencies;
    private ResolutionStrategy.SortOrder sortOrder = ResolutionStrategy.SortOrder.DEFAULT;
    private boolean failOnDynamicVersions;
    private boolean failOnChangingVersions;
    private boolean verifyDependencies = true;
    private final Property<Boolean> useGlobalDependencySubstitutionRules;
    private boolean selectableVariantResults = false;
    private boolean keepStateRequiredForGraphResolution = false;

    @Inject
    public DefaultResolutionStrategy(CachePolicy cachePolicy, DependencySubstitutionsInternal dependencySubstitutions, GlobalDependencyResolutionRules globalDependencySubstitutionRules, VcsResolver vcsResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ComponentSelectorConverter componentSelectorConverter, DependencyLockingProvider dependencyLockingProvider, CapabilitiesResolutionInternal capabilitiesResolution, ObjectFactory objectFactory) {
        this.cachePolicy = cachePolicy;
        this.dependencySubstitutions = dependencySubstitutions;
        this.globalDependencySubstitutionRules = globalDependencySubstitutionRules;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.componentSelectionRules = new DefaultComponentSelectionRules(moduleIdentifierFactory);
        this.vcsResolver = vcsResolver;
        this.componentSelectorConverter = componentSelectorConverter;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.capabilitiesResolution = capabilitiesResolution;
        this.objectFactory = objectFactory;
        this.useGlobalDependencySubstitutionRules = objectFactory.property(Boolean.class).convention((Object)true);
        this.assumeFluidDependencies = Boolean.getBoolean(ASSUME_FLUID_DEPENDENCIES);
    }

    @Override
    public void maybeDiscardStateRequiredForGraphResolution() {
        if (!this.keepStateRequiredForGraphResolution) {
            this.dependencySubstitutions.discard();
        }
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
        this.cachePolicy.setMutationValidator(validator);
        this.componentSelectionRules.setMutationValidator(validator);
        this.dependencySubstitutions.setMutationValidator(validator);
    }

    public Set<ModuleVersionSelector> getForcedModules() {
        return (Set)this.getParsedForcedModules().stream().map(DefaultModuleVersionSelector::newSelector).collect(ImmutableSet.toImmutableSet());
    }

    private Set<ModuleComponentSelector> getParsedForcedModules() {
        if (this.parsedForcedModules == null) {
            this.parsedForcedModules = (Set)FORCED_MODULES_PARSER.parseNotation(this.forcedModules);
        }
        return this.parsedForcedModules;
    }

    public ResolutionStrategy failOnVersionConflict() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.conflictResolution = ConflictResolution.strict;
        return this;
    }

    public ResolutionStrategy failOnDynamicVersions() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.failOnDynamicVersions = true;
        return this;
    }

    public ResolutionStrategy failOnChangingVersions() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.failOnChangingVersions = true;
        return this;
    }

    public ResolutionStrategy failOnNonReproducibleResolution() {
        this.failOnChangingVersions();
        this.failOnDynamicVersions();
        return this;
    }

    public void preferProjectModules() {
        this.conflictResolution = ConflictResolution.preferProjectModules;
    }

    public ResolutionStrategy activateDependencyLocking() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyLockingEnabled = true;
        return this;
    }

    public ResolutionStrategy deactivateDependencyLocking() {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyLockingEnabled = false;
        return this;
    }

    public void sortArtifacts(ResolutionStrategy.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ResolutionStrategy capabilitiesResolution(Action<? super CapabilitiesResolution> action) {
        action.execute((Object)this.capabilitiesResolution);
        return this;
    }

    public CapabilitiesResolution getCapabilitiesResolution() {
        return this.capabilitiesResolution;
    }

    @Override
    public ResolutionStrategy.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public DefaultResolutionStrategy force(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.parsedForcedModules = null;
        Collections.addAll(this.forcedModules, moduleVersionSelectorNotations);
        return this;
    }

    public ResolutionStrategy eachDependency(Action<? super DependencyResolveDetails> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencySubstitutions.allWithDependencyResolveDetails(rule, this.componentSelectorConverter);
        return this;
    }

    @Override
    public ImmutableActionSet<DependencySubstitutionInternal> getDependencySubstitutionRule() {
        ImmutableActionSet result = ImmutableActionSet.empty();
        Set<ModuleComponentSelector> forcedModules = this.getParsedForcedModules();
        if (!forcedModules.isEmpty()) {
            result = result.add((Action)new ModuleForcingResolveRule(forcedModules));
        }
        result = result.add(this.dependencySubstitutions.getRuleAction());
        if (((Boolean)this.useGlobalDependencySubstitutionRules.get()).booleanValue()) {
            result = result.add(this.globalDependencySubstitutionRules.getDependencySubstitutionRules().getRuleAction());
        }
        return result;
    }

    @Override
    public void assumeFluidDependencies() {
        this.assumeFluidDependencies = true;
    }

    @Override
    public boolean resolveGraphToDetermineTaskDependencies() {
        return this.assumeFluidDependencies || this.dependencySubstitutions.rulesMayAddProjectDependency() || (Boolean)this.useGlobalDependencySubstitutionRules.get() != false && this.globalDependencySubstitutionRules.getDependencySubstitutionRules().rulesMayAddProjectDependency() || this.vcsResolver.hasRules();
    }

    public DefaultResolutionStrategy setForcedModules(Object ... moduleVersionSelectorNotations) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.forcedModules.clear();
        this.force(moduleVersionSelectorNotations);
        return this;
    }

    @Override
    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public void cacheDynamicVersionsFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheDynamicVersionsFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit units) {
        this.cachePolicy.cacheDynamicVersionsFor(value, units);
    }

    public void cacheChangingModulesFor(int value, String units) {
        NormalizedTimeUnit timeUnit = new TimeUnitsParser().parseNotation((CharSequence)units, value);
        this.cacheChangingModulesFor(timeUnit.getValue(), timeUnit.getTimeUnit());
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.cachePolicy.cacheChangingModulesFor(value, units);
    }

    @Override
    public ComponentSelectionRulesInternal getComponentSelection() {
        return this.componentSelectionRules;
    }

    public ResolutionStrategy componentSelection(Action<? super ComponentSelectionRules> action) {
        action.execute((Object)this.componentSelectionRules);
        return this;
    }

    @Override
    public DependencySubstitutionsInternal getDependencySubstitution() {
        return this.dependencySubstitutions;
    }

    public ResolutionStrategy dependencySubstitution(Action<? super DependencySubstitutions> action) {
        action.execute((Object)this.dependencySubstitutions);
        return this;
    }

    public Property<Boolean> getUseGlobalDependencySubstitutionRules() {
        return this.useGlobalDependencySubstitutionRules;
    }

    @Override
    public DefaultResolutionStrategy copy() {
        DefaultResolutionStrategy out = new DefaultResolutionStrategy(this.cachePolicy.copy(), this.dependencySubstitutions.copy(), this.globalDependencySubstitutionRules, this.vcsResolver, this.moduleIdentifierFactory, this.componentSelectorConverter, this.dependencyLockingProvider, this.capabilitiesResolution, this.objectFactory);
        if (this.conflictResolution == ConflictResolution.strict) {
            out.failOnVersionConflict();
        } else if (this.conflictResolution == ConflictResolution.preferProjectModules) {
            out.preferProjectModules();
        }
        out.setForcedModules(this.forcedModules);
        for (SpecRuleAction<? super ComponentSelection> ruleAction : this.componentSelectionRules.getRules()) {
            out.getComponentSelection().addRule(ruleAction);
        }
        if (this.isDependencyLockingEnabled()) {
            out.activateDependencyLocking();
        }
        if (this.isFailingOnDynamicVersions()) {
            out.failOnDynamicVersions();
        }
        if (this.isFailingOnChangingVersions()) {
            out.failOnChangingVersions();
        }
        if (!this.isDependencyVerificationEnabled()) {
            out.disableDependencyVerification();
        }
        out.getUseGlobalDependencySubstitutionRules().convention((Object)((Boolean)this.useGlobalDependencySubstitutionRules.get()));
        return out;
    }

    @Override
    public DependencyLockingProvider getDependencyLockingProvider() {
        if (this.dependencyLockingEnabled) {
            return this.dependencyLockingProvider;
        }
        throw new IllegalStateException("Dependency locking is not enabled");
    }

    @Override
    public boolean isDependencyLockingEnabled() {
        return this.dependencyLockingEnabled;
    }

    @Override
    public CapabilitiesResolutionInternal getCapabilitiesResolutionRules() {
        return this.capabilitiesResolution;
    }

    @Override
    public boolean isFailingOnDynamicVersions() {
        return this.failOnDynamicVersions;
    }

    @Override
    public boolean isFailingOnChangingVersions() {
        return this.failOnChangingVersions;
    }

    @Override
    public boolean isDependencyVerificationEnabled() {
        return this.verifyDependencies;
    }

    public ResolutionStrategy disableDependencyVerification() {
        this.verifyDependencies = false;
        return this;
    }

    public ResolutionStrategy enableDependencyVerification() {
        this.verifyDependencies = true;
        return this;
    }

    @Override
    public void setIncludeAllSelectableVariantResults(boolean selectableVariantResults) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.selectableVariantResults = selectableVariantResults;
    }

    @Override
    public boolean getIncludeAllSelectableVariantResults() {
        return this.selectableVariantResults;
    }

    @Override
    public void setKeepStateRequiredForGraphResolution(boolean keepStateRequiredForGraphResolution) {
        this.keepStateRequiredForGraphResolution = keepStateRequiredForGraphResolution;
    }
}

