/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultOptions;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultWriter;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.SafeFileLocationUtils;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Binary2JUnitXmlReportGenerator {
    private static final String REPORT_FILE_PREFIX = "TEST-";
    private static final String REPORT_FILE_EXTENSION = ".xml";
    private final File testResultsDir;
    private final TestResultsProvider testResultsProvider;
    @VisibleForTesting
    JUnitXmlResultWriter xmlWriter;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Logger LOG = Logging.getLogger(Binary2JUnitXmlReportGenerator.class);

    @Inject
    public Binary2JUnitXmlReportGenerator(BuildOperationRunner buildOperationRunner, BuildOperationExecutor buildOperationExecutor, HostnameLookup hostnameLookup, File testResultsDir, TestResultsProvider testResultsProvider, JUnitXmlResultOptions options) {
        this.testResultsDir = testResultsDir;
        this.testResultsProvider = testResultsProvider;
        this.xmlWriter = new JUnitXmlResultWriter(hostnameLookup.getHostname(), testResultsProvider, options);
        this.buildOperationRunner = buildOperationRunner;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public void generate() {
        Timer clock = Time.startTimer();
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                File[] oldXmlFiles;
                for (File oldXmlFile : oldXmlFiles = Binary2JUnitXmlReportGenerator.this.testResultsDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("TEST") && name.endsWith(Binary2JUnitXmlReportGenerator.REPORT_FILE_EXTENSION);
                    }
                })) {
                    GFileUtils.deleteQuietly((File)oldXmlFile);
                }
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Delete old JUnit XML results");
            }
        });
        ArrayList allResults = new ArrayList();
        this.testResultsProvider.visitClasses((Action<? super TestClassResult>)((Action)allResults::add));
        HashMap<String, Integer> classNameCounts = new HashMap<String, Integer>();
        for (TestClassResult result : allResults) {
            classNameCounts.merge(result.getClassName(), 1, Integer::sum);
        }
        HashMap classNameCurrentIndex = new HashMap();
        this.buildOperationExecutor.runAll(queue -> {
            for (TestClassResult result : allResults) {
                String fileName;
                String className = result.getClassName();
                if ((Integer)classNameCounts.get(className) > 1) {
                    int index = classNameCurrentIndex.merge(className, 1, Integer::sum);
                    fileName = Binary2JUnitXmlReportGenerator.getReportFileName(className, index);
                } else {
                    fileName = Binary2JUnitXmlReportGenerator.getReportFileName(className, 0);
                }
                File reportFile = new File(this.testResultsDir, fileName);
                queue.add((BuildOperation)new JUnitXmlReportFileGenerator(result, reportFile, this.xmlWriter));
            }
        });
        LOG.info("Finished generating test XML results ({}) into: {}", (Object)clock.getElapsed(), (Object)this.testResultsDir);
    }

    private static String getReportFileName(String className, int index) {
        String suffix = index > 0 ? "-" + index : "";
        return SafeFileLocationUtils.toSafeFileName((String)(REPORT_FILE_PREFIX + className + suffix + REPORT_FILE_EXTENSION), (boolean)false);
    }

    private static class JUnitXmlReportFileGenerator
    implements RunnableBuildOperation {
        private final TestClassResult result;
        private final File reportFile;
        private final JUnitXmlResultWriter xmlWriter;

        public JUnitXmlReportFileGenerator(TestClassResult result, File reportFile, JUnitXmlResultWriter xmlWriter) {
            this.result = result;
            this.reportFile = reportFile;
            this.xmlWriter = xmlWriter;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)"Generate junit XML test report for ".concat(this.result.getClassName()));
        }

        public void run(BuildOperationContext context) {
            try (FileOutputStream output = new FileOutputStream(this.reportFile);){
                this.xmlWriter.write(this.result, output);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not write XML test results for %s to file %s.", this.result.getClassName(), this.reportFile), (Throwable)e);
            }
        }
    }
}

