/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.jspecify.annotations.Nullable;

class PluginArtifactRepository
implements ArtifactRepositoryInternal,
ContentFilteringRepository,
ResolutionAwareRepository {
    private static final String REPOSITORY_NAME_PREFIX = "__plugin_repository__";
    private final ArtifactRepositoryInternal delegate;
    private final ResolutionAwareRepository resolutionAwareDelegate;
    private final RepositoryContentDescriptorInternal repositoryContentDescriptor;

    PluginArtifactRepository(ArtifactRepository delegate) {
        this.delegate = (ArtifactRepositoryInternal)delegate;
        this.resolutionAwareDelegate = (ResolutionAwareRepository)delegate;
        this.repositoryContentDescriptor = this.delegate.getRepositoryDescriptorCopy();
    }

    public String getName() {
        return REPOSITORY_NAME_PREFIX + this.delegate.getName();
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void content(Action<? super RepositoryContentDescriptor> configureAction) {
        configureAction.execute((Object)this.repositoryContentDescriptor);
    }

    public Action<? super ArtifactResolutionDetails> getContentFilter() {
        return this.repositoryContentDescriptor.toContentFilter();
    }

    public @Nullable Set<String> getIncludedConfigurations() {
        return this.repositoryContentDescriptor.getIncludedConfigurations();
    }

    public @Nullable Set<String> getExcludedConfigurations() {
        return this.repositoryContentDescriptor.getExcludedConfigurations();
    }

    public @Nullable Map<Attribute<Object>, Set<Object>> getRequiredAttributes() {
        return this.repositoryContentDescriptor.getRequiredAttributes();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public ConfiguredModuleComponentRepository createResolver() {
        return this.resolutionAwareDelegate.createResolver();
    }

    public RepositoryDescriptor getDescriptor() {
        return this.resolutionAwareDelegate.getDescriptor();
    }

    public void onAddToContainer(NamedDomainObjectCollection<ArtifactRepository> container) {
        this.delegate.onAddToContainer(container);
    }

    public RepositoryContentDescriptorInternal createRepositoryDescriptor(VersionParser versionParser) {
        return this.delegate.createRepositoryDescriptor(versionParser);
    }

    public RepositoryContentDescriptorInternal getRepositoryDescriptorCopy() {
        return this.repositoryContentDescriptor.asMutableCopy();
    }
}

