/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopsLowering;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.MemoizedValueClassAbstractReplacements;
import org.jetbrains.kotlin.backend.jvm.MemoizedValueClassAbstractReplacementsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.CollectionStubMethodLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmBuiltInsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmSingleAbstractMethodLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmValueClassAbstractLowering;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@PhaseDescription(name="InlineClasses", prerequisite={ForLoopsLowering.class, JvmBuiltInsLowering.class, CollectionStubMethodLowering.class, JvmSingleAbstractMethodLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0016J\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002J(\u0010'\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0019H\u0014J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020!0+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0014H\u0014J\u001c\u0010.\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030/2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030/H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002012\u0006\u00102\u001a\u000205H\u0016J*\u00106\u001a\u0002012\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\b\b\u0002\u0010;\u001a\u00020\u0019H\u0002J\f\u0010<\u001a\u00020-*\u00020-H\u0016J\u0010\u0010=\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0016J\f\u0010>\u001a\u000201*\u000201H\u0002J\u001e\u0010?\u001a\u0004\u0018\u000101*\u00020@2\u0006\u0010A\u001a\u0002012\u0006\u0010B\u001a\u000201H\u0002J\u0010\u0010C\u001a\u0002012\u0006\u00102\u001a\u00020DH\u0016J\u0010\u0010K\u001a\u0002012\u0006\u00102\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u0002012\u0006\u00102\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u0002012\u0006\u00102\u001a\u00020PH\u0016J\u0018\u0010Q\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020-H\u0002J$\u0010S\u001a\u00020\u000f*\u00020\u001a2\u0006\u0010R\u001a\u00020-2\u0006\u0010T\u001a\u00020-2\u0006\u0010U\u001a\u00020\u0014H\u0002J\u0018\u0010V\u001a\b\u0012\u0004\u0012\u00020W0+*\b\u0012\u0004\u0012\u00020W0+H\u0002J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010Y\u001a\u00020\u000f2\u0006\u0010Z\u001a\u00020\u001aH\u0002J\u0010\u0010[\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010E\u001a\u00020\u0019*\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0018\u0010G\u001a\u00020\u0019*\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010FR\u0018\u0010H\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006\\"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "replacements", "Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "getReplacements", "()Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "valueMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "addBindingsFor", "", "original", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "replacement", "createBridgeDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "source", "mangledName", "Lorg/jetbrains/kotlin/name/Name;", "isSpecificLoweringLogicApplicable", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "specificMangle", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering$SpecificMangle;", "getSpecificMangle", "()Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering$SpecificMangle;", "visitClassNewDeclarationsWhenParallel", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitClassNewDeclarationsWhenParallel$backend_jvm_lower", "visitClassNew", "handleSpecificNewClass", "addJvmInlineAnnotation", "valueClass", "createBridgeBody", "target", "inverted", "transformSecondaryConstructorFlat", "", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReplacement", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "coerceInlineClasses", "argument", "from", "Lorg/jetbrains/kotlin/ir/types/IrType;", "to", "skipCast", "withAddedMarkerParameterToNonExposedConstructor", "createExposedConstructor", "coerceToUnboxed", "specializeEqualsCall", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "left", "right", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isEqualsMethodCallOnInlineClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isEqEqCallOnInlineClass", "canUseSpecializedEqMethod", "getCanUseSpecializedEqMethod", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "buildPrimaryInlineClassConstructor", "irConstructor", "addExposedForJavaConstructor", "primaryConstructor", "function", "withoutJvmNameAnnotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "buildBoxFunction", "buildUnboxFunction", "irClass", "buildSpecializedEqualsMethodIfNeeded", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmInlineClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmInlineClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 8 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 9 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 10 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 11 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 12 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n*L\n1#1,658:1\n269#2,4:659\n369#2,7:694\n315#2,4:701\n321#2:730\n315#2,13:731\n369#2,7:746\n321#2:789\n315#2,13:790\n321#2:813\n315#2,13:814\n1#3:663\n406#4,5:664\n411#4:672\n406#4,5:685\n411#4:693\n1634#5,3:669\n1869#5,2:673\n1869#5,2:682\n1634#5,3:690\n1869#5,2:705\n1869#5,2:744\n808#5,11:761\n827#5:772\n855#5,2:773\n1869#5,2:775\n1869#5,2:803\n96#6:675\n96#6:707\n96#6:753\n96#6:805\n96#6:827\n247#7,5:676\n247#7,5:708\n247#7,5:754\n247#7,5:806\n247#7,5:828\n76#8:681\n77#8:684\n76#8,2:713\n76#8,2:759\n76#8,2:787\n76#8,2:811\n76#8,2:833\n76#8,2:845\n379#9,13:715\n418#9,10:777\n418#9,10:835\n133#10,2:728\n350#11,12:847\n350#11,12:863\n47#12,4:859\n*S KotlinDebug\n*F\n+ 1 JvmInlineClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering\n*L\n70#1:659,4\n283#1:694,7\n292#1:701,4\n468#1:730\n468#1:731,13\n478#1:746,7\n529#1:789\n529#1:790,13\n557#1:813\n557#1:814,13\n158#1:664,5\n158#1:672\n226#1:685,5\n226#1:693\n158#1:669,3\n167#1:673,2\n174#1:682,2\n226#1:690,3\n298#1:705,2\n476#1:744,2\n500#1:761,11\n501#1:772\n501#1:773,2\n503#1:775,2\n537#1:803,2\n168#1:675\n307#1:707\n486#1:753\n539#1:805\n565#1:827\n168#1:676,5\n307#1:708,5\n486#1:754,5\n539#1:806,5\n565#1:828,5\n168#1:681\n168#1:684\n307#1:713,2\n486#1:759,2\n504#1:787,2\n539#1:811,2\n565#1:833,2\n608#1:845,2\n356#1:715,13\n504#1:777,10\n608#1:835,10\n356#1:728,2\n623#1:847,12\n344#1:863,12\n110#1:859,4\n*E\n"})
public final class JvmInlineClassLowering
extends JvmValueClassAbstractLowering {
    @NotNull
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;

    public JvmInlineClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.valueMap = new LinkedHashMap();
    }

    @Override
    @NotNull
    public MemoizedValueClassAbstractReplacements getReplacements() {
        return this.getContext().getInlineClassReplacements();
    }

    @Override
    protected void addBindingsFor(@NotNull IrFunction original, @NotNull IrFunction replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        for (Pair pair : CollectionsKt.zip((Iterable)original.getParameters(), (Iterable)replacement.getParameters())) {
            IrValueParameter param = (IrValueParameter)pair.component1();
            IrValueParameter newParam = (IrValueParameter)pair.component2();
            this.valueMap.put(param.getSymbol(), newParam);
        }
    }

    @Override
    @NotNull
    public IrSimpleFunction createBridgeDeclaration(@NotNull IrSimpleFunction source, @NotNull IrSimpleFunction replacement, @NotNull Name mangledName) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Intrinsics.checkNotNullParameter((Object)mangledName, (String)"mangledName");
        IrFactory $this$buildFun$iv = this.getContext().getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createBridgeDeclaration_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$createBridgeDeclaration_u24lambda_u240.updateFrom(source);
        $this$createBridgeDeclaration_u24lambda_u240.setName(mangledName);
        $this$createBridgeDeclaration_u24lambda_u240.setReturnType(source.getReturnType());
        IrSimpleFunction $this$createBridgeDeclaration_u24lambda_u241 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        boolean bl3 = false;
        IrUtilsKt.copyValueAndTypeParametersFrom($this$createBridgeDeclaration_u24lambda_u241, source);
        if (JvmIrUtilsKt.shouldBeExposedByAnnotationOrFlag(source, this.getContext().getConfig().getLanguageVersionSettings()) && !Intrinsics.areEqual((Object)source.getOrigin(), (Object)IrDeclarationOrigin.Companion.getGENERATED_SINGLE_FIELD_VALUE_CLASS_MEMBER())) {
            $this$createBridgeDeclaration_u24lambda_u241.setAnnotations(this.withoutJvmNameAnnotation(MemoizedValueClassAbstractReplacementsKt.withJvmExposeBoxedAnnotation(source.getAnnotations(), source, this.getContext())));
        } else {
            $this$createBridgeDeclaration_u24lambda_u241.setAnnotations(source.getAnnotations());
        }
        source.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withoutJvmExposeBoxedAnnotation(source.getAnnotations()));
        $this$createBridgeDeclaration_u24lambda_u241.setParent(source.getParent());
        IrDeclarationsKt.copyAttributes$default($this$createBridgeDeclaration_u24lambda_u241, source, false, 2, null);
        return irSimpleFunction;
    }

    @Override
    public boolean isSpecificLoweringLogicApplicable(@NotNull IrClass $this$isSpecificLoweringLogicApplicable) {
        Intrinsics.checkNotNullParameter((Object)$this$isSpecificLoweringLogicApplicable, (String)"<this>");
        return IrDeclarationsKt.isSingleFieldValueClass($this$isSpecificLoweringLogicApplicable);
    }

    @Override
    @NotNull
    protected JvmValueClassAbstractLowering.SpecificMangle getSpecificMangle() {
        return JvmValueClassAbstractLowering.SpecificMangle.Inline;
    }

    @Override
    public void visitClassNewDeclarationsWhenParallel$backend_jvm_lower(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    @Override
    @NotNull
    public IrClass visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration);
        if (irConstructor != null) {
            IrConstructor it = irConstructor;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = this.getReplacements().getReplacementFunction(it);
            if (irSimpleFunction != null) {
                IrSimpleFunction replacement = irSimpleFunction;
                boolean bl2 = false;
                this.addBindingsFor(it, replacement);
            }
        }
        TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)arg_0 -> JvmInlineClassLowering.visitClassNew$lambda$1(this, arg_0)));
        if (this.isSpecificLoweringLogicApplicable(declaration)) {
            this.handleSpecificNewClass(declaration);
        }
        declaration.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withoutJvmExposeBoxedAnnotation(declaration.getAnnotations()));
        return declaration;
    }

    @Override
    public void handleSpecificNewClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructor irConstructor2 = irConstructor;
        CollectionsKt.removeAll(declaration.getDeclarations(), arg_0 -> JvmInlineClassLowering.handleSpecificNewClass$lambda$0(irConstructor2, arg_0));
        this.buildPrimaryInlineClassConstructor(declaration, irConstructor2);
        this.buildBoxFunction(declaration);
        this.buildUnboxFunction(declaration);
        this.buildSpecializedEqualsMethodIfNeeded(declaration);
        this.addJvmInlineAnnotation(declaration);
    }

    private final void addJvmInlineAnnotation(IrClass valueClass) {
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)valueClass, InlineClassesUtilsKt.getJVM_INLINE_ANNOTATION_FQ_NAME())) {
            return;
        }
        IrConstructorSymbol constructor = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(this.getContext().getSymbols().getJvmInlineAnnotation()));
        valueClass.setAnnotations(CollectionsKt.plus((Collection)valueClass.getAnnotations(), (Object)BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, ((IrConstructor)constructor.getOwner()).getReturnType(), constructor, null, 4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createBridgeBody(@NotNull IrSimpleFunction source, @NotNull IrSimpleFunction target, @NotNull IrFunction original, boolean inverted) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        void $this$createBridgeBody_u24lambda_u240_u240;
        void $this$createBridgeBody_u24lambda_u240;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)source.getSymbol(), source.getStartOffset(), source.getEndOffset());
        IrSimpleFunction irSimpleFunction = source;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$createBridgeBody_u24lambda_u240, target);
        IrBuilder irBuilder = (IrBuilder)$this$createBridgeBody_u24lambda_u240;
        boolean bl2 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u240_u240, source, 0, 2, null);
        List list = $this$createBridgeBody_u24lambda_u240_u240.getArguments();
        Collection other$iv = source.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(ExpressionHelpersKt.irGet((IrBuilder)$this$createBridgeBody_u24lambda_u240, (IrValueDeclaration)p0));
        }
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, irFunctionAccessExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<IrDeclaration> transformSecondaryConstructorFlat(@NotNull IrConstructor constructor, @NotNull IrSimpleFunction replacement) {
        void $this$transformSecondaryConstructorFlat_u24lambda_u241;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void irElement$iv;
        void $this$irBlockBody$iv;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Object $this$forEach$iv = replacement.getParameters();
        boolean $i$f$forEach22 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        $this$forEach$iv = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)replacement.getSymbol(), replacement.getStartOffset(), replacement.getEndOffset());
        IrElement $i$f$forEach22 = replacement;
        boolean $i$f$irBlockBody = false;
        element$iv = $this$irBlockBody$iv;
        int it = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var12_15 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = replacement;
        boolean bl = false;
        IrType irType = replacement.getReturnType();
        IrVariable thisVar = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$transformSecondaryConstructorFlat_u24lambda_u241, null, "$this", irType, false, null, 25, null);
        IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        this.valueMap.put(irValueParameter.getSymbol(), thisVar);
        Object object = constructor.getBody();
        if (object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement = (IrStatement)element$iv2;
                boolean bl2 = false;
                $this$transformSecondaryConstructorFlat_u24lambda_u241.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid((IrBlockBodyBuilder)$this$transformSecondaryConstructorFlat_u24lambda_u241, thisVar, constructor){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                    final /* synthetic */ IrVariable $thisVar;
                    final /* synthetic */ IrConstructor $constructor;
                    {
                        this.$this_irBlockBody = $receiver;
                        this.$thisVar = $thisVar;
                        this.$constructor = $constructor;
                    }

                    public IrStatement visitClass(IrClass declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                        return declaration;
                    }

                    public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSet$default((IrBuilder)this.$this_irBlockBody, this.$thisVar.getSymbol(), (IrExpression)expression2, null, 4, null);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public IrExpression visitReturn(IrReturn expression2) {
                        void $this$visitReturn_u24lambda_u240;
                        void this_$iv$iv;
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        if (!Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$constructor.getSymbol())) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                        int n2 = expression2.getStartOffset();
                        int n3 = expression2.getEndOffset();
                        IrVariable irVariable = this.$thisVar;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void var11_11 = this_$iv$iv;
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                        boolean bl = false;
                        $this$visitReturn_u24lambda_u240.unaryPlus(expression2.getValue());
                        $this$visitReturn_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irGet((IrBuilder)$this$visitReturn_u24lambda_u240, irVariable));
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, (IrExpression)this_$iv$iv.doBuild());
                    }
                }), this), replacement));
            }
        }
        $this$transformSecondaryConstructorFlat_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformSecondaryConstructorFlat_u24lambda_u241, ExpressionHelpersKt.irGet((IrBuilder)$this$transformSecondaryConstructorFlat_u24lambda_u241, thisVar)));
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return CollectionsKt.listOf((Object)replacement);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildReplacement(IrMemberAccessExpression<?> $this$buildReplacement, IrMemberAccessExpression<?> original) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        IrExpressionsKt.copyTypeArgumentsFrom$default($this$buildReplacement, original, 0, 2, null);
        List list = $this$buildReplacement.getArguments();
        Collection other$iv = original.getArguments();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrExpression irExpression = (IrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            collection.add(v0 != null ? v0.transform((IrTransformer)this, (Object)null) : null);
        }
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionReference(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u240 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), replacement.getSymbol(), function2.getTypeParameters().size(), expression2.getReflectionTarget(), expression2.getOrigin());
        boolean bl = false;
        this.buildReplacement($this$visitFunctionReference_u24lambda_u240, expression2);
        IrDeclarationsKt.copyAttributes$default($this$visitFunctionReference_u24lambda_u240, expression2, false, 2, null);
        return irFunctionReferenceImpl;
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        IrCallImpl $this$visitFunctionAccess_u24lambda_u240 = irCallImpl = BuildersKt.IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrTypeUtilsKt.substitute(function2.getReturnType(), IrUtilsKt.getTypeSubstitutionMap(expression2)), replacement.getSymbol(), replacement.getTypeParameters().size(), expression2.getOrigin(), irCall != null ? irCall.getSuperQualifierSymbol() : null);
        boolean bl = false;
        this.buildReplacement($this$visitFunctionAccess_u24lambda_u240, expression2);
        return irCallImpl;
    }

    private final IrExpression coerceInlineClasses(IrExpression argument, IrType from2, IrType to, boolean skipCast) {
        IrSimpleType underlyingType;
        IrCallImpl irCallImpl;
        IrCallImpl $this$coerceInlineClasses_u24lambda_u240 = irCallImpl = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, to, this.getContext().getSymbols().getUnsafeCoerceIntrinsic(), null, null, 48, null);
        boolean bl = false;
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(IrTypeErasureUtilsKt.getErasedUpperBound(from2));
        IrSimpleType irSimpleType = underlyingType = inlineClassRepresentation != null ? inlineClassRepresentation.getUnderlyingType() : null;
        boolean bl2 = irSimpleType != null ? IrTypeUtilsKt.isTypeParameter(irSimpleType) : false;
        if (bl2 && !skipCast) {
            $this$coerceInlineClasses_u24lambda_u240.getTypeArguments().set(0, from2);
            $this$coerceInlineClasses_u24lambda_u240.getTypeArguments().set(1, underlyingType);
            $this$coerceInlineClasses_u24lambda_u240.getArguments().set(0, BuildersKt.IrTypeOperatorCallImpl(-1, -1, to, IrTypeOperator.IMPLICIT_CAST, underlyingType, argument));
        } else {
            $this$coerceInlineClasses_u24lambda_u240.getTypeArguments().set(0, from2);
            $this$coerceInlineClasses_u24lambda_u240.getTypeArguments().set(1, to);
            $this$coerceInlineClasses_u24lambda_u240.getArguments().set(0, argument);
        }
        return irCallImpl;
    }

    static /* synthetic */ IrExpression coerceInlineClasses$default(JvmInlineClassLowering jvmInlineClassLowering, IrExpression irExpression, IrType irType, IrType irType2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return jvmInlineClassLowering.coerceInlineClasses(irExpression, irType, irType2, bl);
    }

    @Override
    @NotNull
    public IrConstructor withAddedMarkerParameterToNonExposedConstructor(@NotNull IrConstructor $this$withAddedMarkerParameterToNonExposedConstructor) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter((Object)$this$withAddedMarkerParameterToNonExposedConstructor, (String)"<this>");
        IrFunction $this$addValueParameter$iv = $this$withAddedMarkerParameterToNonExposedConstructor;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$withAddedMarkerParameterToNonExposedConstructor_u24lambda_u240 = $this$addValueParameter_u24lambda_u240$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("$boxingMarker");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$withAddedMarkerParameterToNonExposedConstructor_u24lambda_u240.setName(name2);
        $this$withAddedMarkerParameterToNonExposedConstructor_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getNON_EXPOSED_CONSTRUCTOR_SYNTHETIC_PARAMETER());
        $this$withAddedMarkerParameterToNonExposedConstructor_u24lambda_u240.setType(IrTypesKt.makeNullable(IrTypesKt.getDefaultType(this.getContext().getSymbols().getBoxingConstructorMarkerClass())));
        $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u240$iv, $this$addValueParameter$iv);
        boolean bl3 = false;
        $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), (Object)valueParameter$iv));
        return $this$withAddedMarkerParameterToNonExposedConstructor;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrConstructor createExposedConstructor(@NotNull IrConstructor constructor) {
        void $this$createExposedConstructor_u24lambda_u241_u241_u240;
        void $this$createExposedConstructor_u24lambda_u241_u241;
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        int n2;
        IrValueParameter it;
        IrConstructor irConstructor;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        IrFactory $this$buildConstructor$iv = IrUtilsKt.getParentAsClass(constructor).getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createExposedConstructor_u24lambda_u240 = $this$buildConstructor_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$createExposedConstructor_u24lambda_u240.updateFrom(constructor);
        $this$createExposedConstructor_u24lambda_u240.setPrimary(false);
        $this$createExposedConstructor_u24lambda_u240.setReturnType(constructor.getReturnType());
        IrConstructor $this$createExposedConstructor_u24lambda_u241 = irConstructor = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.copyValueAndTypeParametersFrom($this$createExposedConstructor_u24lambda_u241, constructor);
        Iterable $this$forEach$iv = $this$createExposedConstructor_u24lambda_u241.getParameters();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrValueParameter)element$iv;
            n2 = 0;
            it.setDefaultValue(null);
        }
        boolean addedSyntheticParameter = Intrinsics.areEqual((Object)((IrValueParameter)CollectionsKt.last($this$createExposedConstructor_u24lambda_u241.getParameters())).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getNON_EXPOSED_CONSTRUCTOR_SYNTHETIC_PARAMETER());
        if (addedSyntheticParameter) {
            $this$createExposedConstructor_u24lambda_u241.setParameters(CollectionsKt.dropLast($this$createExposedConstructor_u24lambda_u241.getParameters(), (int)1));
        }
        $this$createExposedConstructor_u24lambda_u241.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withJvmExposeBoxedAnnotation(constructor.getAnnotations(), constructor, this.getContext()));
        constructor.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withoutJvmExposeBoxedAnnotation(constructor.getAnnotations()));
        IrGeneratorWithScope $i$f$forEach22 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)$this$createExposedConstructor_u24lambda_u241.getSymbol(), 0, 0, 6, null);
        IrElement irElement$iv = $this$createExposedConstructor_u24lambda_u241;
        boolean $i$f$irBlockBody = false;
        it = $this$irBlockBody$iv;
        n2 = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var15_23 = this_$iv$iv$iv;
        IrConstructor irConstructor2 = $this$createExposedConstructor_u24lambda_u241;
        boolean bl4 = false;
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)$this$createExposedConstructor_u24lambda_u241_u241, constructor);
        void var20_28 = $this$createExposedConstructor_u24lambda_u241_u241;
        boolean bl5 = false;
        Iterator iterator2 = ((Iterable)$this$createExposedConstructor_u24lambda_u241.getParameters()).iterator();
        int n3 = 0;
        while (iterator2.hasNext()) {
            int index = n3++;
            IrValueParameter param = (IrValueParameter)iterator2.next();
            $this$createExposedConstructor_u24lambda_u241_u241_u240.getArguments().set(index, ExpressionHelpersKt.irGet((IrBuilder)$this$createExposedConstructor_u24lambda_u241_u241, param));
        }
        if (addedSyntheticParameter) {
            $this$createExposedConstructor_u24lambda_u241_u241_u240.getArguments().set($this$createExposedConstructor_u24lambda_u241.getParameters().size(), ExpressionHelpersKt.irNull((IrBuilder)$this$createExposedConstructor_u24lambda_u241_u241));
        }
        var20_28.unaryPlus(irDelegatingConstructorCall);
        irConstructor2.setBody(this_$iv$iv$iv.doBuild());
        return irConstructor;
    }

    private final IrExpression coerceToUnboxed(IrExpression $this$coerceToUnboxed) {
        return JvmInlineClassLowering.coerceInlineClasses$default(this, $this$coerceToUnboxed, $this$coerceToUnboxed.getType(), InlineClassAbiKt.unboxInlineClass($this$coerceToUnboxed.getType()), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression specializeEqualsCall(IrBuilderWithScope $this$specializeEqualsCall, IrExpression left, IrExpression right) {
        IrExpression irExpression;
        boolean rightNullCheck;
        boolean rightIsUnboxed;
        if (IrUtilsKt.isNullConst(left) || IrUtilsKt.isNullConst(right)) {
            return null;
        }
        boolean leftIsUnboxed = !Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(left.getType()), (Object)left.getType());
        boolean bl = rightIsUnboxed = !Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(right.getType()), (Object)right.getType());
        if (!leftIsUnboxed && !rightIsUnboxed) {
            return null;
        }
        boolean leftNullCheck = IrTypeUtilsKt.isNullable(left.getType());
        boolean bl2 = rightNullCheck = rightIsUnboxed && IrTypeUtilsKt.isNullable(right.getType());
        if (leftNullCheck || rightNullCheck) {
            IrExpression equalsRight;
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$specializeEqualsCall;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$specializeEqualsCall_u24lambda_u242 = this_$iv$iv;
            boolean bl3 = false;
            IrValueDeclaration leftVal = left instanceof IrGetValue ? ((IrGetValue)left).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u242, left, null, null, false, null, 30, null);
            IrValueDeclaration rightVal = right instanceof IrGetValue ? ((IrGetValue)right).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u242, right, null, null, false, null, 30, null);
            IrExpression equalsCall = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, leftNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, leftVal), IrTypesKt.makeNotNull(left.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, leftVal), rightNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, rightVal), IrTypesKt.makeNotNull(right.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, rightVal));
            IrExpression irExpression2 = equalsRight = rightNullCheck ? (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, $this$specializeEqualsCall_u24lambda_u242.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, rightVal), ExpressionHelpersKt.irFalse((IrBuilder)$this$specializeEqualsCall_u24lambda_u242), equalsCall) : equalsCall;
            if (leftNullCheck) {
                $this$specializeEqualsCall_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, $this$specializeEqualsCall_u24lambda_u242.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, leftVal), ExpressionHelpersKt.irEqualsNull((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, ExpressionHelpersKt.irGet((IrBuilder)$this$specializeEqualsCall_u24lambda_u242, rightVal)), equalsRight));
            } else {
                $this$specializeEqualsCall_u24lambda_u242.unaryPlus(equalsRight);
            }
            irExpression = (IrExpression)this_$iv$iv.doBuild();
        } else {
            irExpression = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, left, right);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (InlineClassAbiKt.isInlineClassFieldGetter(expression2.getSymbol().getOwner())) {
            IrExpression irExpression2 = expression2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrElement arg = irExpression2.transform((IrTransformer)this, (Object)null);
            IrValueParameter irValueParameter = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrType from2 = irValueParameter.getType();
            IrType to = ((IrSimpleFunction)this.getContext().getInlineClassReplacements().getGetUnboxFunction().invoke((Object)IrTypeErasureUtilsKt.getErasedUpperBound(from2))).getReturnType();
            irExpression = JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)arg, from2, to, false, 8, null);
        } else if (this.isEqEqCallOnInlineClass(expression2) || this.isEqualsMethodCallOnInlineClass(expression2)) {
            this.transformChildrenVoid(expression2);
            LoweringContext loweringContext = this.getContext();
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            IrBuilderWithScope irBuilderWithScope = LowerUtilsKt.createIrBuilder(loweringContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
            Object e2 = expression2.getArguments().get(0);
            Intrinsics.checkNotNull(e2);
            IrExpression irExpression3 = (IrExpression)e2;
            Object e3 = expression2.getArguments().get(1);
            Intrinsics.checkNotNull(e3);
            irExpression = this.specializeEqualsCall(irBuilderWithScope, irExpression3, (IrExpression)e3);
            if (irExpression == null) {
                irExpression = expression2;
            }
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final boolean isEqualsMethodCallOnInlineClass(IrCall $this$isEqualsMethodCallOnInlineClass) {
        IrClass receiverClass;
        if (!IrUtilsKt.isEquals($this$isEqualsMethodCallOnInlineClass.getSymbol().getOwner())) {
            return false;
        }
        Object object = $this$isEqualsMethodCallOnInlineClass.getDispatchReceiver();
        IrClass irClass = receiverClass = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null ? (IrClass)object.getOwner() : null;
        return irClass != null ? this.getCanUseSpecializedEqMethod(irClass) : false;
    }

    private final boolean isEqEqCallOnInlineClass(IrCall $this$isEqEqCallOnInlineClass) {
        if (!Intrinsics.areEqual((Object)$this$isEqEqCallOnInlineClass.getSymbol(), (Object)this.getContext().getIrBuiltIns().getEqeqSymbol())) {
            return false;
        }
        Object object = (IrExpression)$this$isEqEqCallOnInlineClass.getArguments().get(0);
        if (object == null || (object = ((IrExpression)object).getType()) == null || (object = IrTypesKt.getClassOrNull((IrType)object)) == null || (object = (IrClass)object.getOwner()) == null) {
            return false;
        }
        Object leftOperandClass = object;
        return this.getCanUseSpecializedEqMethod((IrClass)leftOperandClass);
    }

    private final boolean getCanUseSpecializedEqMethod(IrClass $this$canUseSpecializedEqMethod) {
        if (!IrDeclarationsKt.isSingleFieldValueClass($this$canUseSpecializedEqMethod)) {
            return false;
        }
        return !IrTypePredicatesKt.isClassWithFqName($this$canUseSpecializedEqMethod, StandardNames.RESULT_FQ_NAME) || this.getContext().getConfig().getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field.getParent();
        if (Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_BACKING_FIELD()) && parent2 instanceof IrClass && IrDeclarationsKt.isSingleFieldValueClass((IrClass)parent2) && Intrinsics.areEqual((Object)field.getName(), (Object)InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            IrElement receiver = irExpression.transform((IrTransformer)this, (Object)null);
            return JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)receiver, IrTypesKt.makeNotNull(((IrExpression)receiver).getType()), field.getType(), false, 8, null);
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return BuildersKt.IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return BuildersKt.IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), (IrExpression)expression2.getValue().transform((IrTransformer)this, (Object)null), expression2.getOrigin());
        }
        return super.visitSetValue(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPrimaryInlineClassConstructor(IrClass valueClass, IrConstructor irConstructor) {
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u244;
        void this_$iv$iv;
        Iterator $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242;
        void this_$iv$iv$iv;
        void startOffset$iv$iv22;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        Object valueParameter$iv;
        Object $this$addValueParameter$iv;
        Object $this$addConstructor$iv = valueClass;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$buildPrimaryInlineClassConstructor_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
        boolean bl32 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u240.updateFrom(irConstructor);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        $this$buildPrimaryInlineClassConstructor_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_INLINE_CLASS_MEMBER());
        $this$buildPrimaryInlineClassConstructor_u24lambda_u240.setReturnType(irConstructor.getReturnType());
        $this$addConstructor_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u241$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent((IrDeclarationParent)$this$addConstructor$iv);
        Object $this$buildPrimaryInlineClassConstructor_u24lambda_u241 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrUtilsKt.copyValueAndTypeParametersFrom((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u241, irConstructor);
        Iterable $this$forEach$iv = ((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u241).getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl6 = false;
            it.setDefaultValue(null);
        }
        if (JvmIrUtilsKt.shouldBeExposedByAnnotationOrFlag(irConstructor, this.getContext().getConfig().getLanguageVersionSettings())) {
            $this$addValueParameter$iv = (IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u241;
            boolean $i$f$addValueParameter = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
            boolean bl7 = false;
            IrValueParameterBuilder $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u241 = $this$addValueParameter_u24lambda_u240$iv;
            boolean bl8 = false;
            $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_SYNTHETIC_PARAMETER());
            Name name2 = Name.identifier("$null");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u241.setName(name2);
            $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u241.setType(IrTypesKt.getDefaultType(this.getContext().getSymbols().getBoxingConstructorMarkerClass()));
            $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
            IrValueParameter bl32 = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u240$iv, (IrDeclarationParent)$this$addValueParameter$iv);
            valueParameter$iv = bl32;
            boolean bl9 = false;
            ((IrFunction)$this$addValueParameter$iv).setParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv).getParameters(), (Object)valueParameter$iv));
        }
        $this$buildPrimaryInlineClassConstructor_u24lambda_u241.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withoutJvmExposeBoxedAnnotation(irConstructor.getAnnotations()));
        $this$addValueParameter$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)$this$buildPrimaryInlineClassConstructor_u24lambda_u241).getSymbol(), 0, 0, 6, null);
        Object irElement$iv = (IrElement)$this$buildPrimaryInlineClassConstructor_u24lambda_u241;
        boolean $i$f$irBlockBody = false;
        void bl7 = $this$irBlockBody$iv;
        int $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u241 = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        valueParameter$iv = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv22, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        Iterator iterator2 = this_$iv$iv$iv;
        Object object = $this$buildPrimaryInlineClassConstructor_u24lambda_u241;
        boolean bl10 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilder irBuilder = (IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242;
        IrBuilder irBuilder2 = (IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242;
        IrValueParameter irValueParameter = valueClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilder, ExpressionHelpersKt.irGet(irBuilder2, irValueParameter), InlineClassesKt.getInlineClassBackingField(valueClass), ExpressionHelpersKt.irGet((IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u241_u242, ((IrFunction)$this$buildPrimaryInlineClassConstructor_u24lambda_u241).getParameters().get(0)), null, 8, null));
        ((IrFunction)object).setBody(this_$iv$iv$iv.doBuild());
        Object primaryConstructor = $this$addConstructor$iv;
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(irConstructor);
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction function2 = irSimpleFunction;
        Iterable $this$filterIsInstance$iv = valueClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        irElement$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator startOffset$iv$iv22 = $this$filterNotTo$iv$iv.iterator();
        while (startOffset$iv$iv22.hasNext()) {
            Object element$iv$iv = startOffset$iv$iv22.next();
            IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv$iv;
            boolean bl11 = false;
            if (it.isStatic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initBlocks = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = function2.getParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl12 = false;
            this.transformChildrenVoid(it);
        }
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        $i$f$irBlockBody = false;
        IrBlockBodyBuilder it = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody2 = false;
        void element$iv$iv = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = function2;
        boolean bl13 = false;
        IrValueParameter argument = function2.getParameters().get(0);
        IrVariable thisValue = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u244, this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u244, argument), argument.getType(), function2.getReturnType(), true), null, null, false, null, 30, null);
        IrValueParameter irValueParameter2 = valueClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        this.valueMap.put(irValueParameter2.getSymbol(), thisValue);
        for (IrAnonymousInitializer initBlock : initBlocks) {
            for (IrStatement stmt : initBlock.getBody().getStatements()) {
                $this$buildPrimaryInlineClassConstructor_u24lambda_u244.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(stmt, this), function2));
            }
        }
        $this$buildPrimaryInlineClassConstructor_u24lambda_u244.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u244, ExpressionHelpersKt.irGet((IrBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u244, thisValue)));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        valueClass.getDeclarations().removeAll(initBlocks);
        ((Collection)valueClass.getDeclarations()).add(function2);
        if (JvmIrUtilsKt.shouldBeExposedByAnnotationOrFlag(irConstructor, this.getContext().getConfig().getLanguageVersionSettings())) {
            this.addExposedForJavaConstructor(valueClass, irConstructor, (IrConstructor)primaryConstructor, function2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addExposedForJavaConstructor(IrClass $this$addExposedForJavaConstructor, IrConstructor irConstructor, IrConstructor primaryConstructor, IrSimpleFunction function2) {
        IrExpressionBody defaultValue;
        void $this$addExposedForJavaConstructor_u24lambda_u241_u241_u241;
        IrFunctionAccessExpression $this$addExposedForJavaConstructor_u24lambda_u241_u241_u240;
        void $this$addExposedForJavaConstructor_u24lambda_u241_u241;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        void $this$irBlockBody$iv;
        Object element$iv;
        Object $this$addConstructor$iv = $this$addExposedForJavaConstructor;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
        boolean bl = false;
        IrFunctionBuilder $this$addExposedForJavaConstructor_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$addExposedForJavaConstructor_u24lambda_u240.updateFrom(irConstructor);
        $this$addExposedForJavaConstructor_u24lambda_u240.setPrimary(false);
        $this$addExposedForJavaConstructor_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getEXPOSED_INLINE_CLASS_CONSTRUCTOR());
        $this$addExposedForJavaConstructor_u24lambda_u240.setReturnType(irConstructor.getReturnType());
        $this$addConstructor_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u241$iv$iv);
        boolean bl3 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent((IrDeclarationParent)$this$addConstructor$iv);
        Object $this$addExposedForJavaConstructor_u24lambda_u241 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl4 = false;
        IrUtilsKt.copyValueAndTypeParametersFrom((IrFunction)$this$addExposedForJavaConstructor_u24lambda_u241, irConstructor);
        Object $this$forEach$iv = ((IrFunction)$this$addExposedForJavaConstructor_u24lambda_u241).getParameters();
        boolean $i$f$forEach = false;
        Iterator $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = $this$forEach$iv.iterator();
        while ($i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22.hasNext()) {
            element$iv = $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22.next();
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl5 = false;
            it.setDefaultValue(null);
        }
        $this$addExposedForJavaConstructor_u24lambda_u241.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withJvmExposeBoxedAnnotation(irConstructor.getAnnotations(), irConstructor, this.getContext()));
        $this$forEach$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)$this$addExposedForJavaConstructor_u24lambda_u241).getSymbol(), 0, 0, 6, null);
        IrElement irElement$iv = (IrElement)$this$addExposedForJavaConstructor_u24lambda_u241;
        boolean $i$f$irBlockBody = false;
        element$iv = $this$irBlockBody$iv;
        int it = irElement$iv.getStartOffset();
        int endOffset$iv$iv = irElement$iv.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody2 = false;
        void var17_40 = this_$iv$iv$iv;
        Object object = $this$addExposedForJavaConstructor_u24lambda_u241;
        boolean bl6 = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u241_u241, primaryConstructor);
        IrFunctionAccessExpression irFunctionAccessExpression3 = $this$addExposedForJavaConstructor_u24lambda_u241_u241;
        boolean bl7 = false;
        IrUtilsKt.passTypeArgumentsFrom$default($this$addExposedForJavaConstructor_u24lambda_u241_u241_u240, primaryConstructor, 0, 2, null);
        $this$addExposedForJavaConstructor_u24lambda_u241_u241_u240.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u241_u241, ((IrFunction)$this$addExposedForJavaConstructor_u24lambda_u241).getParameters().get(0)));
        $this$addExposedForJavaConstructor_u24lambda_u241_u241_u240.getArguments().set(1, ExpressionHelpersKt.irNull((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u241_u241));
        ((IrStatementsBuilder)((Object)irFunctionAccessExpression3)).unaryPlus(irFunctionAccessExpression);
        $this$addExposedForJavaConstructor_u24lambda_u241_u241_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u241_u241, function2);
        irFunctionAccessExpression3 = $this$addExposedForJavaConstructor_u24lambda_u241_u241;
        boolean bl8 = false;
        $this$addExposedForJavaConstructor_u24lambda_u241_u241_u241.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u241_u241, ((IrFunction)$this$addExposedForJavaConstructor_u24lambda_u241).getParameters().get(0)));
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$addExposedForJavaConstructor_u24lambda_u241_u241_u241, primaryConstructor, 0, 2, null);
        ((IrStatementsBuilder)((Object)irFunctionAccessExpression3)).unaryPlus(irFunctionAccessExpression);
        ((IrFunction)object).setBody(this_$iv$iv$iv.doBuild());
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(irConstructor.getParameters());
        IrExpressionBody irExpressionBody = defaultValue = irValueParameter != null ? irValueParameter.getDefaultValue() : null;
        if (defaultValue != null) {
            void $this$addExposedForJavaConstructor_u24lambda_u243_u240_u241;
            IrFunctionAccessExpression $this$addExposedForJavaConstructor_u24lambda_u243_u240_u240;
            void $this$addExposedForJavaConstructor_u24lambda_u243_u240;
            void this_$iv$iv$iv2;
            void startOffset$iv$iv2;
            void $this$irBlockBody$iv$iv2;
            void $this$irBlockBody$iv2;
            Object object2;
            IrClass $this$addConstructor$iv2 = $this$addExposedForJavaConstructor;
            boolean $i$f$addConstructor2 = false;
            Object $this$buildConstructor$iv$iv2 = $this$addConstructor$iv2.getFactory();
            boolean $i$f$buildConstructor2 = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv2 = new IrFunctionBuilder();
            boolean bl9 = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv2 = $this$buildConstructor_u24lambda_u241$iv$iv2;
            int n2 = 0;
            IrFunctionBuilder $this$addExposedForJavaConstructor_u24lambda_u242 = $this$addConstructor_u24lambda_u240$iv2;
            boolean bl10 = false;
            $this$addExposedForJavaConstructor_u24lambda_u242.updateFrom(irConstructor);
            $this$addExposedForJavaConstructor_u24lambda_u242.setPrimary(false);
            $this$addExposedForJavaConstructor_u24lambda_u242.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getEXPOSED_INLINE_CLASS_CONSTRUCTOR());
            $this$addExposedForJavaConstructor_u24lambda_u242.setReturnType(irConstructor.getReturnType());
            $this$addConstructor_u24lambda_u240$iv2.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv2));
            Object constructor$iv2 = $this$buildConstructor$iv$iv2 = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv2, $this$buildConstructor_u24lambda_u241$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addConstructor$3$iv = false;
            $this$addConstructor$iv2.getDeclarations().add((IrDeclaration)constructor$iv2);
            ((IrDeclarationBase)constructor$iv2).setParent($this$addConstructor$iv2);
            Object $this$addExposedForJavaConstructor_u24lambda_u243 = object2 = $this$buildConstructor$iv$iv2;
            boolean bl11 = false;
            IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)$this$addExposedForJavaConstructor_u24lambda_u243, irConstructor, null, null, 6, null);
            $this$addExposedForJavaConstructor_u24lambda_u243.setAnnotations(MemoizedValueClassAbstractReplacementsKt.withJvmExposeBoxedAnnotation(irConstructor.getAnnotations(), irConstructor, this.getContext()));
            constructor$iv2 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)$this$addExposedForJavaConstructor_u24lambda_u243).getSymbol(), 0, 0, 6, null);
            IrElement irElement$iv2 = (IrElement)$this$addExposedForJavaConstructor_u24lambda_u243;
            boolean $i$f$irBlockBody3 = false;
            $this$addConstructor_u24lambda_u240$iv2 = $this$irBlockBody$iv2;
            n2 = irElement$iv2.getStartOffset();
            int endOffset$iv$iv2 = irElement$iv2.getEndOffset();
            boolean $i$f$irBlockBody4 = false;
            IrBlockBodyBuilder $i$f$blockBody2 = new IrBlockBodyBuilder($this$irBlockBody$iv$iv2.getContext(), $this$irBlockBody$iv$iv2.getScope(), (int)startOffset$iv$iv2, endOffset$iv$iv2);
            boolean $i$f$blockBody3 = false;
            object = this_$iv$iv$iv2;
            Object object3 = $this$addExposedForJavaConstructor_u24lambda_u243;
            boolean bl12 = false;
            irFunctionAccessExpression3 = irFunctionAccessExpression2 = ExpressionHelpersKt.irCall((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u243_u240, function2);
            IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$addExposedForJavaConstructor_u24lambda_u243_u240;
            boolean bl13 = false;
            $this$addExposedForJavaConstructor_u24lambda_u243_u240_u240.getArguments().set(0, null);
            IrUtilsKt.passTypeArgumentsFrom$default($this$addExposedForJavaConstructor_u24lambda_u243_u240_u240, primaryConstructor, 0, 2, null);
            IrVariable tmp = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, irFunctionAccessExpression2, null, null, false, null, 30, null);
            $this$addExposedForJavaConstructor_u24lambda_u243_u240_u240 = irFunctionAccessExpression2 = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u243_u240, primaryConstructor);
            irStatementsBuilder = $this$addExposedForJavaConstructor_u24lambda_u243_u240;
            boolean bl14 = false;
            IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$addExposedForJavaConstructor_u24lambda_u243_u240_u241, primaryConstructor, 0, 2, null);
            $this$addExposedForJavaConstructor_u24lambda_u243_u240_u241.getArguments().set(0, this.coerceToUnboxed(ExpressionHelpersKt.irGet((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u243_u240, tmp)));
            $this$addExposedForJavaConstructor_u24lambda_u243_u240_u241.getArguments().set(1, ExpressionHelpersKt.irNull((IrBuilder)$this$addExposedForJavaConstructor_u24lambda_u243_u240));
            irStatementsBuilder.unaryPlus(irFunctionAccessExpression2);
            ((IrFunction)object3).setBody(this_$iv$iv$iv2.doBuild());
        }
    }

    private final List<IrConstructorCall> withoutJvmNameAnnotation(List<? extends IrConstructorCall> $this$withoutJvmNameAnnotation) {
        List list;
        List $this$withoutJvmNameAnnotation_u24lambda_u240 = list = CollectionsKt.toMutableList((Collection)$this$withoutJvmNameAnnotation);
        boolean bl = false;
        CollectionsKt.removeAll((List)$this$withoutJvmNameAnnotation_u24lambda_u240, JvmInlineClassLowering::withoutJvmNameAnnotation$lambda$0$0);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildBoxFunction(IrClass valueClass) {
        void $this$buildBoxFunction_u24lambda_u240_u240;
        IrConstructorCall irConstructorCall;
        IrSimpleFunction function2 = (IrSimpleFunction)this.getContext().getInlineClassReplacements().getGetBoxFunction().invoke((Object)valueClass);
        DeclarationIrBuilder $this$buildBoxFunction_u24lambda_u240 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrBuilder irBuilder = $this$buildBoxFunction_u24lambda_u240;
        IrBuilder irBuilder2 = $this$buildBoxFunction_u24lambda_u240;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(valueClass);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall(irBuilder2, irConstructor.getSymbol());
        IrBuilder irBuilder3 = irBuilder;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl2 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$buildBoxFunction_u24lambda_u240_u240, function2, 0, 2, null);
        $this$buildBoxFunction_u24lambda_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGet($this$buildBoxFunction_u24lambda_u240, function2.getParameters().get(0)));
        Object object = IrUtilsKt.getPrimaryConstructor(valueClass);
        if (Intrinsics.areEqual(object != null && (object = ((IrFunction)object).getParameters()) != null && (object = (IrValueParameter)CollectionsKt.last((List)object)) != null ? object.getOrigin() : null, (Object)JvmLoweredDeclarationOrigin.INSTANCE.getINLINE_CLASS_CONSTRUCTOR_SYNTHETIC_PARAMETER())) {
            $this$buildBoxFunction_u24lambda_u240_u240.getArguments().set(1, ExpressionHelpersKt.irNull($this$buildBoxFunction_u24lambda_u240));
        }
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder3, irConstructorCall));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass) {
        void $this$buildUnboxFunction_u24lambda_u240;
        void this_$iv$iv;
        IrSimpleFunction function2 = (IrSimpleFunction)this.getContext().getInlineClassReplacements().getGetUnboxFunction().invoke((Object)irClass);
        IrField field = InlineClassesKt.getInlineClassBackingField(irClass);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var10_10 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        IrBuilder irBuilder = (IrBuilder)$this$buildUnboxFunction_u24lambda_u240;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilder, irValueParameter);
        $this$buildUnboxFunction_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u240, ExpressionHelpersKt.irGetField$default((IrBuilder)$this$buildUnboxFunction_u24lambda_u240, thisVal, field, null, 4, null)));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        ((Collection)irClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSpecializedEqualsMethodIfNeeded(IrClass valueClass) {
        IrExpression irExpression;
        void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241;
        IrElementBase it;
        IrSimpleFunction function2 = this.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(valueClass, this.getContext().getIrBuiltIns());
        if (function2.getBody() != null) {
            return;
        }
        List<IrValueParameter> list = function2.getParameters();
        IrValueParameter left = list.get(0);
        IrValueParameter right = list.get(1);
        IrType type = InlineClassAbiKt.unboxInlineClass(left.getType());
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(valueClass);
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrSimpleFunction)element$iv;
            boolean bl2 = false;
            if (!IrUtilsKt.isEquals(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction untypedEquals = single$iv;
        DeclarationIrBuilder $i$f$single22 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)valueClass.getSymbol(), 0, 0, 6, null);
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        JvmBackendContext context2 = this.getContext();
        IrSimpleType underlyingType = InlineClassesKt.getInlineClassUnderlyingType(valueClass);
        IrBuilder irBuilder = (IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241;
        if (Intrinsics.areEqual((Object)untypedEquals.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFINED())) {
            void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u241;
            IrSimpleFunction boxFunction = (IrSimpleFunction)context2.getInlineClassReplacements().getGetBoxFunction().invoke((Object)valueClass);
            IrElementBase bl2 = it = ExpressionHelpersKt.irCall((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, untypedEquals);
            IrBuilder irBuilder2 = irBuilder;
            boolean bl3 = false;
            $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u241.getArguments().set(0, JvmInlineClassLowering.buildSpecializedEqualsMethodIfNeeded$lambda$1$irBox((DeclarationIrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, boxFunction, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, left), left.getType(), underlyingType, false, 8, null)));
            $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u241.getArguments().set(1, JvmInlineClassLowering.buildSpecializedEqualsMethodIfNeeded$lambda$1$irBox((DeclarationIrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, boxFunction, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, right), right.getType(), underlyingType, false, 8, null)));
            irBuilder = irBuilder2;
            irExpression = (IrExpression)it;
        } else {
            IrClass underlyingClass;
            IrClass irClass = underlyingClass = IrTypesKt.getClass(underlyingType);
            boolean bl4 = irClass != null ? IrDeclarationsKt.isSingleFieldValueClass(irClass) : false;
            if (bl4 && !IrTypeUtilsKt.isNullable(underlyingType)) {
                void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u242;
                IrFunctionAccessExpression irFunctionAccessExpression;
                IrSimpleFunction underlyingClassEq = context2.getInlineClassReplacements().getSpecializedEqualsMethod(underlyingClass, context2.getIrBuiltIns());
                IrFunctionAccessExpression bl3 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, underlyingClassEq);
                IrBuilder irBuilder3 = irBuilder;
                boolean bl5 = false;
                $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u242.getArguments().set(0, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, left), left.getType(), underlyingType, false, 8, null));
                $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u242.getArguments().set(1, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, right), right.getType(), underlyingType, false, 8, null));
                irBuilder = irBuilder3;
                irExpression = irFunctionAccessExpression;
            } else {
                irExpression = ExpressionHelpersKt.irEquals$default((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, left), left.getType(), type, false, 8, null), JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241, right), right.getType(), type, false, 8, null), null, 4, null);
            }
        }
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, irExpression));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List visitClassNew$lambda$1(JvmInlineClassLowering this$0, IrDeclaration memberDeclaration) {
        List<IrDeclaration> list;
        Intrinsics.checkNotNullParameter((Object)memberDeclaration, (String)"memberDeclaration");
        if (memberDeclaration instanceof IrFunction) {
            void this_$iv;
            IrElementTransformerVoidWithContext irElementTransformerVoidWithContext = this$0;
            IrSymbolOwner declaration$iv = memberDeclaration;
            boolean $i$f$withinScope = false;
            IrElementTransformerVoidWithContext.access$unsafeEnterScope((IrElementTransformerVoidWithContext)this_$iv, declaration$iv);
            boolean bl = false;
            List<IrDeclaration> result$iv = this$0.transformFunctionFlat((IrFunction)memberDeclaration);
            IrElementTransformerVoidWithContext.access$unsafeLeaveScope((IrElementTransformerVoidWithContext)this_$iv);
            list = result$iv;
        } else {
            memberDeclaration.accept(this$0, null);
            list = null;
        }
        return list;
    }

    private static final boolean handleSpecificNewClass$lambda$0(IrConstructor $irConstructor, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$irConstructor) || it instanceof IrFunction && InlineClassAbiKt.isInlineClassFieldGetter((IrFunction)it) && !((IrFunction)it).getVisibility().isPublicAPI();
    }

    /*
     * Unable to fully structure code
     */
    private static final IrExpression specializeEqualsCall$equals(boolean rightIsUnboxed, IrBuilderWithScope $this_specializeEqualsCall, JvmInlineClassLowering this$0, IrExpression left, IrExpression right) {
        if (IrTypeUtilsKt.isUnsigned(left.getType()) && IrTypeUtilsKt.isUnsigned(right.getType()) && rightIsUnboxed) {
            return ExpressionHelpersKt.irEquals$default($this_specializeEqualsCall, this$0.coerceToUnboxed(left), this$0.coerceToUnboxed(right), null, 4, null);
        }
        v0 = IrTypesKt.getClassOrNull(left.getType());
        Intrinsics.checkNotNull((Object)v0);
        leftOperandClass = (IrClass)v0.getOwner();
        if (!rightIsUnboxed) ** GOTO lbl-1000
        v1 = IrTypesKt.getClassOrNull(right.getType());
        Intrinsics.checkNotNull((Object)v1);
        if (Intrinsics.areEqual((Object)leftOperandClass, v1.getOwner())) {
            v2 = this$0.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(leftOperandClass, $this_specializeEqualsCall.getContext().getIrBuiltIns());
        } else lbl-1000:
        // 2 sources

        {
            $this$single$iv = IrUtilsKt.getFunctions(leftOperandClass);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (E element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                $i$a$-single-JvmInlineClassLowering$specializeEqualsCall$equals$equalsMethod$equals$1 = false;
                if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals") != false && ((Collection)it.getOverriddenSymbols()).isEmpty() == false != false)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            equals = single$iv;
            v3 = this$0.getContext().getInlineClassReplacements().getReplacementFunction(equals);
            v2 = v3;
            Intrinsics.checkNotNull((Object)v3);
        }
        equalsMethod = v2;
        $this$specializeEqualsCall_u24equals_u24lambda_u241 = var7_14 = ExpressionHelpersKt.irCall((IrBuilder)$this_specializeEqualsCall, equalsMethod);
        $i$a$-apply-JvmInlineClassLowering$specializeEqualsCall$equals$1 = false;
        var10_8 = new IrExpression[]{left, right};
        AddToStdlibKt.assignFrom($this$specializeEqualsCall_u24equals_u24lambda_u241.getArguments(), CollectionsKt.listOf((Object[])var10_8));
        return var7_14;
    }

    private static final boolean withoutJvmNameAnnotation$lambda$0$0(IrConstructorCall it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = IrTypesKt.getClassOrNull(((IrConstructor)it.getSymbol().getOwner()).getReturnType());
        return object != null && (object = (IrClass)object.getOwner()) != null ? AdditionalIrUtilsKt.hasEqualFqName((IrDeclarationWithName)object, InlineClassesUtilsKt.getJVM_NAME_ANNOTATION_FQ_NAME()) : false;
    }

    private static final IrFunctionAccessExpression buildSpecializedEqualsMethodIfNeeded$lambda$1$irBox(DeclarationIrBuilder $this_run, IrSimpleFunction boxFunction, IrExpression expr) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u24irBox_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this_run, boxFunction);
        boolean bl = false;
        $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u241_u24irBox_u240.getArguments().set(0, expr);
        return irFunctionAccessExpression;
    }
}

