/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.base.Throwables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputRanges;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputWriter;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ExceptionSerializationUtil;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.jspecify.annotations.Nullable;

public final class SerializableTestResultStore {
    private static final int STORE_VERSION = 1;
    private final Path serializedResultsFile;
    private final Path outputEventsFile;

    public SerializableTestResultStore(Path resultsDir) {
        this.serializedResultsFile = resultsDir.resolve("results-generic.bin");
        this.outputEventsFile = resultsDir.resolve("output-events.bin");
    }

    public Writer openWriter(int diskSkipLevels) throws IOException {
        return new Writer(this.serializedResultsFile, this.outputEventsFile, diskSkipLevels);
    }

    public boolean hasResults() {
        if (Files.exists(this.serializedResultsFile, new LinkOption[0]) && Files.exists(this.outputEventsFile, new LinkOption[0])) {
            boolean bl;
            block9: {
                KryoBackedDecoder decoder = this.openAndInitializeDecoder();
                try {
                    boolean bl2 = bl = decoder.readSmallLong() != 0L;
                    if (decoder == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (decoder != null) {
                            try {
                                decoder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                decoder.close();
            }
            return bl;
        }
        return false;
    }

    public void forEachResult(Consumer<FacadeForOutputTrackedResult> consumer) throws IOException {
        this.forEachResult((long id, Long parentId, SerializableTestResult result, OutputRanges outputRanges) -> consumer.accept(new FacadeForOutputTrackedResult(result)));
    }

    public void forEachResult(ResultProcessor processor) throws IOException {
        try (KryoBackedDecoder resultsDecoder = this.openAndInitializeDecoder();){
            long id;
            while ((id = resultsDecoder.readSmallLong()) != 0L) {
                OutputRanges ranges;
                if (id < 0L) {
                    throw new IllegalStateException("Invalid result id: " + id);
                }
                try {
                    ranges = (OutputRanges)OutputRanges.SERIALIZER.read((Decoder)resultsDecoder);
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                SerializableTestResult testResult = SerializableTestResult.Serializer.deserialize((Decoder)resultsDecoder);
                long parentId = resultsDecoder.readSmallLong();
                if (parentId < 0L) {
                    throw new IllegalStateException("Invalid parent id: " + parentId);
                }
                Long parentIdObj = parentId == 0L ? null : Long.valueOf(parentId);
                processor.process(id, parentIdObj, testResult, ranges);
            }
        }
    }

    private KryoBackedDecoder openAndInitializeDecoder() throws IOException {
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(this.serializedResultsFile, new OpenOption[0]));
        try {
            int version = decoder.readSmallInt();
            if (version != 1) {
                throw new IOException("Unsupported version: " + version);
            }
        }
        catch (Throwable t) {
            try {
                decoder.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
        return decoder;
    }

    public TestOutputReader createOutputReader(Serializer<TestOutputEvent> testOutputEventSerializer) {
        return new TestOutputReader(this.outputEventsFile, testOutputEventSerializer);
    }

    public static final class Writer
    implements Closeable,
    TestListenerInternal {
        private static final long ROOT_ID = 1L;
        private final Map<Object, Long> assignedIds = new HashMap<Object, Long>();
        private final Set<Object> flatteningIds;
        private final List<TestDescriptorInternal> extraFlattenedDescriptors;
        private final List<TestResult> extraFlattenedResults;
        private final Path serializedResultsFile;
        private final int diskSkipLevels;
        private final Path temporaryResultsFile;
        private final KryoBackedEncoder resultsEncoder;
        private final TestOutputWriter outputWriter;
        private long nextId = 1L;
        private final Multimap<TestDescriptorInternal, SerializedMetadata> metadatas = LinkedHashMultimap.create();

        private static boolean isRoot(TestDescriptorInternal descriptor) {
            return descriptor.getParent() == null;
        }

        private static int depth(TestDescriptorInternal descriptor) {
            int depth = 0;
            while (descriptor.getParent() != null) {
                ++depth;
                descriptor = descriptor.getParent();
            }
            return depth;
        }

        private Writer(Path serializedResultsFile, Path outputEventsFile, int diskSkipLevels) throws IOException {
            this.serializedResultsFile = serializedResultsFile;
            this.diskSkipLevels = diskSkipLevels;
            this.flatteningIds = this.isDiskSkipEnabled() ? new HashSet() : Collections.emptySet();
            this.extraFlattenedDescriptors = this.isDiskSkipEnabled() ? new ArrayList() : Collections.emptyList();
            this.extraFlattenedResults = this.isDiskSkipEnabled() ? new ArrayList() : Collections.emptyList();
            Files.createDirectories(serializedResultsFile.getParent(), new FileAttribute[0]);
            this.temporaryResultsFile = Files.createTempFile(serializedResultsFile.getParent(), "in-progress-results-generic", ".bin", new FileAttribute[0]);
            this.resultsEncoder = new KryoBackedEncoder(Files.newOutputStream(this.temporaryResultsFile, new OpenOption[0]));
            Serializer testOutputEventSerializer = TestEventSerializer.create().build(TestOutputEvent.class);
            try {
                this.resultsEncoder.writeSmallInt(1);
                this.outputWriter = new TestOutputWriter(outputEventsFile, (Serializer<TestOutputEvent>)testOutputEventSerializer);
            }
            catch (Throwable t) {
                try {
                    this.resultsEncoder.close();
                }
                catch (Throwable t2) {
                    t.addSuppressed(t2);
                }
                throw t;
            }
        }

        private boolean isDiskSkipEnabled() {
            return this.diskSkipLevels > 0;
        }

        @Override
        public void started(TestDescriptorInternal testDescriptor, TestStartEvent startEvent) {
            long id;
            if (this.isDiskSkipEnabled() && !Writer.isRoot(testDescriptor) && Writer.depth(testDescriptor) <= this.diskSkipLevels) {
                this.flatteningIds.add(testDescriptor.getId());
            }
            if ((id = this.nextId++) == 1L && !Writer.isRoot(testDescriptor)) {
                throw new IllegalStateException("The first test descriptor must be the root, but got: " + testDescriptor);
            }
            this.assignedIds.put(testDescriptor.getId(), id);
        }

        @Override
        public void completed(TestDescriptorInternal testDescriptor, TestResult testResult, TestCompleteEvent completeEvent) {
            if (this.isDiskSkipEnabled() && this.flatteningIds.contains(testDescriptor.getId())) {
                this.extraFlattenedDescriptors.add(testDescriptor);
                this.extraFlattenedResults.add(testResult);
                return;
            }
            SerializableTestResult.Builder testNodeBuilder = SerializableTestResult.builder().name(testDescriptor.getName()).displayName(testDescriptor.getDisplayName()).className(testDescriptor.getClassName()).startTime(testResult.getStartTime()).endTime(testResult.getEndTime()).resultType(testResult.getResultType());
            if (testResult.getAssumptionFailure() != null) {
                testNodeBuilder.assumptionFailure(Writer.convertToSerializableFailure(testResult.getAssumptionFailure()));
            }
            for (TestFailure failure : testResult.getFailures()) {
                testNodeBuilder.addFailure(Writer.convertToSerializableFailure(failure));
            }
            for (SerializedMetadata metadata : this.metadatas.removeAll((Object)testDescriptor)) {
                testNodeBuilder.addMetadata(metadata);
            }
            if (this.isDiskSkipEnabled() && Writer.isRoot(testDescriptor)) {
                boolean hasAssumptionFailure = testResult.getAssumptionFailure() != null;
                for (TestResult flattenedResult : this.extraFlattenedResults) {
                    if (flattenedResult.getAssumptionFailure() != null) {
                        if (hasAssumptionFailure) {
                            throw new IllegalStateException("Multiple assumption failures would need to be handled, but only one is supported: " + testDescriptor);
                        }
                        hasAssumptionFailure = true;
                        testNodeBuilder.assumptionFailure(Writer.convertToSerializableFailure(flattenedResult.getAssumptionFailure()));
                    }
                    for (TestFailure failure : flattenedResult.getFailures()) {
                        testNodeBuilder.addFailure(Writer.convertToSerializableFailure(failure));
                    }
                }
                this.extraFlattenedResults.clear();
                for (TestDescriptorInternal flattenedDescriptor : this.extraFlattenedDescriptors) {
                    for (SerializedMetadata metadata : this.metadatas.removeAll((Object)flattenedDescriptor)) {
                        testNodeBuilder.addMetadata(metadata);
                    }
                }
                this.extraFlattenedDescriptors.clear();
            }
            long id = this.assignedIds.remove(testDescriptor.getId());
            this.resultsEncoder.writeSmallLong(id);
            try {
                OutputRanges outputRanges = this.outputWriter.finishOutput(id);
                OutputRanges.SERIALIZER.write((Encoder)this.resultsEncoder, (Object)outputRanges);
                SerializableTestResult.Serializer.serialize(testNodeBuilder.build(), (Encoder)this.resultsEncoder);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            TestDescriptorInternal parent = this.getFlattenedParent(testDescriptor);
            if (parent != null) {
                Long parentId = this.assignedIds.get(parent.getId());
                if (parentId == null) {
                    throw new IllegalStateException("No id found for test descriptor: " + parent);
                }
                this.resultsEncoder.writeSmallLong(parentId.longValue());
            } else {
                this.resultsEncoder.writeSmallLong(0L);
            }
        }

        private @Nullable TestDescriptorInternal getFlattenedParent(TestDescriptorInternal testDescriptor) {
            if (!this.isDiskSkipEnabled() || Writer.isRoot(testDescriptor)) {
                return testDescriptor.getParent();
            }
            TestDescriptorInternal parent = testDescriptor.getParent();
            assert (parent != null) : "Non-root test descriptor should always have a parent: " + testDescriptor.getDisplayName() + " (id: " + testDescriptor.getId() + ")";
            while (this.flatteningIds.contains(parent.getId())) {
                if ((parent = parent.getParent()) == null) {
                    throw new AssertionError((Object)("Parent of a flattened test descriptor should not be null: " + testDescriptor.getDisplayName() + " (id: " + testDescriptor.getId() + ")"));
                }
            }
            return parent;
        }

        private static SerializableFailure convertToSerializableFailure(TestFailure failure) {
            String message = failure.getDetails().getClassName();
            if (failure.getDetails().getMessage() != null) {
                message = message + ": " + failure.getDetails().getMessage();
            }
            List<String> convertedCauses = ExceptionSerializationUtil.extractCauses((Throwable)failure.getRawFailure()).stream().map(Throwables::getStackTraceAsString).collect(Collectors.toList());
            return new SerializableFailure(message, failure.getDetails().getStacktrace(), failure.getDetails().getClassName(), convertedCauses);
        }

        @Override
        public void output(TestDescriptorInternal testDescriptor, TestOutputEvent event) {
            long outputId = this.isDiskSkipEnabled() && this.flatteningIds.contains(testDescriptor.getId()) ? 1L : this.assignedIds.get(testDescriptor.getId());
            this.outputWriter.writeOutputEvent(outputId, event);
        }

        @Override
        public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
            this.metadatas.put((Object)testDescriptor, (Object)new SerializedMetadata(event.getLogTime(), event.getValues()));
        }

        @Override
        public void close() throws IOException {
            try {
                this.resultsEncoder.writeSmallLong(0L);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.resultsEncoder, this.outputWriter}).stop();
                throw throwable;
            }
            CompositeStoppable.stoppable((Object[])new Object[]{this.resultsEncoder, this.outputWriter}).stop();
            Files.move(this.temporaryResultsFile, this.serializedResultsFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @FunctionalInterface
    public static interface ResultProcessor {
        public void process(long var1, @Nullable Long var3, SerializableTestResult var4, OutputRanges var5) throws IOException;
    }

    public static final class FacadeForOutputTrackedResult {
        private final SerializableTestResult innerResult;

        public FacadeForOutputTrackedResult(SerializableTestResult innerResult) {
            this.innerResult = innerResult;
        }

        public SerializableTestResult getInnerResult() {
            return this.innerResult;
        }
    }
}

