/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.gradle.internal.Cast;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.runner.Description;

@NullMarked
public final class DescriptionMap<V, DV> {
    private final BiFunction<Description, V, DV> descriptionAndValueFactory;
    private final DescriptionWitness<V, DV> witness;
    private final Map<Description, List<DV>> delegate = new LinkedHashMap<Description, List<DV>>();

    public static <V> DescriptionMap<V, SimpleValueWrapper<V>> createSimple() {
        return new DescriptionMap(SimpleValueWrapper::new, SimpleValueWrapper.witness());
    }

    public DescriptionMap(BiFunction<Description, V, DV> descriptionAndValueFactory, DescriptionWitness<V, DV> witness) {
        this.descriptionAndValueFactory = descriptionAndValueFactory;
        this.witness = witness;
    }

    private boolean isSameDescriptionByIdentity(DV value, Description description) {
        return this.witness.getDescription(value) == description;
    }

    public void put(Description description, V value) {
        this.delegate.compute(description, (potentiallyDifferentDesc, list) -> {
            DV descriptionAndValue = this.descriptionAndValueFactory.apply(description, value);
            if (list == null) {
                return Collections.singletonList(descriptionAndValue);
            }
            if (list.size() == 1) {
                if (this.isSameDescriptionByIdentity(list.get(0), description)) {
                    return Collections.singletonList(descriptionAndValue);
                }
                ArrayList<DV> newList = new ArrayList<DV>(list.size() + 1);
                newList.addAll((Collection<DV>)list);
                newList.add(descriptionAndValue);
                return newList;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!this.isSameDescriptionByIdentity(list.get(i), description)) continue;
                list.set(i, descriptionAndValue);
                return list;
            }
            list.add(descriptionAndValue);
            return list;
        });
    }

    public @Nullable V get(Description description) {
        List<DV> list = this.delegate.get(description);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return this.witness.getValue(list.get(0));
        }
        for (DV descriptionAndValue : list) {
            if (!this.isSameDescriptionByIdentity(descriptionAndValue, description)) continue;
            return this.witness.getValue(descriptionAndValue);
        }
        return null;
    }

    public List<V> getByEquality(Description description) {
        List<DV> list = this.delegate.get(description);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<V> values = new ArrayList<V>(list.size());
        for (DV descriptionAndValue : list) {
            values.add(this.witness.getValue(descriptionAndValue));
        }
        return Collections.unmodifiableList(values);
    }

    public @Nullable V getFirstMatching(Predicate<Description> predicate) {
        for (List<DV> value : this.delegate.values()) {
            for (DV descriptionAndValue : value) {
                Description description = this.witness.getDescription(descriptionAndValue);
                if (!predicate.test(description)) continue;
                return this.witness.getValue(descriptionAndValue);
            }
        }
        return null;
    }

    public @Nullable V remove(Description description) {
        List<DV> list = this.delegate.get(description);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            this.delegate.remove(description);
            return this.witness.getValue(list.get(0));
        }
        for (int i = 0; i < list.size(); ++i) {
            DV descriptionAndValue = list.get(i);
            if (!this.isSameDescriptionByIdentity(descriptionAndValue, description)) continue;
            list.remove(i);
            return this.witness.getValue(descriptionAndValue);
        }
        return null;
    }

    public void clear() {
        this.delegate.clear();
    }

    public @Nullable V getOnlyValue() {
        V onlyValue = null;
        for (List<DV> valueList : this.delegate.values()) {
            for (DV descriptionAndValue : valueList) {
                if (onlyValue != null) {
                    return null;
                }
                onlyValue = this.witness.getValue(descriptionAndValue);
            }
        }
        return onlyValue;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public void forEach(BiConsumer<? super Description, ? super V> action) {
        for (List<DV> valueList : this.delegate.values()) {
            for (DV descriptionAndValue : valueList) {
                action.accept((Description)this.witness.getDescription(descriptionAndValue), this.witness.getValue(descriptionAndValue));
            }
        }
    }

    @NullMarked
    public static final class SimpleValueWrapper<V> {
        private static final DescriptionWitness<Object, SimpleValueWrapper<Object>> WITNESS = new DescriptionWitness<Object, SimpleValueWrapper<Object>>(){

            @Override
            public Description getDescription(SimpleValueWrapper<Object> wrappedValue) {
                return wrappedValue.getDescription();
            }

            @Override
            public Object getValue(SimpleValueWrapper<Object> wrappedValue) {
                return wrappedValue.getValue();
            }
        };
        private final Description description;
        private final V value;

        public static <V> DescriptionWitness<V, SimpleValueWrapper<V>> witness() {
            return (DescriptionWitness)Cast.uncheckedNonnullCast(WITNESS);
        }

        public SimpleValueWrapper(Description description, V value) {
            this.description = description;
            this.value = value;
        }

        public Description getDescription() {
            return this.description;
        }

        public V getValue() {
            return this.value;
        }
    }

    @NullMarked
    public static interface DescriptionWitness<V, DV> {
        public Description getDescription(DV var1);

        public V getValue(DV var1);
    }
}

