/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.properties.InputBehavior;
import org.jspecify.annotations.Nullable;

public interface InputVisitor {
    default public void visitInputProperty(String propertyName, ValueSupplier value) {
    }

    default public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputFileValueSupplier value) {
    }

    public static class InputFileValueSupplier
    implements FileValueSupplier {
        private final @Nullable Object value;
        private final FileNormalizer normalizer;
        private final DirectorySensitivity directorySensitivity;
        private final LineEndingSensitivity lineEndingSensitivity;
        private final Supplier<FileCollection> files;

        public InputFileValueSupplier(@Nullable Object value, FileNormalizer normalizer, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, Supplier<FileCollection> files) {
            this.value = value;
            this.normalizer = normalizer;
            this.directorySensitivity = directorySensitivity;
            this.lineEndingSensitivity = lineEndingSensitivity;
            this.files = files;
        }

        @Override
        public @Nullable Object getValue() {
            return this.value;
        }

        public FileNormalizer getNormalizer() {
            return this.normalizer;
        }

        public DirectorySensitivity getDirectorySensitivity() {
            return this.directorySensitivity;
        }

        public LineEndingSensitivity getLineEndingNormalization() {
            return this.lineEndingSensitivity;
        }

        @Override
        public FileCollection getFiles() {
            return this.files.get();
        }
    }

    public static interface FileValueSupplier
    extends ValueSupplier {
        public FileCollection getFiles();
    }

    public static interface ValueSupplier {
        public @Nullable Object getValue();
    }
}

