/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.configurer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.internal.configurer.AbstractUniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementAdapter;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.jspecify.annotations.Nullable;

public class EclipseModelAwareUniqueProjectNameProvider
extends AbstractUniqueProjectNameProvider {
    private @Nullable Map<ProjectIdentity, String> deduplicated;
    private List<ProjectStateWrapper> reservedNames = Collections.emptyList();
    private Map<ProjectIdentity, ProjectStateWrapper> projectToInformationMap = Collections.emptyMap();

    public EclipseModelAwareUniqueProjectNameProvider(ProjectStateRegistry projectRegistry) {
        super(projectRegistry);
    }

    public synchronized void setReservedProjectNames(List<String> reservedNames) {
        this.reservedNames = reservedNames.stream().map(ProjectStateWrapper::new).collect(Collectors.toList());
        this.deduplicated = null;
    }

    @Override
    public String getUniqueName(ProjectIdentity projectIdentity) {
        String uniqueName = this.getDeduplicatedNames().get(projectIdentity);
        if (uniqueName != null) {
            return uniqueName;
        }
        ProjectStateWrapper information = this.projectToInformationMap.get(projectIdentity);
        if (information != null) {
            return information.name;
        }
        return projectIdentity.getProjectName();
    }

    private synchronized Map<ProjectIdentity, String> getDeduplicatedNames() {
        if (this.deduplicated == null) {
            this.projectToInformationMap = new HashMap<ProjectIdentity, ProjectStateWrapper>();
            for (ProjectState state : this.projectRegistry.getAllProjects()) {
                String projectNameForEclipse = EclipseModelAwareUniqueProjectNameProvider.getName(state);
                this.projectToInformationMap.put(state.getIdentity(), new ProjectStateWrapper(projectNameForEclipse, state));
            }
            HierarchicalElementDeduplicator<ProjectStateWrapper> deduplicator = new HierarchicalElementDeduplicator<ProjectStateWrapper>(new ProjectPathDeduplicationAdapter(this.projectToInformationMap));
            ArrayList<ProjectStateWrapper> allElements = new ArrayList<ProjectStateWrapper>();
            allElements.addAll(this.reservedNames);
            allElements.addAll(this.projectToInformationMap.values());
            this.deduplicated = deduplicator.deduplicate(allElements).entrySet().stream().collect(Collectors.toMap(e -> ((ProjectStateWrapper)e.getKey()).project.getIdentity(), Map.Entry::getValue));
        }
        return this.deduplicated;
    }

    private static String getName(ProjectState state) {
        state.getOwner().ensureProjectsConfigured();
        EclipseModel model = (EclipseModel)state.getMutableModel().getExtensions().findByType(EclipseModel.class);
        if (model != null && model.getProject().getName() != null) {
            return model.getProject().getName();
        }
        return state.getName();
    }

    private static class ProjectStateWrapper {
        private final String name;
        private final @Nullable ProjectState project;

        public ProjectStateWrapper(String name, @Nullable ProjectState project) {
            this.name = name;
            this.project = project;
        }

        public ProjectStateWrapper(String name) {
            this(name, null);
        }
    }

    private class ProjectPathDeduplicationAdapter
    implements HierarchicalElementAdapter<ProjectStateWrapper> {
        private final Map<ProjectIdentity, ProjectStateWrapper> projectToInformationMap;

        public ProjectPathDeduplicationAdapter(Map<ProjectIdentity, ProjectStateWrapper> projectToInformationMap) {
            this.projectToInformationMap = projectToInformationMap;
        }

        @Override
        public String getName(ProjectStateWrapper element) {
            return element.name;
        }

        @Override
        public String getIdentityName(ProjectStateWrapper element) {
            return element.name;
        }

        @Override
        public @Nullable ProjectStateWrapper getParent(ProjectStateWrapper element) {
            if (element.project == null) {
                return null;
            }
            ProjectIdentity parentInBuildTree = EclipseModelAwareUniqueProjectNameProvider.this.findParentInBuildTree(element.project.getIdentity());
            return parentInBuildTree == null ? null : this.projectToInformationMap.get(parentInBuildTree);
        }
    }
}

