/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.dm;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.serialize.codecs.dm.IdentityMapping;
import org.gradle.internal.serialize.codecs.dm.MappingSpec;
import org.gradle.internal.serialize.codecs.dm.TransformMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gradle/internal/serialize/codecs/dm/FixedArtifactVariantSelector;", "Lorg/gradle/api/internal/artifacts/transform/ArtifactVariantSelector;", "matchingOnArtifactFormat", "", "transforms", "", "Lorg/gradle/api/internal/attributes/ImmutableAttributes;", "Lorg/gradle/internal/serialize/codecs/dm/MappingSpec;", "<init>", "(ZLjava/util/Map;)V", "select", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedArtifactSet;", "candidates", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedVariantSet;", "requestAttributes", "allowNoMatchingVariants", "dependency-management-serialization-codecs"})
final class FixedArtifactVariantSelector
implements ArtifactVariantSelector {
    private final boolean matchingOnArtifactFormat;
    @NotNull
    private final Map<ImmutableAttributes, MappingSpec> transforms;

    public FixedArtifactVariantSelector(boolean matchingOnArtifactFormat, @NotNull Map<ImmutableAttributes, ? extends MappingSpec> transforms) {
        Intrinsics.checkNotNullParameter(transforms, (String)"transforms");
        this.matchingOnArtifactFormat = matchingOnArtifactFormat;
        this.transforms = transforms;
    }

    @NotNull
    public ResolvedArtifactSet select(@NotNull ResolvedVariantSet candidates, @NotNull ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants) {
        ResolvedArtifactSet resolvedArtifactSet;
        Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)requestAttributes, (String)"requestAttributes");
        if (!(candidates.getCandidates().size() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List list = candidates.getCandidates();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCandidates(...)");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        ResolvedVariant variant = (ResolvedVariant)object;
        MappingSpec spec = this.transforms.get(variant.getAttributes().asImmutable());
        if (spec == null) {
            if (this.matchingOnArtifactFormat) {
                ResolvedArtifactSet resolvedArtifactSet2 = ResolvedArtifactSet.EMPTY;
                Intrinsics.checkNotNull((Object)resolvedArtifactSet2);
                resolvedArtifactSet = resolvedArtifactSet2;
            } else {
                ResolvedArtifactSet resolvedArtifactSet3 = variant.getArtifacts();
                Intrinsics.checkNotNull((Object)resolvedArtifactSet3);
                resolvedArtifactSet = resolvedArtifactSet3;
            }
        } else if (spec instanceof IdentityMapping) {
            ResolvedArtifactSet resolvedArtifactSet4 = variant.getArtifacts();
            resolvedArtifactSet = resolvedArtifactSet4;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet4, (String)"getArtifacts(...)");
        } else if (spec instanceof TransformMapping) {
            ResolvedArtifactSet resolvedArtifactSet5 = candidates.transformCandidate(variant, (VariantDefinition)spec);
            resolvedArtifactSet = resolvedArtifactSet5;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet5, (String)"transformCandidate(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvedArtifactSet;
    }
}

