/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.DeferredResult;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.impl.DefaultWorkValidationContext;
import org.gradle.internal.execution.steps.DeferredExecutionAwareStep;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.jspecify.annotations.Nullable;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private final DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> pipeline;
    private final InternalProblems problems;

    public DefaultExecutionEngine(DeferredExecutionAwareStep<? super ExecutionRequestContext, ? extends ExecutionEngine.Result> pipeline, InternalProblems problems) {
        this.pipeline = pipeline;
        this.problems = problems;
    }

    @Override
    public ExecutionEngine.Request createRequest(final UnitOfWork work) {
        return new ExecutionEngine.Request(){
            private @Nullable String nonIncrementalReason;
            private @Nullable WorkValidationContext validationContext;

            private ExecutionRequestContext createExecutionRequestContext() {
                WorkValidationContext validationContext = this.validationContext != null ? this.validationContext : new DefaultWorkValidationContext(WorkValidationContext.TypeOriginInspector.NO_OP, DefaultExecutionEngine.this.problems);
                return new ExecutionRequestContext(this.nonIncrementalReason, validationContext);
            }

            @Override
            public void forceNonIncremental(String nonIncremental) {
                this.nonIncrementalReason = nonIncremental;
            }

            @Override
            public void withValidationContext(WorkValidationContext validationContext) {
                this.validationContext = validationContext;
            }

            @Override
            public ExecutionEngine.Result execute() {
                return (ExecutionEngine.Result)DefaultExecutionEngine.this.pipeline.execute(work, this.createExecutionRequestContext());
            }

            @Override
            public <T> Deferrable<Try<T>> executeDeferred(Cache<Identity, DeferredResult<T>> cache) {
                return DefaultExecutionEngine.this.pipeline.executeDeferred(work, this.createExecutionRequestContext(), cache);
            }
        };
    }
}

