/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import java.io.File;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.file.TreeType;

public interface OutputVisitor {
    default public void visitOutputProperty(String propertyName, TreeType type, OutputFileValueSupplier value) {
    }

    default public void visitLocalState(File localStateRoot) {
    }

    default public void visitDestroyable(File destroyableRoot) {
    }

    public static abstract class OutputFileValueSupplier
    implements InputVisitor.FileValueSupplier {
        private final FileCollection files;

        public OutputFileValueSupplier(FileCollection files) {
            this.files = files;
        }

        public static OutputFileValueSupplier fromStatic(final File root, FileCollection fileCollection) {
            return new OutputFileValueSupplier(fileCollection){

                @Override
                public File getValue() {
                    return root;
                }
            };
        }

        public static OutputFileValueSupplier fromSupplier(final Supplier<File> root, FileCollection fileCollection) {
            return new OutputFileValueSupplier(fileCollection){

                @Override
                public File getValue() {
                    return (File)root.get();
                }
            };
        }

        @Override
        public abstract File getValue();

        @Override
        public FileCollection getFiles() {
            return this.files;
        }
    }
}

