/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;

public class DefaultModuleVersionSelector
implements ModuleVersionSelector {
    private final ModuleIdentifier module;
    private final String version;

    private DefaultModuleVersionSelector(ModuleIdentifier module, String versionConstraint) {
        this.module = module;
        this.version = versionConstraint;
    }

    public String getGroup() {
        return this.module.getGroup();
    }

    public String getName() {
        return this.module.getName();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec(this).isSatisfiedBy(identifier);
    }

    public ModuleIdentifier getModule() {
        return this.module;
    }

    public String toString() {
        return String.format("%s:%s", this.module, this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultModuleVersionSelector)) {
            return false;
        }
        DefaultModuleVersionSelector that = (DefaultModuleVersionSelector)o;
        return Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.module, this.version});
    }

    @Deprecated
    public static ModuleVersionSelector newSelector(ModuleIdentifier module, String version) {
        return new DefaultModuleVersionSelector(module, version);
    }

    public static ModuleVersionSelector newSelector(ModuleVersionIdentifier moduleVersionId) {
        return new DefaultModuleVersionSelector(moduleVersionId.getModule(), moduleVersionId.getVersion());
    }

    public static ModuleVersionSelector newSelector(ModuleComponentIdentifier moduleComponentId) {
        return new DefaultModuleVersionSelector(moduleComponentId.getModuleIdentifier(), moduleComponentId.getVersion());
    }

    public static ModuleVersionSelector newSelector(ModuleComponentSelector selector) {
        return new DefaultModuleVersionSelector(selector.getModuleIdentifier(), selector.getVersion());
    }
}

