/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestResult;
import org.jspecify.annotations.Nullable;

public class TestMethodResult {
    private final long id;
    private final String name;
    private final String displayName;
    private final TestResult.ResultType resultType;
    private final long duration;
    private final long endTime;
    private final List<SerializedMetadata> metadatas;
    private final List<SerializableFailure> failures;
    private SerializableFailure assumptionFailure = null;

    public TestMethodResult(long id, String name, String displayName, TestResult.ResultType resultType, long duration, long endTime, List<SerializedMetadata> metadatas) {
        if (id < 1L) {
            throw new IllegalArgumentException("id must be > 0");
        }
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.resultType = resultType;
        this.duration = duration;
        this.endTime = endTime;
        this.metadatas = metadatas;
        this.failures = new ArrayList<SerializableFailure>();
    }

    public TestMethodResult addFailure(String message, String stackTrace, String exceptionType) {
        this.failures.add(new SerializableFailure(message, stackTrace, exceptionType));
        return this;
    }

    public TestMethodResult setAssumptionFailure(@Nullable String message, String stackTrace, String exceptionType) {
        this.assumptionFailure = new SerializableFailure(message == null ? "(no message)" : message, stackTrace, exceptionType);
        return this;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<SerializableFailure> getFailures() {
        return this.failures;
    }

    public @Nullable SerializableFailure getAssumptionFailure() {
        return this.assumptionFailure;
    }

    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<SerializedMetadata> getMetadatas() {
        return this.metadatas;
    }
}

