/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.execution.ImmutableUnitOfWork;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.InputVisitor;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

class NonNormalizedIdentityImmutableTransformExecution
extends AbstractTransformExecution
implements ImmutableUnitOfWork {
    private final FileSystemAccess fileSystemAccess;
    private final ImmutableWorkspaceProvider workspaceProvider;

    public NonNormalizedIdentityImmutableTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, TransformExecutionListener transformExecutionListener, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, FileSystemAccess fileSystemAccess, ImmutableWorkspaceProvider workspaceProvider, boolean disableCachingByProperty) {
        super(transform, inputArtifact, dependencies, subject, transformExecutionListener, buildOperationRunner, progressEventEmitter, fileCollectionFactory, inputFingerprinter, disableCachingByProperty);
        this.fileSystemAccess = fileSystemAccess;
        this.workspaceProvider = workspaceProvider;
    }

    public ImmutableWorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    @Override
    protected TransformWorkspaceIdentity createIdentity(Map<String, ValueSnapshot> scalarInputs, Map<String, CurrentFileCollectionFingerprint> fileInputs) {
        FileSystemLocationSnapshot inputArtifactSnapshot = this.fileSystemAccess.read(this.inputArtifact.getAbsolutePath());
        HashCode inputArtifactSnapshotHash = inputArtifactSnapshot.getHash();
        return TransformWorkspaceIdentity.createNonNormalizedImmutable(scalarInputs.get("inputArtifactPath"), inputArtifactSnapshotHash, scalarInputs.get("inputPropertiesHash"), fileInputs.get("inputArtifactDependencies").getHash());
    }

    public void visitMutableInputs(InputVisitor visitor) {
        this.visitInputArtifact(visitor);
    }
}

