/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.ComponentVariantIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.notations.ComponentIdentifierParserFactory;
import org.gradle.internal.component.external.model.DefaultComponentVariantIdentifier;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.VersionNumber;
import org.jspecify.annotations.Nullable;

public class CapabilityConflictResolver {
    private final ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> rules;
    private final NotationParser<Object, ComponentIdentifier> componentNotationParser;

    public CapabilityConflictResolver(ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> rules) {
        this.rules = rules;
        this.componentNotationParser = new ComponentIdentifierParserFactory().create();
    }

    public void resolve(String group, String name, Collection<NodeState> nodes) {
        if (nodes.size() == 1) {
            NodeState onlyNode = nodes.iterator().next();
            onlyNode.getComponent().getModule().replaceWith(onlyNode.getComponent());
            return;
        }
        ImmutableList<Candidate> candidates = CapabilityConflictResolver.discoverCandidates(group, name, nodes);
        SelectedCandidate winner = this.findSelectedCandidate(group, name, candidates);
        if (winner != null) {
            for (Candidate candidate : candidates) {
                if (!candidate.node.getComponent().getComponentId().equals(winner.node.getComponent().getComponentId()) || candidate.node == winner.node) continue;
                candidate.node.evict();
            }
            HashSet<ModuleResolveState> seen = new HashSet<ModuleResolveState>();
            ModuleResolveState winningModule = winner.node.getComponent().getModule();
            winningModule.replaceWith(winner.node.getComponent());
            winner.node.getComponent().addCause(ComponentSelectionReasons.CONFLICT_RESOLUTION.withDescription(winner.reason));
            seen.add(winningModule);
            for (Candidate losingCandidate : candidates) {
                ModuleResolveState losingModule = losingCandidate.node.getComponent().getModule();
                if (!seen.add(losingModule)) continue;
                losingModule.replaceWith(winner.node.getComponent());
            }
        } else {
            for (Candidate candidate : candidates) {
                Set<NodeState> conflictedNodes = candidates.stream().map(c -> c.node).filter(node -> node != candidate.node).collect(Collectors.toSet());
                ComponentState component = candidate.node.getComponent();
                component.rejectForCapabilityConflict((Capability)candidate.capability, conflictedNodes);
                component.getModule().replaceWith(component);
            }
        }
    }

    private static ImmutableList<Candidate> discoverCandidates(String group, String name, Collection<NodeState> nodes) {
        ImmutableList.Builder candidates = ImmutableList.builderWithExpectedSize((int)nodes.size());
        for (NodeState node : nodes) {
            ImmutableCapability capability = node.findCapability(group, name);
            if (capability == null) {
                throw new IllegalArgumentException("Node " + node.getDisplayName() + " does not provide capability " + group + ":" + name);
            }
            candidates.add((Object)new Candidate(node, capability));
        }
        return candidates.build();
    }

    private @Nullable SelectedCandidate findSelectedCandidate(String group, String name, ImmutableList<Candidate> initialCandidates) {
        ImmutableList<Candidate> candidates = initialCandidates;
        for (CapabilitiesResolutionInternal.CapabilityResolutionRule rule : this.rules) {
            if (!rule.appliesTo(group, name)) continue;
            DefaultCapabilityResolutionDetails details = new DefaultCapabilityResolutionDetails(this.componentNotationParser, group, name, candidates);
            try {
                rule.getAction().execute((Object)details);
            }
            catch (Exception ex) {
                if (ex instanceof InvalidUserCodeException) {
                    throw ex;
                }
                throw new InvalidUserCodeException("Capability resolution rule failed with an error", (Throwable)ex);
            }
            if (details.useHighest) {
                ImmutableList<Candidate> highestVersions = CapabilityConflictResolver.findHighestVersions(candidates);
                if (highestVersions.size() == 1) {
                    return new SelectedCandidate(((Candidate)highestVersions.iterator().next()).node, () -> "latest version of capability " + group + ":" + name);
                }
                candidates = highestVersions;
                continue;
            }
            if (details.selected == null) continue;
            NodeState selectedNode = ((DefaultCapabilityResolutionDetails)details).selected.node;
            Describable selectionReason = details.reason != null ? () -> "On capability " + group + ":" + name + " " + details.reason : () -> "Explicit selection of " + selectedNode.getComponent().getComponentId().getDisplayName() + " variant " + selectedNode.getMetadata().getName();
            return new SelectedCandidate(selectedNode, selectionReason);
        }
        return null;
    }

    private static ImmutableList<Candidate> findHighestVersions(ImmutableList<Candidate> candidates) {
        String highestVersion = null;
        ImmutableList.Builder highestVersionCandidates = ImmutableList.builderWithExpectedSize((int)candidates.size());
        for (Candidate candidate : candidates) {
            String version = candidate.capability.getVersion();
            int comparison = VersionNumber.parse((String)version).compareTo(VersionNumber.parse(highestVersion));
            if (highestVersion == null) {
                highestVersion = version;
                highestVersionCandidates.add((Object)candidate);
                continue;
            }
            if (comparison > 0) {
                highestVersion = version;
                highestVersionCandidates = ImmutableList.builderWithExpectedSize((int)candidates.size());
                highestVersionCandidates.add((Object)candidate);
                continue;
            }
            if (comparison != 0) continue;
            highestVersionCandidates.add((Object)candidate);
        }
        return highestVersionCandidates.build();
    }

    static class SelectedCandidate {
        final NodeState node;
        final Describable reason;

        SelectedCandidate(NodeState node, Describable reason) {
            this.node = node;
            this.reason = reason;
        }
    }

    private static class Candidate {
        final NodeState node;
        final ImmutableCapability capability;

        public Candidate(NodeState node, ImmutableCapability capability) {
            this.node = node;
            this.capability = capability;
        }
    }

    private static class DefaultCapabilityResolutionDetails
    implements CapabilityResolutionDetails {
        private final NotationParser<Object, ComponentIdentifier> componentIdParser;
        private final String group;
        private final String name;
        private final ImmutableList<Candidate> candidates;
        private boolean useHighest;
        private @Nullable String reason;
        private @Nullable Candidate selected;

        private DefaultCapabilityResolutionDetails(NotationParser<Object, ComponentIdentifier> componentIdParser, String group, String name, ImmutableList<Candidate> candidates) {
            this.componentIdParser = componentIdParser;
            this.group = group;
            this.name = name;
            this.candidates = candidates;
        }

        public ImmutableCapability getCapability() {
            return new DefaultImmutableCapability(this.group, this.name, null);
        }

        public ImmutableList<ComponentVariantIdentifier> getCandidates() {
            ImmutableList.Builder candidateIds = ImmutableList.builderWithExpectedSize((int)this.candidates.size());
            for (Candidate candidate : this.candidates) {
                candidateIds.add((Object)new DefaultComponentVariantIdentifier(candidate.node.getComponent().getComponentId(), candidate.node.getMetadata().getName()));
            }
            return candidateIds.build();
        }

        public CapabilityResolutionDetails select(ComponentVariantIdentifier candidateId) {
            for (Candidate candidate : this.candidates) {
                if (!candidate.node.getComponent().getComponentId().equals(candidateId.getId()) || !candidate.node.getMetadata().getName().equals(candidateId.getVariantName())) continue;
                this.selected = candidate;
                break;
            }
            return this;
        }

        public CapabilityResolutionDetails select(Object notation) {
            ComponentIdentifier selectedComponentId = (ComponentIdentifier)this.componentIdParser.parseNotation(notation);
            for (Candidate candidate : this.candidates) {
                ComponentIdentifier candidateComponentId = candidate.node.getComponent().getComponentId();
                if (selectedComponentId.equals(candidateComponentId)) {
                    this.selected = candidate;
                    return this;
                }
                if (!(candidateComponentId instanceof ModuleComponentIdentifier) || !(selectedComponentId instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier candidateId = (ModuleComponentIdentifier)candidateComponentId;
                ModuleComponentIdentifier selectedId = (ModuleComponentIdentifier)selectedComponentId;
                if (!candidateId.getModuleIdentifier().equals(selectedId.getModuleIdentifier())) continue;
                this.selected = candidate;
                return this;
            }
            List formattedCandidates = this.candidates.stream().map(c -> c.node.getDisplayName()).sorted().collect(Collectors.toList());
            throw new InvalidUserCodeException(selectedComponentId + " is not a valid candidate for conflict resolution on capability '" + this.group + ":" + this.name + "': candidates are " + formattedCandidates);
        }

        public CapabilityResolutionDetails selectHighestVersion() {
            this.useHighest = true;
            return this;
        }

        public CapabilityResolutionDetails because(String reason) {
            this.reason = reason;
            return this;
        }
    }
}

