/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.emitters;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.ProblemEmitter;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.problems.ProblemUtils;
import org.gradle.problems.internal.rendering.ProblemWriter;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleProblemEmitter
implements ProblemEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleProblemEmitter.class);
    private final WarningMode warningMode;

    public ConsoleProblemEmitter(WarningMode warningMode) {
        this.warningMode = warningMode;
    }

    public void emit(InternalProblem problem, @Nullable OperationIdentifier id) {
        if (this.shouldRender(problem)) {
            ConsoleProblemEmitter.render(problem);
        }
    }

    private boolean shouldRender(InternalProblem problem) {
        if (this.warningMode != WarningMode.All) {
            return false;
        }
        return !ProblemUtils.isInGroup((InternalProblem)problem, (ProblemGroup)GradleCoreProblemGroup.deprecation()) && !ProblemUtils.isInGroup((InternalProblem)problem, (ProblemGroup)GradleCoreProblemGroup.compilation().java());
    }

    private static void render(InternalProblem problem) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ProblemWriter.simple().write(problem, (Writer)pw);
        String result = sw.toString();
        LOGGER.warn(result);
    }
}

