/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputRanges;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

final class TestOutputWriter
implements Closeable {
    private final KryoBackedEncoder outputEventsEncoder;
    private final Serializer<TestOutputEvent> testOutputEventSerializer;
    private final Map<Long, OutputStarts> outputEntryRangeStarts = new HashMap<Long, OutputStarts>();

    public TestOutputWriter(Path outputEventsFile, Serializer<TestOutputEvent> testOutputEventSerializer) throws IOException {
        Files.deleteIfExists(outputEventsFile);
        this.outputEventsEncoder = new KryoBackedEncoder(Files.newOutputStream(outputEventsFile, new OpenOption[0]));
        this.testOutputEventSerializer = testOutputEventSerializer;
    }

    public void writeOutputEvent(long id, TestOutputEvent event) {
        OutputStarts ranges = this.outputEntryRangeStarts.computeIfAbsent(id, i -> new OutputStarts());
        switch (event.getDestination()) {
            case StdOut: {
                if (ranges.startStdout != -1L) break;
                ranges.startStdout = this.outputEventsEncoder.getWritePosition();
                break;
            }
            case StdErr: {
                if (ranges.startStderr != -1L) break;
                ranges.startStderr = this.outputEventsEncoder.getWritePosition();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown destination: " + event.getDestination());
            }
        }
        try {
            this.outputEventsEncoder.writeLong(id);
            this.testOutputEventSerializer.write((Encoder)this.outputEventsEncoder, (Object)((DefaultTestOutputEvent)event));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public OutputRanges finishOutput(long id) {
        OutputStarts outputStarts = this.outputEntryRangeStarts.remove(id);
        return OutputRanges.of(outputStarts != null ? outputStarts.startStdout : -1L, outputStarts != null ? outputStarts.startStderr : -1L, outputStarts != null ? this.outputEventsEncoder.getWritePosition() : -1L);
    }

    @Override
    public void close() {
        this.outputEventsEncoder.close();
    }

    private static final class OutputStarts {
        private long startStdout = -1L;
        private long startStderr = -1L;

        private OutputStarts() {
        }
    }
}

