/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.util.List;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.internal.resolve.ArtifactResolveException;

public class ArtifactNotFoundException
extends ArtifactResolveException {
    public ArtifactNotFoundException(ComponentArtifactIdentifier artifact, List<String> attemptedLocations) {
        super(ArtifactNotFoundException.format(artifact, attemptedLocations));
    }

    private static String format(ComponentArtifactIdentifier artifact, List<String> locations) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Could not find %s.", artifact.getDisplayName()));
        if (!locations.isEmpty()) {
            builder.append(String.format("%nSearched in the following locations:", new Object[0]));
            for (String location : locations) {
                builder.append(String.format("%n    %s", location));
            }
        }
        return builder.toString();
    }
}

