/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.MultipleCandidatesDetails;

public class DefaultOrderedDisambiguationRule<T>
implements Action<MultipleCandidatesDetails<T>> {
    private final Comparator<? super T> comparator;
    private final boolean pickFirst;

    public DefaultOrderedDisambiguationRule(Comparator<? super T> comparator, boolean pickFirst) {
        this.comparator = comparator;
        this.pickFirst = pickFirst;
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        Object cmp;
        Set candidateValues = details.getCandidateValues();
        Object min = null;
        Object max = null;
        for (Object value : candidateValues) {
            if (min == null || this.comparator.compare(value, min) < 0) {
                min = value;
            }
            if (max != null && this.comparator.compare(value, max) <= 0) continue;
            max = value;
        }
        Object t = cmp = this.pickFirst ? min : max;
        if (cmp != null) {
            for (Object value : candidateValues) {
                if (!value.equals(cmp)) continue;
                details.closestMatch(value);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOrderedDisambiguationRule that = (DefaultOrderedDisambiguationRule)o;
        return this.pickFirst == that.pickFirst && this.comparator.equals(that.comparator);
    }

    public int hashCode() {
        int result = this.comparator.hashCode();
        result = 31 * result + Boolean.hashCode(this.pickFirst);
        return result;
    }
}

