/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;

public class JUnitPlatformSpec
implements Serializable {
    private final TestFilterSpec filter;
    private final Set<String> includeEngines;
    private final Set<String> excludeEngines;
    private final Set<String> includeTags;
    private final Set<String> excludeTags;
    private final boolean isDryRun;
    private final File baseDefinitionsDir;

    public JUnitPlatformSpec(TestFilterSpec filter, Set<String> includeEngines, Set<String> excludeEngines, Set<String> includeTags, Set<String> excludeTags, boolean isDryRun, File baseDefinitionsDir) {
        this.filter = filter;
        this.includeEngines = includeEngines;
        this.excludeEngines = excludeEngines;
        this.includeTags = includeTags;
        this.excludeTags = excludeTags;
        this.isDryRun = isDryRun;
        this.baseDefinitionsDir = baseDefinitionsDir;
    }

    public TestFilterSpec getFilter() {
        return this.filter;
    }

    public List<String> getIncludeEngines() {
        return new ArrayList<String>(this.includeEngines);
    }

    public List<String> getExcludeEngines() {
        return new ArrayList<String>(this.excludeEngines);
    }

    public List<String> getIncludeTags() {
        return new ArrayList<String>(this.includeTags);
    }

    public List<String> getExcludeTags() {
        return new ArrayList<String>(this.excludeTags);
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public File getBaseDefinitionsDir() {
        return this.baseDefinitionsDir;
    }
}

