/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.service.scopes;

import org.gradle.api.internal.SettingsInternal;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.composite.BuildIncludeListener;

import java.util.HashSet;
import java.util.Set;

public class BrokenBuildsCapturingListener implements BuildIncludeListener {

    private final Set<BuildState> brokenBuilds = new HashSet<>();
    private final Set<SettingsInternal> brokenSettings = new HashSet<>();

    @Override
    public void buildInclusionFailed(BuildState buildState) {
        brokenBuilds.add(buildState);
    }

    @Override
    public Set<BuildState> getBrokenBuilds() {
        return brokenBuilds;
    }

    @Override
    public void settingsScriptFailed(SettingsInternal settingsScript) {
        getBrokenSettings().add(settingsScript);
    }

    @Override
    public Set<SettingsInternal> getBrokenSettings() {
        return brokenSettings;
    }
}
