/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.util.Comparator;
import org.gradle.internal.jvm.inspection.JavaInstallationCapability;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.util.internal.VersionNumber;

public class JvmInstallationMetadataComparator
implements Comparator<JvmInstallationMetadata> {
    private final File currentJavaHome;

    public JvmInstallationMetadataComparator(File currentJavaHome) {
        this.currentJavaHome = currentJavaHome;
    }

    @Override
    public int compare(JvmInstallationMetadata o1, JvmInstallationMetadata o2) {
        return Comparator.comparing(this::isCurrentJvm).thenComparing(this::hasCompiler).thenComparing(this::hasJavadoc).thenComparing(this::hasJar).thenComparing(this::extractVendor, Comparator.reverseOrder()).thenComparing(this::getToolchainVersion).thenComparing(JvmInstallationMetadata::getJavaHome).reversed().compare(o1, o2);
    }

    boolean isCurrentJvm(JvmInstallationMetadata metadata) {
        return metadata.getJavaHome().toFile().equals(this.currentJavaHome);
    }

    private boolean hasCompiler(JvmInstallationMetadata metadata) {
        return metadata.getCapabilities().contains((Object)JavaInstallationCapability.JAVA_COMPILER);
    }

    private boolean hasJavadoc(JvmInstallationMetadata metadata) {
        return metadata.getCapabilities().contains((Object)JavaInstallationCapability.JAVADOC_TOOL);
    }

    private boolean hasJar(JvmInstallationMetadata metadata) {
        return metadata.getCapabilities().contains((Object)JavaInstallationCapability.JAR_TOOL);
    }

    private JvmVendor.KnownJvmVendor extractVendor(JvmInstallationMetadata metadata) {
        return metadata.getVendor().getKnownVendor();
    }

    private VersionNumber getToolchainVersion(JvmInstallationMetadata metadata) {
        return VersionNumber.withPatchNumber().parse(metadata.getJavaVersion());
    }
}

