/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputRecorder;
import org.gradle.internal.resolve.caching.ImplicitInputsProvidingService;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ImplicitInputsCapturingInstantiator
implements Instantiator {
    private final ServiceLookup delegate;
    private final InstantiatorFactory instantiatorFactory;

    public ImplicitInputsCapturingInstantiator(ServiceLookup delegate, InstantiatorFactory instantiatorFactory) {
        this.delegate = delegate;
        this.instantiatorFactory = instantiatorFactory;
    }

    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return (T)this.instantiatorFactory.inject(this.delegate).newInstance(type, parameters);
    }

    public Instantiator capturing(final ImplicitInputRecorder registrar) {
        return new Instantiator(){

            public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
                return (T)ImplicitInputsCapturingInstantiator.this.instantiatorFactory.inject(ImplicitInputsCapturingInstantiator.this.capturingRegistry(registrar)).newInstance(type, parameters);
            }
        };
    }

    public <IN, OUT, SERVICE> @Nullable ImplicitInputsProvidingService<IN, OUT, SERVICE> findInputCapturingServiceByName(String name) {
        try {
            return (ImplicitInputsProvidingService)Cast.uncheckedCast((Object)this.delegate.find(Class.forName(name)));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public ServiceLookup capturingRegistry(ImplicitInputRecorder registrar) {
        return new DefaultCapturingServiceLookup(registrar);
    }

    private class DefaultCapturingServiceLookup
    implements ServiceLookup {
        private final ImplicitInputRecorder registrar;

        private DefaultCapturingServiceLookup(ImplicitInputRecorder registrar) {
            this.registrar = registrar;
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.delegate.get(serviceType);
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return ImplicitInputsCapturingInstantiator.this.delegate.get(serviceType, annotatedWith);
        }

        public Object find(Type serviceType) throws ServiceLookupException {
            Object service = ImplicitInputsCapturingInstantiator.this.delegate.find(serviceType);
            if (service instanceof ImplicitInputsProvidingService) {
                return ((ImplicitInputsProvidingService)service).withImplicitInputRecorder(this.registrar);
            }
            return service;
        }
    }
}

