/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.api.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001 B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/buildtools/api/internal/KotlinCompilerVersion;", "", "Ljava/io/Serializable;", "major", "", "minor", "patch", "classifier", "", "(IIILjava/lang/String;)V", "buildNumber", "getBuildNumber", "()Ljava/lang/Integer;", "getClassifier", "()Ljava/lang/String;", "classifierNumber", "getClassifierNumber", "getMajor", "()I", "maturity", "Lorg/jetbrains/kotlin/buildtools/api/internal/KotlinCompilerVersion$Maturity;", "getMaturity", "()Lorg/jetbrains/kotlin/buildtools/api/internal/KotlinCompilerVersion$Maturity;", "getMinor", "getPatch", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Maturity", "kotlin-build-tools-api"})
@SourceDebugExtension(value={"SMAP\nKotlinCompilerVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCompilerVersion.kt\norg/jetbrains/kotlin/buildtools/api/internal/KotlinCompilerVersion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class KotlinCompilerVersion
implements Serializable,
Comparable<KotlinCompilerVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String classifier;
    @NotNull
    private final Maturity maturity;

    /*
     * WARNING - void declaration
     */
    public KotlinCompilerVersion(int major, int minor, int patch, @Nullable String classifier) {
        CharSequence charSequence;
        String string;
        void $this$maturity_u24lambda_u240;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.classifier = classifier;
        KotlinCompilerVersion kotlinCompilerVersion = this;
        KotlinCompilerVersion kotlinCompilerVersion2 = this;
        boolean bl = false;
        String string2 = $this$maturity_u24lambda_u240.classifier;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String classifier2 = string;
        kotlinCompilerVersion2.maturity = classifier2 == null || new Regex("(release-)?\\d+").matches(charSequence = (CharSequence)classifier2) ? Maturity.STABLE : (Intrinsics.areEqual((Object)classifier2, (Object)"snapshot") ? Maturity.SNAPSHOT : (new Regex("(rc)(\\d*)?(-release)?(-?\\d+)?").matches(charSequence = (CharSequence)classifier2) ? Maturity.RC : (new Regex("beta(\\d*)?(-release)?(-?\\d+)?").matches(charSequence = (CharSequence)classifier2) ? Maturity.BETA : (new Regex("alpha(\\d*)?(-release)?(-?\\d+)?").matches(charSequence = (CharSequence)classifier2) ? Maturity.ALPHA : (new Regex("m\\d+(-release)?(-\\d+)?").matches(charSequence = (CharSequence)classifier2) ? Maturity.MILESTONE : Maturity.DEV)))));
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getClassifier() {
        return this.classifier;
    }

    @NotNull
    public final Maturity getMaturity() {
        return this.maturity;
    }

    @Override
    public int compareTo(@NotNull KotlinCompilerVersion other) {
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)other)) {
            return 0;
        }
        Integer n3 = this.major - other.major;
        int it = ((Number)n3).intValue();
        boolean bl = false;
        Integer n4 = n2 = it != 0 ? n3 : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            return it;
        }
        n3 = this.minor - other.minor;
        it = ((Number)n3).intValue();
        boolean bl3 = false;
        Integer n5 = n2 = it != 0 ? n3 : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl4 = false;
            return it;
        }
        n3 = this.patch - other.patch;
        it = ((Number)n3).intValue();
        boolean bl5 = false;
        Integer n6 = n2 = it != 0 ? n3 : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl6 = false;
            return it;
        }
        n3 = this.maturity.ordinal() - other.maturity.ordinal();
        it = ((Number)n3).intValue();
        boolean bl7 = false;
        Integer n7 = n2 = it != 0 ? n3 : null;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl8 = false;
            return it;
        }
        if (this.classifier == null && other.classifier != null) {
            return 1;
        }
        if (this.classifier != null && other.classifier == null) {
            return -1;
        }
        Integer thisClassifierNumber = this.getClassifierNumber();
        Integer otherClassifierNumber = other.getClassifierNumber();
        if (thisClassifierNumber != null && otherClassifierNumber != null) {
            Integer bl8 = thisClassifierNumber - otherClassifierNumber;
            int it2 = ((Number)bl8).intValue();
            boolean bl9 = false;
            Integer n8 = it = it2 != 0 ? bl8 : null;
            if (it != null) {
                it2 = ((Number)it).intValue();
                boolean bl10 = false;
                return it2;
            }
        }
        if (thisClassifierNumber != null && otherClassifierNumber == null) {
            return 1;
        }
        if (thisClassifierNumber == null && otherClassifierNumber != null) {
            return -1;
        }
        Integer thisBuildNumber = this.getBuildNumber();
        Integer otherBuildNumber = other.getBuildNumber();
        if (thisBuildNumber != null && otherBuildNumber != null) {
            Integer n9;
            Integer n10 = thisBuildNumber - otherBuildNumber;
            int it3 = ((Number)n10).intValue();
            boolean bl11 = false;
            Integer n11 = n9 = it3 != 0 ? n10 : null;
            if (n9 != null) {
                it3 = ((Number)n9).intValue();
                boolean bl12 = false;
                return it3;
            }
        }
        if (thisBuildNumber == null && otherBuildNumber != null) {
            return 1;
        }
        if (thisBuildNumber != null && otherBuildNumber == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        String string;
        String string2;
        if (this == other) {
            return true;
        }
        if (!(other instanceof KotlinCompilerVersion)) {
            return false;
        }
        if (this.major != ((KotlinCompilerVersion)other).major) {
            return false;
        }
        if (this.minor != ((KotlinCompilerVersion)other).minor) {
            return false;
        }
        if (this.patch != ((KotlinCompilerVersion)other).patch) {
            return false;
        }
        String string3 = this.classifier;
        if (string3 != null) {
            String string4 = string3.toLowerCase(Locale.ROOT);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String string5 = ((KotlinCompilerVersion)other).classifier;
        if (string5 != null) {
            String string6 = string5.toLowerCase(Locale.ROOT);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return Intrinsics.areEqual((Object)string2, (Object)string);
    }

    public int hashCode() {
        int result2 = this.major;
        result2 = 31 * result2 + this.minor;
        result2 = 31 * result2 + this.patch;
        String string = this.classifier;
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch + (this.classifier != null ? '-' + this.classifier : "");
    }

    private final Integer getClassifierNumber() {
        if (this.classifier == null) {
            return null;
        }
        if (this.maturity == Maturity.DEV) {
            return null;
        }
        Regex buildNumberOnlyClassifierRegex = new Regex("\\d+");
        if (buildNumberOnlyClassifierRegex.matches((CharSequence)this.classifier)) {
            return null;
        }
        Regex classifierRegex = new Regex("(.+?)(\\d*)?(-release)?-?(\\d*)?");
        MatchResult matchResult = classifierRegex.matchEntire((CharSequence)this.classifier);
        if (matchResult == null) {
            return null;
        }
        MatchResult classifierMatch = matchResult;
        String string = (String)CollectionsKt.getOrNull((List)classifierMatch.getGroupValues(), (int)2);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    private final Integer getBuildNumber() {
        if (this.classifier == null) {
            return null;
        }
        Regex buildNumberOnlyClassifierRegex = new Regex("\\d+");
        if (buildNumberOnlyClassifierRegex.matches((CharSequence)this.classifier)) {
            return StringsKt.toIntOrNull((String)this.classifier);
        }
        Regex classifierRegex = new Regex("(.+?)(\\d*)?(-release)?-?(\\d*)?");
        MatchResult matchResult = classifierRegex.matchEntire((CharSequence)this.classifier);
        if (matchResult == null) {
            return null;
        }
        MatchResult classifierMatch = matchResult;
        String string = (String)CollectionsKt.getOrNull((List)classifierMatch.getGroupValues(), (int)4);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/buildtools/api/internal/KotlinCompilerVersion$Maturity;", "", "(Ljava/lang/String;I)V", "SNAPSHOT", "DEV", "MILESTONE", "ALPHA", "BETA", "RC", "STABLE", "kotlin-build-tools-api"})
    public static final class Maturity
    extends Enum<Maturity> {
        public static final /* enum */ Maturity SNAPSHOT = new Maturity();
        public static final /* enum */ Maturity DEV = new Maturity();
        public static final /* enum */ Maturity MILESTONE = new Maturity();
        public static final /* enum */ Maturity ALPHA = new Maturity();
        public static final /* enum */ Maturity BETA = new Maturity();
        public static final /* enum */ Maturity RC = new Maturity();
        public static final /* enum */ Maturity STABLE = new Maturity();
        private static final /* synthetic */ Maturity[] $VALUES;

        public static Maturity[] values() {
            return (Maturity[])$VALUES.clone();
        }

        public static Maturity valueOf(String value2) {
            return Enum.valueOf(Maturity.class, value2);
        }

        static {
            $VALUES = maturityArray = new Maturity[]{Maturity.SNAPSHOT, Maturity.DEV, Maturity.MILESTONE, Maturity.ALPHA, Maturity.BETA, Maturity.RC, Maturity.STABLE};
        }
    }
}

