/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.integtests.fixtures.logging

import groovy.transform.CompileStatic
import org.gradle.exemplar.executor.ExecutionMetadata
import org.gradle.exemplar.test.normalizer.OutputNormalizer

/**
 * This is a workaround for https://github.com/gradle/gradle-private/issues/4932
 *
 * If the output includes both "> Task :compileJava" and "> Task :compileJava FAILED",
 * remove the former from the output.
 */
@CompileStatic
class DuplicateTaskNameRemovalOutputNormalizer implements OutputNormalizer {
    @Override
    String normalize(String output, ExecutionMetadata executionMetadata) {
        if (executionMetadata.tempSampleProjectDir.name.contains("disabled_groovy_buildJavaModule")) {
            List<String> lines = output.readLines()
            if (lines.any { it.trim() == "> Task :compileJava" } && lines.any { it.trim() == "> Task :compileJava FAILED" }) {
                lines.removeIf { it.trim() == "> Task :compileJava" }
                return lines.join(System.lineSeparator())
            }
        }
        return output
    }
}
