<meta property="og:image" content="https://gradle.org/images/releases/gradle-default.png" />
<meta property="og:type"  content="article" />
<meta property="og:title" content="Gradle @version@ Release Notes" />
<meta property="og:site_name" content="Gradle Release Notes">
<meta property="og:description" content="We are excited to announce Gradle @version@.">
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:site" content="@gradle">
<meta name="twitter:creator" content="@gradle">
<meta name="twitter:title" content="Gradle @version@ Release Notes">
<meta name="twitter:description" content="We are excited to announce Gradle @version@.">
<meta name="twitter:image" content="https://gradle.org/images/releases/gradle-default.png">

We are excited to announce Gradle @version@ (released [@releaseDate@](https://gradle.org/releases/)).

This release features [1](), [2](), ... [n](), and more.

<!-- 
Include only their name, impactful features should be called out separately below.
 [Some person](https://github.com/some-person)

 THIS LIST SHOULD BE ALPHABETIZED BY [PERSON NAME] - the docs:updateContributorsInReleaseNotes task will enforce this ordering, which is case-insensitive.
-->

We would like to thank the following community members for their contributions to this release of Gradle:

Be sure to check out the [public roadmap](https://roadmap.gradle.org) for insight into what's planned for future releases.

## Upgrade instructions

Switch your build to use Gradle @version@ by updating the [wrapper](userguide/gradle_wrapper.html) in your project:

```text
./gradlew wrapper --gradle-version=@version@ && ./gradlew wrapper
```

See the [Gradle 9.x upgrade guide](userguide/upgrading_version_9.html#changes_@baseVersion@) to learn about deprecations, breaking changes, and other considerations when upgrading to Gradle @version@.

For Java, Groovy, Kotlin, and Android compatibility, see the [full compatibility notes](userguide/compatibility.html).   

## New features and usability improvements

<!-- Do not add breaking changes or deprecations here! Add them to the upgrade guide instead. -->

<!--

================== TEMPLATE ==============================

### FILL-IN-KEY-AREA improvements

<<<FILL IN CONTEXT FOR KEY AREA>>>
Example:
> The [configuration cache](userguide/configuration_cache.html) improves build performance by caching the result of
> the configuration phase. Using the configuration cache, Gradle can skip the configuration phase entirely when
> nothing that affects the build configuration has changed.

#### FILL-IN-FEATURE
> HIGHLIGHT the use case or existing problem the feature solves
> EXPLAIN how the new release addresses that problem or use case
> PROVIDE a screenshot or snippet illustrating the new feature, if applicable
> LINK to the full documentation for more details

To embed videos, use the macros below. 
You can extract the URL from YouTube by clicking the "Share" button. 
For Wistia, contact Gradle's Video Team.
@youtube(Summary,6aRM8lAYyUA?si=qeXDSX8_8hpVmH01)@
@wistia(Summary,a5izazvgit)@

================== END TEMPLATE ==========================


==========================================================
ADD RELEASE FEATURES BELOW
vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv -->

### Testing refactoring
The HTML report generated by the `test` task, `TestReport`, and other `AbstractTestTask` users now provides a more detailed view of the test results.
This is due to a refactoring of the testing infrastructure to use the incubating `TestEventReporter` API internally.
Additionally, the binary output has been adjusted to support non-class-based testing frameworks better.

In the following sections:
- "Suite" refers to specifically the suite features of JUnit 4, JUnit Jupiter, and TestNG.
- "Container" refers to a general grouping of tests, such as a class.

#### Nested test changes
For JUnit 4 and JUnit Jupiter, nested test classes are now shown nested under their enclosing class in the HTML report.
For example, if you had an `OuterClass` with an `InnerClass` nested inside it, it would previously be shown as:
```text
+ OuterClass$InnerClass
|-- someTestMethodInInnerClass
```
It will now be reported in the HTML report as:
```text
+ OuterClass
|-+ InnerClass (or OuterClass$InnerClass for JUnit 4)
  |-- someTestMethodInInnerClass
```
With multiple inner classes:
```text
+ OuterClass
|-+ InnerClass1 (or OuterClass$InnerClass1 for JUnit 4)
  |-- someTestMethodInInnerClass1
  + InnerClass2 (or OuterClass$InnerClass2 for JUnit 4)
  |-- someTestMethodInInnerClass2
```
The XML report remains the same, nested classes are still written as `TEST-OuterClass$InnerClass.xml`.

#### Parameterized test changes
Parameterized tests now create a suite that contains all the parameterized test cases for a given method.
For example, if you had a class `TestClass` with two parameterized `paramTest1/2` methods, it would previously be shown as:
```text
+ TestClass
|-- paramTest1[0]
|-- paramTest1[1]
|-- paramTest1[2]
|-- paramTest2[a]
|-- paramTest2[b]
|-- paramTest2[c]
```
It will now be reported in the HTML report as:
```text
+ TestClass
|-+ paramTest1
  |-- paramTest1[0]
  |-- paramTest1[1]
  |-- paramTest1[2]
|-+ paramTest2
  |-- paramTest2[a]
  |-- paramTest2[b]
  |-- paramTest2[c]
```

#### Suite changes
Suites now contain the classes they run, rather than those classes being shown as siblings.
For example, if you had a suite `AllTests` that ran `TestClass1` and `TestClass2`, it would previously be shown as:
```text
+ AllTests
+ TestClass1
|-- someTestMethodInClass1
+ TestClass2
|-- someTestMethodInClass2
```
It will now be reported in the HTML report as:
```text
+ AllTests
|-+ TestClass1
  |-- someTestMethodInClass1
|-+ TestClass2
  |-- someTestMethodInClass2
```
In the XML report, only the class report is emitted (`TEST-SomeTestClass.xml`).

#### Package suite changes
Packages are no longer represented as containers in the report.
There are two main reasons:
- With support for non-class-based testing, Gradle cannot reliably determine if a container corresponds to a class, so synthesizing a package container can be misleading.
- This behavior now aligns more closely with how testing frameworks and IDEs group tests.

#### Test standard output / error changes
Standard output and standard error (collectively, "output") is no longer combined from individual tests to the container/class level.
This makes it easier to locate output that is relevant to a specific test.
Before and after class output is now associated with the correct class in JUnit 4, JUnit Jupiter, and TestNG (starting with TestNG 6.9.13.3).
Before and after suite or container output is now associated with the correct suite or container for JUnit 4 (starting with JUnit 4.13), JUnit Jupiter, and TestNG (starting with TestNG 6.19.13.3).

#### Aggregate report changes
The aggregate report generated by the [Test Report Aggregation Plugin](userguide/test_report_aggregation_plugin.html) or manually with `TestReport` now supports overlapping test structures,
for example when there is a suite with the same name in multiple subprojects.
Each individual report source is represented as a "root".
You can switch between roots in the aggregate HTML report:
![new-aggregate-report.png](release-notes-assets/new-aggregate-report.png)

As a result, not all children are listed on the first tab anymore.
To see the tests from a specific source, select its corresponding root tab.

### Build authoring improvements

#### New `AttributeContainer.named()` method

This release introduces a new convenience method on `AttributeContainer`, [`named()`](javadoc/org/gradle/api/attributes/AttributeContainer.html#named(java.lang.Class,java.lang.String)), which can create attribute values directly from the container without requiring a separate `ObjectFactory` instance.

This method makes attribute assignment more concise while preserving the same semantics as creating a named value via `ObjectFactory`:

```kotlin
configurations.resolvable("foo") {
    attributes {
        // Before: 
        attribute(Usage.USAGE_ATTRIBUTE, objects.named("red"))
        
        // After:
        attribute(Usage.USAGE_ATTRIBUTE, named("red"))
    }
}
```

### Stream TestKit output

Gradle TestKit's `BuildResult` now offers a new method for accessing the build console output efficiently, especially for builds that produce a large volume of logs.

[`BuildResult.getOutput()`](javadoc/org/gradle/testkit/runner/BuildResult.html#getOutput())
returns a `String` with the full build console output.
This can use large amounts of memory for builds with extensive logs.

A new 
[`BuildResult.getOutputReader()`](javadoc/org/gradle/testkit/runner/BuildResult.html#getOutput())
method is available, returning a `BufferedReader` for streaming the build output incrementally.
This can help reduce memory pressure in TestKit tests.

Please ensure you close the `BufferedReader` after use; we recommend the standard Java try-with-resources pattern for this:

```java
void testProject() {
    BuildResult buildResult = GradleRunner.create()
        .withProjectDir(File("test-project"))
        .withArguments(":build", "--info")
        .build();

    try (BufferedReader outputReader = buildResult.getOutputReader()) {
        List<String> logLines = outputReader.lines()
            .filter(line -> line.contains("example build message"))
            .collect(Collectors.toList());
        // do something with the log lines...
    }
}
```

### Simple console rendering for Problem Reports
The [Problems API](userguide/reporting_problems.html) provides structured feedback on build issues, helping developers and tools like IDEs identify and resolve warnings, errors, or deprecations during configuration or runtime.

Previously, a limitation was that problem reports were not displayed in the console output.
In this release, we've taken a first step toward full console integration.
All problem reports are now rendered in the console output when you configure `--warning-mode=all`.


<!-- ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
ADD RELEASE FEATURES ABOVE
==========================================================

-->

## Promoted features

Promoted features are features that were incubating in previous versions of Gradle but are now supported and subject to backward compatibility.
See the User Manual section on the "[Feature Lifecycle](userguide/feature_lifecycle.html)" for more information.

The following are the features that have been promoted in this Gradle release.

* [`useFileSystemPermissions()`](javadoc/org/gradle/api/tasks/bundling/AbstractArchiveTask.html#useFileSystemPermissions()) in `AbstractArchiveTask`

<!--
### Example promoted
-->

## Fixed issues

<!--
This section will be populated automatically
-->

## Known issues

Known issues are problems that were discovered post-release that are directly related to changes made in this release.

<!--
This section will be populated automatically
-->

## External contributions

We love getting contributions from the Gradle community. For information on contributing, please see [gradle.org/contribute](https://gradle.org/contribute).

## Reporting problems

If you find a problem with this release, please file a bug on [GitHub Issues](https://github.com/gradle/gradle/issues) adhering to our issue guidelines.
If you're not sure if you're encountering a bug, please use the [forum](https://discuss.gradle.org/c/help-discuss).

We hope you will build happiness with Gradle, and we look forward to your feedback via [Twitter](https://twitter.com/gradle) or on [GitHub](https://github.com/gradle).
