/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.compression;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.gradle.api.internal.file.archive.compression.AbstractArchiver;
import org.gradle.api.internal.file.archive.compression.ArchiveOutputStreamFactory;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.IoActions;
import org.gradle.internal.resource.ResourceExceptions;

public class Bzip2Archiver
extends AbstractArchiver {
    public Bzip2Archiver(ReadableResourceInternal resource) {
        super(resource);
    }

    @Override
    protected String getSchemePrefix() {
        return "bzip2:";
    }

    public static ArchiveOutputStreamFactory getCompressor() {
        return destination -> {
            BufferedOutputStream outStr = new BufferedOutputStream(new FileOutputStream(destination));
            try {
                ((OutputStream)outStr).write(66);
                ((OutputStream)outStr).write(90);
                return new CBZip2OutputStream((OutputStream)outStr);
            }
            catch (Exception e) {
                IoActions.closeQuietly((Closeable)outStr);
                String message = String.format("Unable to create bzip2 output stream for file %s", destination);
                throw new RuntimeException(message, e);
            }
        };
    }

    @Override
    public InputStream read() {
        BufferedInputStream input = new BufferedInputStream(this.resource.read());
        try {
            byte[] skip = new byte[2];
            ((InputStream)input).read(skip);
            return new CBZip2InputStream((InputStream)input);
        }
        catch (Exception e) {
            IoActions.closeQuietly((Closeable)input);
            throw ResourceExceptions.readFailed((String)this.resource.getDisplayName(), (Throwable)e);
        }
    }
}

