/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.stream.Streams;
import org.gradle.api.internal.tasks.testing.report.generic.GenericPageRenderer;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.PerRootInfo;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.internal.tasks.testing.results.serializable.TestOutputReader;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.Pair;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.internal.io.IoConsumer;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.reporting.HtmlWriterTools;
import org.gradle.reporting.ReportRenderer;
import org.gradle.reporting.TabsRenderer;
import org.jspecify.annotations.Nullable;

public abstract class PerRootTabRenderer
extends ReportRenderer<TestTreeModel, SimpleHtmlWriter> {
    protected final int rootIndex;
    private final int perRootInfoIndex;
    private @Nullable TestTreeModel currentModel;

    public PerRootTabRenderer(int rootIndex, int perRootInfoIndex) {
        this.rootIndex = rootIndex;
        this.perRootInfoIndex = perRootInfoIndex;
    }

    public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
        this.currentModel = model;
        PerRootInfo info = model.getPerRootInfo().get(this.rootIndex).get(this.perRootInfoIndex);
        this.render(info, htmlWriter);
    }

    protected final TestTreeModel getCurrentModel() {
        if (this.currentModel == null) {
            throw new IllegalStateException("No model set");
        }
        return this.currentModel;
    }

    protected abstract void render(PerRootInfo var1, SimpleHtmlWriter var2) throws IOException;

    public static final class ForMetadata
    extends PerRootTabRenderer {
        private final MetadataRendererRegistry metadataRendererRegistry;

        public ForMetadata(int rootIndex, int perRootInfoIndex, MetadataRendererRegistry metadataRendererRegistry) {
            super(rootIndex, perRootInfoIndex);
            this.metadataRendererRegistry = metadataRendererRegistry;
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "metadata");
            this.renderMetadataTable(info, htmlWriter);
            htmlWriter.endElement();
        }

        private void renderMetadataTable(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("table");
            this.renderMetadataTableHeader(htmlWriter);
            this.renderMetadataTableBody(info.getMetadatas(), htmlWriter);
            htmlWriter.endElement();
        }

        private SimpleHtmlWriter renderMetadataTableHeader(SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("thead").startElement("tr").startElement("th").characters((CharSequence)"Time").endElement().startElement("th").characters((CharSequence)"Key(s)").endElement().startElement("th").characters((CharSequence)"Value(s)").endElement().endElement().endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataTableBody(Iterable<SerializedMetadata> metadatas, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tbody");
            Iterator<SerializedMetadata> metadataIterator = metadatas.iterator();
            int metadataIdx = 0;
            while (metadataIterator.hasNext()) {
                SerializedMetadata metadata = metadataIterator.next();
                this.renderFirstMetadataElement(metadata, metadataIdx, htmlWriter);
                if (metadata.getEntries().size() > 1) {
                    ImmutableList additionalEntries = metadata.getEntries().subList(1, metadata.getEntries().size());
                    this.renderAdditionalMetadataElements((List<SerializedMetadata.SerializedMetadataElement>)additionalEntries, metadataIdx, htmlWriter);
                }
                ++metadataIdx;
            }
            htmlWriter.endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderFirstMetadataElement(SerializedMetadata metadata, int metadataIdx, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 0 ? "even" : "odd");
            this.renderMetadataTimeCell(metadata, htmlWriter);
            this.renderMetadataKeyValueCells((SerializedMetadata.SerializedMetadataElement)metadata.getEntries().get(0), htmlWriter).endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderAdditionalMetadataElements(List<SerializedMetadata.SerializedMetadataElement> elements, int metadataIdx, SimpleHtmlWriter htmlWriter) throws IOException {
            for (SerializedMetadata.SerializedMetadataElement element : elements) {
                htmlWriter.startElement("tr").attribute("class", metadataIdx % 2 == 1 ? "even" : "odd");
                this.renderMetadataKeyValueCells(element, htmlWriter);
                htmlWriter.endElement();
            }
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataTimeCell(SerializedMetadata metadata, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("td").attribute("rowspan", Integer.toString(metadata.getEntries().size())).startElement("span").attribute("class", "time").characters((CharSequence)this.formatLogTime(metadata.getLogTime())).endElement().endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataKeyValueCells(SerializedMetadata.SerializedMetadataElement element, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("td").attribute("class", "key").characters((CharSequence)element.getKey()).endElement().startElement("td").attribute("class", "value");
            this.renderMetadataValue(element, htmlWriter).endElement();
            return htmlWriter;
        }

        private SimpleHtmlWriter renderMetadataValue(SerializedMetadata.SerializedMetadataElement element, SimpleHtmlWriter htmlWriter) throws IOException {
            MetadataRendererRegistry.MetadataRenderer renderer = this.metadataRendererRegistry.getRenderer(element.getValueType());
            try {
                return renderer.render(element.getValue(), htmlWriter);
            }
            catch (Exception e) {
                return (SimpleHtmlWriter)htmlWriter.startElement("span").attribute("class", "unrenderable").characters((CharSequence)"[error rendering value]").endElement();
            }
        }

        private String formatLogTime(long logTime) {
            Instant instant = Instant.ofEpochMilli(logTime);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS z").withZone(ZoneId.systemDefault());
            return formatter.format(instant);
        }
    }

    public static final class ForOutput
    extends PerRootTabRenderer {
        private final TestOutputReader outputReader;
        private final TestOutputEvent.Destination destination;

        public ForOutput(int rootIndex, int perRootInfoIndex, TestOutputReader outputReader, TestOutputEvent.Destination destination) {
            super(rootIndex, perRootInfoIndex);
            this.outputReader = outputReader;
            this.destination = destination;
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            String outputId = "root-" + this.rootIndex + "-test-" + this.destination.name().toLowerCase(Locale.ROOT) + "-" + info.getResults().get(0).getName();
            htmlWriter.startElement("span").attribute("class", "code").startElement("pre").attribute("id", outputId);
            this.outputReader.useTestOutputEvents(info.getOutputEntries(), this.destination, (IoConsumer<TestOutputEvent>)((IoConsumer)event -> htmlWriter.characters((CharSequence)event.getMessage())));
            htmlWriter.endElement();
            HtmlWriterTools.addClipboardCopyButton((SimpleHtmlWriter)htmlWriter, (String)outputId);
            htmlWriter.endElement();
        }
    }

    public static final class ForSummary
    extends PerRootTabRenderer {
        public ForSummary(int rootIndex, int perRootInfoIndex) {
            super(rootIndex, perRootInfoIndex);
        }

        @Override
        protected void render(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div");
            ForSummary.renderSummary(info, htmlWriter);
            if (info.getChildren().isEmpty()) {
                this.renderLeafDetails(info, htmlWriter);
            } else {
                this.renderContainerDetails(htmlWriter);
            }
            htmlWriter.endElement();
        }

        private void renderContainerDetails(SimpleHtmlWriter htmlWriter) throws IOException {
            ReportRenderer renderer;
            List<Pair<String, ChildTableRenderer>> childTableRenderers = this.getChildTableRenderers();
            if (childTableRenderers.size() == 1) {
                renderer = Objects.requireNonNull((ChildTableRenderer)((Object)childTableRenderers.get((int)0).right));
            } else {
                TabsRenderer tabsRenderer = new TabsRenderer();
                childTableRenderers.forEach(p -> tabsRenderer.add((String)p.left, (ReportRenderer)p.right));
                renderer = tabsRenderer;
            }
            renderer.render((Object)this.getCurrentModel(), (Object)htmlWriter);
        }

        private List<Pair<String, ChildTableRenderer>> getChildTableRenderers() {
            List<ChildEntry> children = Streams.of(this.getCurrentModel().getChildrenOf(this.rootIndex)).flatMap(t -> t.getPerRootInfo().get(this.rootIndex).stream().map(p -> new ChildEntry((TestTreeModel)t, (PerRootInfo)p))).collect(Collectors.toList());
            ImmutableList.Builder childTableRenderers = ImmutableList.builder();
            ForSummary.addResultTabIfNeeded("Failed", TestResult.ResultType.FAILURE, children, (ImmutableList.Builder<Pair<String, ChildTableRenderer>>)childTableRenderers);
            ForSummary.addResultTabIfNeeded("Skipped", TestResult.ResultType.SKIPPED, children, (ImmutableList.Builder<Pair<String, ChildTableRenderer>>)childTableRenderers);
            childTableRenderers.add((Object)Pair.of((Object)"All", (Object)((Object)new ChildTableRenderer(children))));
            return childTableRenderers.build();
        }

        private static void addResultTabIfNeeded(String name, TestResult.ResultType resultType, List<ChildEntry> children, ImmutableList.Builder<Pair<String, ChildTableRenderer>> childListRenderers) {
            List<ChildEntry> matchedChildren = children.stream().filter(e -> ((ChildEntry)e).perRootInfo.getResults().stream().anyMatch(it -> it.getResultType() == resultType)).collect(Collectors.toList());
            if (!matchedChildren.isEmpty()) {
                childListRenderers.add((Object)Pair.of((Object)name, (Object)((Object)new ChildTableRenderer(matchedChildren))));
            }
        }

        private static void renderSummary(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summary");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            ForSummary.renderSummaryGroup(info, htmlWriter);
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox " + ForSummary.getStatusClass(ForSummary.getResultType(info)) + " successRate");
            htmlWriter.startElement("div").attribute("class", "percent").characters((CharSequence)ForSummary.getFormattedSuccessRate(info)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"successful").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static void renderSummaryGroup(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            htmlWriter.startElement("div").attribute("class", "summaryGroup");
            htmlWriter.startElement("table");
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getTotalLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"tests").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getFailedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"failures").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)Integer.toString(info.getSkippedLeafCount())).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"skipped").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td");
            htmlWriter.startElement("div").attribute("class", "infoBox duration");
            htmlWriter.startElement("div").attribute("class", "counter").characters((CharSequence)ForSummary.getFormattedDuration(info)).endElement();
            htmlWriter.startElement("p").characters((CharSequence)"duration").endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
            htmlWriter.endElement();
        }

        private static String getFormattedDuration(PerRootInfo info) {
            return info.getResults().stream().map(r -> TimeFormatting.formatDurationVeryTerse((long)r.getDuration())).collect(Collectors.joining(" / "));
        }

        private void renderLeafDetails(PerRootInfo info, SimpleHtmlWriter htmlWriter) throws IOException {
            boolean hasAssumptionFailure;
            if (info.getResults().size() > 1) {
                throw new IllegalStateException("Leaf nodes should only have one result");
            }
            SerializableTestResult result = info.getResults().get(0);
            boolean isSuccess = result.getResultType() == TestResult.ResultType.SUCCESS;
            boolean hasFailures = !result.getFailures().isEmpty();
            boolean bl = hasAssumptionFailure = result.getAssumptionFailure() != null;
            if (!isSuccess && (hasFailures || hasAssumptionFailure)) {
                htmlWriter.startElement("div").attribute("class", "result-details");
                htmlWriter.startElement("h3").characters((CharSequence)(result.getResultType() == TestResult.ResultType.FAILURE ? "Failure details" : "Skip details")).endElement();
                String failureOutputId = "root-" + this.rootIndex + "-test-failure-" + result.getName();
                htmlWriter.startElement("span").attribute("class", "code");
                htmlWriter.startElement("pre").attribute("id", failureOutputId);
                if (hasFailures) {
                    for (SerializableFailure failure : result.getFailures()) {
                        this.renderFailure(failure, htmlWriter);
                    }
                }
                if (hasAssumptionFailure) {
                    this.renderFailure(result.getAssumptionFailure(), htmlWriter);
                }
                htmlWriter.endElement();
                HtmlWriterTools.addClipboardCopyButton((SimpleHtmlWriter)htmlWriter, (String)failureOutputId);
                htmlWriter.endElement();
                htmlWriter.endElement();
            }
        }

        private void renderFailure(SerializableFailure failure, SimpleHtmlWriter htmlWriter) throws IOException {
            if (failure.getStackTrace().isEmpty()) {
                htmlWriter.characters((CharSequence)(failure.getMessage() + "\n"));
            } else {
                htmlWriter.characters((CharSequence)failure.getStackTrace());
            }
            for (int i = 0; i < failure.getCauses().size(); ++i) {
                htmlWriter.characters((CharSequence)("Cause " + (i + 1) + ": " + failure.getCauses().get(i) + "\n"));
            }
        }

        private static TestResult.ResultType getResultType(PerRootInfo info) {
            if (info.getChildren().isEmpty()) {
                if (info.getResults().size() > 1) {
                    throw new IllegalStateException("Leaf nodes should only have one result");
                }
                return info.getResults().get(0).getResultType();
            }
            TestResult.ResultType bestType = TestResult.ResultType.SKIPPED;
            for (SerializableTestResult result : info.getResults()) {
                if (result.getResultType() == TestResult.ResultType.FAILURE) {
                    bestType = TestResult.ResultType.FAILURE;
                    break;
                }
                if (result.getResultType() == TestResult.ResultType.SUCCESS) {
                    bestType = TestResult.ResultType.SUCCESS;
                    continue;
                }
                if (result.getResultType() == TestResult.ResultType.SKIPPED) continue;
                throw new IllegalStateException("Unknown result type: " + result.getResultType());
            }
            return bestType;
        }

        private static String getStatusClass(TestResult.ResultType resultType) {
            switch (resultType) {
                case SUCCESS: {
                    return "success";
                }
                case FAILURE: {
                    return "failures";
                }
                case SKIPPED: {
                    return "skipped";
                }
            }
            throw new IllegalStateException();
        }

        private static String getFormattedSuccessRate(PerRootInfo info) {
            if (info.getTotalLeafCount() == 0) {
                return "-";
            }
            BigDecimal runTests = BigDecimal.valueOf(info.getTotalLeafCount());
            BigDecimal successful = BigDecimal.valueOf(info.getTotalLeafCount() - info.getFailedLeafCount());
            return successful.divide(runTests, 2, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L)).intValue() + "%";
        }

        private static final class ChildTableRenderer
        extends ReportRenderer<TestTreeModel, SimpleHtmlWriter> {
            private static final Comparator<ChildEntry> CHILD_PATH_COMPARATOR = Comparator.comparing(e -> ((ChildEntry)e).model.getPath());
            private final List<ChildEntry> children;

            public ChildTableRenderer(List<ChildEntry> children) {
                this.children = children;
            }

            public void render(TestTreeModel model, SimpleHtmlWriter htmlWriter) throws IOException {
                htmlWriter.startElement("table").attribute("class", "test-results");
                htmlWriter.startElement("thead");
                htmlWriter.startElement("tr");
                boolean anyNameAndDisplayNameDiffer = Iterables.any(this.children, child -> {
                    List<SerializableTestResult> results = ((ChildEntry)child).perRootInfo.getResults();
                    return !results.get(0).getName().equals(results.get(0).getDisplayName());
                });
                htmlWriter.startElement("th").characters((CharSequence)"Child").endElement();
                if (anyNameAndDisplayNameDiffer) {
                    htmlWriter.startElement("th").characters((CharSequence)"Name").endElement();
                }
                htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Skipped").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
                htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
                htmlWriter.endElement();
                htmlWriter.endElement();
                ArrayList<ChildEntry> sortedByName = new ArrayList<ChildEntry>(this.children);
                sortedByName.sort(CHILD_PATH_COMPARATOR);
                for (ChildEntry pair : sortedByName) {
                    PerRootInfo perRootInfo = pair.perRootInfo;
                    String statusClass = ForSummary.getStatusClass(ForSummary.getResultType(perRootInfo));
                    htmlWriter.startElement("tr");
                    htmlWriter.startElement("td").attribute("class", statusClass);
                    String displayName = SerializableTestResult.getCombinedDisplayName(perRootInfo.getResults());
                    htmlWriter.startElement("a").attribute("href", GenericPageRenderer.getUrlTo(model.getPath(), false, pair.model.getPath(), pair.model.getChildren().isEmpty())).characters((CharSequence)displayName).endElement();
                    htmlWriter.endElement();
                    if (anyNameAndDisplayNameDiffer) {
                        htmlWriter.startElement("td").characters((CharSequence)perRootInfo.getResults().get(0).getName()).endElement();
                    }
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getTotalLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getFailedLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)Integer.toString(perRootInfo.getSkippedLeafCount())).endElement();
                    htmlWriter.startElement("td").characters((CharSequence)ForSummary.getFormattedDuration(perRootInfo)).endElement();
                    htmlWriter.startElement("td").attribute("class", statusClass).characters((CharSequence)ForSummary.getFormattedSuccessRate(perRootInfo)).endElement();
                    htmlWriter.endElement();
                }
                htmlWriter.endElement();
            }
        }

        private static final class ChildEntry {
            private final TestTreeModel model;
            private final PerRootInfo perRootInfo;

            private ChildEntry(TestTreeModel model, PerRootInfo perRootInfo) {
                this.model = model;
                this.perRootInfo = perRootInfo;
            }
        }
    }
}

