/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.CrossBuildInMemoryCachingScriptClassCache;
import org.gradle.groovy.scripts.internal.ScriptCacheKey;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.internal.Cast;

public class BuildScopeInMemoryCachingScriptClassCompiler
implements ScriptClassCompiler {
    private final CrossBuildInMemoryCachingScriptClassCache cache;
    private final ScriptClassCompiler scriptClassCompiler;
    private final Map<ScriptCacheKey, CompiledScript<?, ?>> cachedCompiledScripts = new HashMap();

    public BuildScopeInMemoryCachingScriptClassCompiler(CrossBuildInMemoryCachingScriptClassCache cache, ScriptClassCompiler scriptClassCompiler) {
        this.cache = cache;
        this.scriptClassCompiler = scriptClassCompiler;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, Class<T> scriptBaseClass, Object target, ClassLoaderScope targetScope, CompileOperation<M> operation, Action<? super ClassNode> verifier) {
        ScriptCacheKey key = new ScriptCacheKey(source.getClassName(), targetScope.getExportClassLoader(), operation.getId());
        CompiledScript<T, M> compiledScript = (CompiledScript<T, M>)Cast.uncheckedCast(this.cachedCompiledScripts.get(key));
        if (compiledScript == null) {
            compiledScript = this.cache.getOrCompile(target, source, targetScope, operation, scriptBaseClass, verifier, this.scriptClassCompiler);
            this.cachedCompiledScripts.put(key, compiledScript);
        }
        return compiledScript;
    }
}

