/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableFileSpec;
import org.gradle.nativeplatform.NativeInstallationSpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;

public class NativeComponents {
    private static final String ASSEMBLE_DEPENDENTS_TASK_NAME = "assembleDependents";
    private static final String BUILD_DEPENDENTS_TASK_NAME = "buildDependents";

    public static void createExecutableTask(final NativeBinarySpecInternal binary, final File executableFile) {
        String taskName = binary.getNamingScheme().getTaskName("link");
        binary.getTasks().create(taskName, LinkExecutable.class, (Action)new Action<LinkExecutable>(){

            public void execute(LinkExecutable linkTask) {
                linkTask.setDescription("Links " + binary.getDisplayName());
                linkTask.getToolChain().set((Object)binary.getToolChain());
                linkTask.getTargetPlatform().set((Object)binary.getTargetPlatform());
                linkTask.getLinkedFile().set(executableFile);
                linkTask.getLinkerArgs().set(binary.getLinker().getArgs());
                linkTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getLinkFiles();
                    }
                });
                binary.builtBy(new Object[]{linkTask});
            }
        });
    }

    public static void createInstallTask(final NativeBinarySpecInternal binary, final NativeInstallationSpec installation, final NativeExecutableFileSpec executable, BinaryNamingScheme namingScheme) {
        binary.getTasks().create(namingScheme.getTaskName("install"), InstallExecutable.class, (Action)new Action<InstallExecutable>(){

            public void execute(InstallExecutable installTask) {
                installTask.setDescription("Installs a development image of " + binary.getDisplayName());
                installTask.setGroup("build");
                installTask.getToolChain().set((Object)executable.getToolChain());
                installTask.getTargetPlatform().set((Object)binary.getTargetPlatform());
                installTask.getExecutableFile().set(executable.getFile());
                installTask.getInstallDirectory().set(installation.getDirectory());
                installTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getRuntimeFiles();
                    }
                });
                installTask.dependsOn(new Object[]{binary});
            }
        });
    }

    public static void createBuildDependentComponentsTasks(ModelMap<Task> tasks, ComponentSpecContainer components) {
        for (final VariantComponentSpec component : components.withType(NativeComponentSpec.class).withType(VariantComponentSpec.class)) {
            tasks.create(NativeComponents.getAssembleDependentComponentsTaskName((ComponentSpec)component), DefaultTask.class, (Action)new Action<DefaultTask>(){

                public void execute(DefaultTask assembleDependents) {
                    assembleDependents.setGroup("Build Dependents");
                    assembleDependents.setDescription("Assemble dependents of " + component.getDisplayName() + ".");
                }
            });
            tasks.create(NativeComponents.getBuildDependentComponentsTaskName((ComponentSpec)component), DefaultTask.class, (Action)new Action<DefaultTask>(){

                public void execute(DefaultTask buildDependents) {
                    buildDependents.setGroup("Build Dependents");
                    buildDependents.setDescription("Build dependents of " + component.getDisplayName() + ".");
                }
            });
        }
    }

    public static void createBuildDependentBinariesTasks(final NativeBinarySpecInternal binary, BinaryNamingScheme namingScheme) {
        binary.getTasks().create(namingScheme.getTaskName(ASSEMBLE_DEPENDENTS_TASK_NAME), DefaultTask.class, (Action)new Action<DefaultTask>(){

            public void execute(DefaultTask buildDependentsTask) {
                buildDependentsTask.setGroup("Build Dependents");
                buildDependentsTask.setDescription("Assemble dependents of " + binary.getDisplayName() + ".");
                buildDependentsTask.dependsOn(new Object[]{binary});
            }
        });
        binary.getTasks().create(namingScheme.getTaskName(BUILD_DEPENDENTS_TASK_NAME), DefaultTask.class, (Action)new Action<DefaultTask>(){

            public void execute(DefaultTask buildDependentsTask) {
                buildDependentsTask.setGroup("Build Dependents");
                buildDependentsTask.setDescription("Build dependents of " + binary.getDisplayName() + ".");
                buildDependentsTask.dependsOn(new Object[]{binary});
            }
        });
    }

    public static void wireBuildDependentTasks(ModelMap<Task> tasks, BinaryContainer binaries, final DependentBinariesResolver dependentsResolver, final ProjectModelResolver projectModelResolver) {
        ModelMap nativeBinaries = binaries.withType(NativeBinarySpecInternal.class);
        for (final BinarySpecInternal binary : nativeBinaries) {
            Task buildDependentComponents;
            Task assembleDependents = (Task)tasks.get(binary.getNamingScheme().getTaskName(ASSEMBLE_DEPENDENTS_TASK_NAME));
            Task buildDependents = (Task)tasks.get(binary.getNamingScheme().getTaskName(BUILD_DEPENDENTS_TASK_NAME));
            Task assembleDependentComponents = (Task)tasks.get(NativeComponents.getAssembleDependentComponentsTaskName(binary.getComponent()));
            if (assembleDependentComponents != null) {
                assembleDependentComponents.dependsOn(new Object[]{assembleDependents});
            }
            if ((buildDependentComponents = (Task)tasks.get(NativeComponents.getBuildDependentComponentsTaskName(binary.getComponent()))) != null) {
                buildDependentComponents.dependsOn(new Object[]{buildDependents});
            }
            assembleDependents.dependsOn(new Object[]{new Callable<Iterable<Task>>(){

                @Override
                public Iterable<Task> call() {
                    return NativeComponents.getDependentTaskDependencies(NativeComponents.ASSEMBLE_DEPENDENTS_TASK_NAME, binary, dependentsResolver, projectModelResolver);
                }
            }});
            buildDependents.dependsOn(new Object[]{new Callable<Iterable<Task>>(){

                @Override
                public Iterable<Task> call() {
                    return NativeComponents.getDependentTaskDependencies(NativeComponents.BUILD_DEPENDENTS_TASK_NAME, binary, dependentsResolver, projectModelResolver);
                }
            }});
        }
    }

    private static List<Task> getDependentTaskDependencies(String dependedOnBinaryTaskName, BinarySpecInternal binary, DependentBinariesResolver dependentsResolver, ProjectModelResolver projectModelResolver) {
        ArrayList<Task> dependencies = new ArrayList<Task>();
        DependentBinariesResolvedResult result = dependentsResolver.resolve(binary).getRoot();
        for (DependentBinariesResolvedResult dependent : result.getChildren()) {
            if (!dependent.isBuildable()) continue;
            ModelRegistry modelRegistry = projectModelResolver.resolveProjectModel(dependent.getId().getProjectPath());
            ModelMap projectBinaries = (ModelMap)modelRegistry.realize("binaries", ModelTypes.modelMap(NativeBinarySpecInternal.class));
            ModelMap projectTasks = (ModelMap)modelRegistry.realize("tasks", ModelTypes.modelMap(Task.class));
            NativeBinarySpecInternal dependentBinary = (NativeBinarySpecInternal)projectBinaries.get(dependent.getProjectScopedName());
            dependencies.add((Task)projectTasks.get(dependentBinary.getNamingScheme().getTaskName(dependedOnBinaryTaskName)));
        }
        return dependencies;
    }

    private static String getAssembleDependentComponentsTaskName(ComponentSpec component) {
        return ASSEMBLE_DEPENDENTS_TASK_NAME + StringUtils.capitalize((String)component.getName());
    }

    private static String getBuildDependentComponentsTaskName(ComponentSpec component) {
        return BUILD_DEPENDENTS_TASK_NAME + StringUtils.capitalize((String)component.getName());
    }

    public static abstract class BinaryLibs
    implements Callable<List<FileCollection>> {
        private final NativeBinarySpec binary;

        public BinaryLibs(NativeBinarySpec binary) {
            this.binary = binary;
        }

        @Override
        public List<FileCollection> call() throws Exception {
            ArrayList<FileCollection> runtimeFiles = new ArrayList<FileCollection>();
            for (NativeDependencySet nativeDependencySet : this.binary.getLibs()) {
                runtimeFiles.add(this.getFiles(nativeDependencySet));
            }
            return runtimeFiles;
        }

        protected abstract FileCollection getFiles(NativeDependencySet var1);
    }
}

