/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.configurer;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.plugins.ide.internal.configurer.AbstractUniqueProjectNameProvider;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementAdapter;
import org.gradle.plugins.ide.internal.configurer.HierarchicalElementDeduplicator;
import org.jspecify.annotations.Nullable;

public class DefaultUniqueProjectNameProvider
extends AbstractUniqueProjectNameProvider {
    private @Nullable Map<ProjectIdentity, String> deduplicated;

    public DefaultUniqueProjectNameProvider(ProjectStateRegistry projectRegistry) {
        super(projectRegistry);
    }

    @Override
    public String getUniqueName(ProjectIdentity projectIdentity) {
        String uniqueName = this.getDeduplicatedNames().get(projectIdentity);
        return uniqueName != null ? uniqueName : projectIdentity.getProjectName();
    }

    private synchronized Map<ProjectIdentity, String> getDeduplicatedNames() {
        if (this.deduplicated == null) {
            HierarchicalElementDeduplicator<ProjectIdentity> deduplicator = new HierarchicalElementDeduplicator<ProjectIdentity>(new ProjectPathDeduplicationAdapter());
            List allProjects = this.projectRegistry.getAllProjects().stream().map(ProjectState::getIdentity).collect(Collectors.toList());
            this.deduplicated = deduplicator.deduplicate(allProjects);
        }
        return this.deduplicated;
    }

    private class ProjectPathDeduplicationAdapter
    implements HierarchicalElementAdapter<ProjectIdentity> {
        private ProjectPathDeduplicationAdapter() {
        }

        @Override
        public String getName(ProjectIdentity element) {
            return element.getProjectName();
        }

        @Override
        public String getIdentityName(ProjectIdentity element) {
            String identityName = element.getBuildTreePath().getName();
            return identityName != null ? identityName : element.getProjectName();
        }

        @Override
        public @Nullable ProjectIdentity getParent(ProjectIdentity element) {
            return DefaultUniqueProjectNameProvider.this.findParentInBuildTree(element);
        }
    }
}

