/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;

public class DefaultResourceAwareResolveResult
implements ResourceAwareResolveResult {
    private Set<String> attempted;

    @Override
    public List<String> getAttempted() {
        return this.attempted == null ? Collections.emptyList() : ImmutableList.copyOf(this.attempted);
    }

    @Override
    public void attempted(String locationDescription) {
        if (this.attempted == null) {
            this.attempted = new LinkedHashSet<String>();
        }
        this.attempted.add(locationDescription);
    }

    @Override
    public void attempted(ExternalResourceName location) {
        this.attempted(location.getDisplayName());
    }

    @Override
    public void applyTo(ResourceAwareResolveResult target) {
        if (this.attempted != null) {
            for (String location : this.attempted) {
                target.attempted(location);
            }
        }
    }
}

