/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildGenerator;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.internal.logging.text.TreeFormatter;

public class ProjectLayoutSetupRegistry {
    private final Map<String, BuildInitializer> registeredProjectDescriptors = new TreeMap<String, BuildInitializer>();
    private final BuildGenerator defaultType;
    private final BuildConverter converter;
    private final TemplateOperationFactory templateOperationFactory;

    public ProjectLayoutSetupRegistry(BuildGenerator defaultType, BuildConverter converter, TemplateOperationFactory templateOperationFactory) {
        this.defaultType = defaultType;
        this.converter = converter;
        this.templateOperationFactory = templateOperationFactory;
        this.add(defaultType);
        this.add(converter);
    }

    public void add(BuildInitializer descriptor) {
        if (this.registeredProjectDescriptors.containsKey(descriptor.getId())) {
            throw new GradleException(String.format("ProjectDescriptor with ID '%s' already registered.", descriptor.getId()));
        }
        this.registeredProjectDescriptors.put(descriptor.getId(), descriptor);
    }

    public TemplateOperationFactory getTemplateOperationFactory() {
        return this.templateOperationFactory;
    }

    public List<Language> getLanguagesFor(ComponentType componentType) {
        List<BuildGenerator> generators = this.getGeneratorsFor(componentType);
        ArrayList<Language> result = new ArrayList<Language>();
        block0: for (Language language : Language.values()) {
            for (BuildGenerator generator : generators) {
                if (!generator.productionCodeUses(language)) continue;
                result.add(language);
                continue block0;
            }
        }
        return result;
    }

    public List<ComponentType> getComponentTypes() {
        return Arrays.asList(ComponentType.values());
    }

    public ComponentType getDefaultComponentType() {
        return ComponentType.APPLICATION;
    }

    public BuildConverter getBuildConverter() {
        return this.converter;
    }

    public BuildGenerator getDefault() {
        return this.defaultType;
    }

    public BuildInitializer get(String type) {
        if (!this.registeredProjectDescriptors.containsKey(type)) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("The requested build type '" + type + "' is not supported. Supported types");
            formatter.startChildren();
            for (String candidate : this.getAllTypes()) {
                formatter.node("'" + candidate + "'");
            }
            formatter.endChildren();
            throw new GradleException(formatter.toString());
        }
        return this.registeredProjectDescriptors.get(type);
    }

    private List<BuildGenerator> getGenerators() {
        ArrayList<BuildGenerator> result = new ArrayList<BuildGenerator>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initializer : this.registeredProjectDescriptors.values()) {
            if (!(initializer instanceof BuildGenerator)) continue;
            result.add((BuildGenerator)initializer);
        }
        return result;
    }

    public List<BuildGenerator> getGeneratorsFor(ComponentType componentType) {
        List<BuildGenerator> generators = this.getGenerators();
        ArrayList<BuildGenerator> result = new ArrayList<BuildGenerator>(generators.size());
        for (BuildGenerator generator : generators) {
            if (!generator.getComponentType().equals((Object)componentType)) continue;
            result.add(generator);
        }
        return result;
    }

    public List<String> getAllTypes() {
        ArrayList<String> result = new ArrayList<String>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initDescriptor : this.registeredProjectDescriptors.values()) {
            result.add(initDescriptor.getId());
        }
        return result;
    }
}

