/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.problems.Problem;

public class DefaultFailure
implements Failure {
    private final String message;
    private final String description;
    private final List<? extends Failure> causes;
    private final List<Problem> problems;

    public DefaultFailure(String message, String description, List<? extends Failure> causes) {
        this(message, description, causes, Collections.emptyList());
    }

    public DefaultFailure(String message, String description, List<? extends Failure> causes, List<Problem> problems) {
        this.message = message;
        this.description = description;
        this.causes = causes;
        this.problems = problems;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<? extends Failure> getCauses() {
        return this.causes;
    }

    @Override
    public List<Problem> getProblems() {
        return this.problems;
    }

    public static DefaultFailure fromThrowable(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter wrt = new PrintWriter(out);
        t.printStackTrace(wrt);
        Throwable cause = t.getCause();
        List causes = cause != null && cause != t ? Collections.singletonList(DefaultFailure.fromThrowable(cause)) : Collections.emptyList();
        return new DefaultFailure(t.getMessage(), out.toString(), causes);
    }

    public String toString() {
        return "DefaultFailure{message='" + this.message + '\'' + ", description='" + this.description + '\'' + ", causes=" + this.causes + ", problems=" + this.problems + '}';
    }
}

