/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.TestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestDefinitionProcessorFactory;
import org.gradle.api.internal.tasks.testing.worker.RemoteTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.worker.SecurityManagerRef;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.internal.tasks.testing.worker.WorkerTestDefinitionProcessor;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.actor.internal.DefaultActorFactory;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.dispatch.ContextClassLoaderProxy;
import org.gradle.internal.id.CompositeIdGenerator;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.time.Clock;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWorker<D extends TestDefinition>
implements Action<WorkerProcessContext>,
RemoteTestDefinitionProcessor<D>,
Serializable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestWorker.class);
    public static final String WORKER_ID_SYS_PROPERTY = "org.gradle.test.worker";
    public static final String WORKER_TMPDIR_SYS_PROPERTY = "org.gradle.internal.worker.tmpdir";
    private static final String WORK_THREAD_NAME = "Test worker";
    private final WorkerTestDefinitionProcessorFactory<D> factory;
    private final BlockingQueue<Runnable> runQueue = new ArrayBlockingQueue<Runnable>(1);
    private TestDefinitionProcessor<D> processor;
    private TestResultProcessor resultProcessor;
    private volatile State state = State.INITIALIZING;

    public TestWorker(WorkerTestDefinitionProcessorFactory<D> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WorkerProcessContext workerProcessContext) {
        Thread.currentThread().setName(WORK_THREAD_NAME);
        LOGGER.info("{} started executing tests.", (Object)workerProcessContext.getDisplayName());
        SecurityManagerRef securityManagerRef = SecurityManagerRef.getOrFake();
        System.setProperty(WORKER_ID_SYS_PROPERTY, workerProcessContext.getWorkerId().toString());
        CloseableServiceRegistry testServices = TestFrameworkServiceRegistry.create(workerProcessContext);
        this.startReceivingTests(workerProcessContext, (ServiceRegistry)testServices);
        try {
            try {
                while (this.state != State.STOPPED) {
                    TestWorker.executeAndMaintainThreadName(this.runQueue.take());
                }
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        finally {
            LOGGER.info("{} finished executing tests.", (Object)workerProcessContext.getDisplayName());
            TestWorker testWorker = this;
            synchronized (testWorker) {
                this.state = State.STOPPED;
                this.runQueue.clear();
            }
            securityManagerRef.reinstall(LOGGER);
            testServices.close();
        }
    }

    private static void executeAndMaintainThreadName(Runnable action) {
        try {
            action.run();
        }
        finally {
            Thread.currentThread().setName(WORK_THREAD_NAME);
        }
    }

    private void startReceivingTests(WorkerProcessContext workerProcessContext, ServiceRegistry testServices) {
        TestDefinitionProcessor<D> targetProcessor = this.factory.create((IdGenerator)testServices.get(IdGenerator.class), (ActorFactory)testServices.get(ActorFactory.class), (Clock)testServices.get(Clock.class));
        IdGenerator idGenerator = (IdGenerator)Cast.uncheckedNonnullCast((Object)testServices.get(IdGenerator.class));
        targetProcessor = new WorkerTestDefinitionProcessor<D>(targetProcessor, idGenerator.generateId(), workerProcessContext.getDisplayName(), (Clock)testServices.get(Clock.class));
        ContextClassLoaderProxy proxy = new ContextClassLoaderProxy((Class)Cast.uncheckedNonnullCast(TestDefinitionProcessor.class), targetProcessor, workerProcessContext.getApplicationClassLoader());
        this.processor = (TestDefinitionProcessor)proxy.getSource();
        ObjectConnection serverConnection = workerProcessContext.getServerConnection();
        serverConnection.useParameterSerializers(TestEventSerializer.create());
        this.resultProcessor = (TestResultProcessor)serverConnection.addOutgoing(TestResultProcessor.class);
        serverConnection.addIncoming(RemoteTestDefinitionProcessor.class, (Object)this);
        serverConnection.connect();
    }

    @Override
    public void startProcessing() {
        this.submitToRun(new Runnable(){

            @Override
            public void run() {
                if (TestWorker.this.state != State.INITIALIZING) {
                    throw new IllegalStateException("A command to start processing has already been received");
                }
                TestWorker.this.processor.startProcessing(TestWorker.this.resultProcessor);
                TestWorker.this.state = State.STARTED;
            }
        });
    }

    @Override
    public void processTestDefinition(D testDefinition) {
        this.submitToRun(new Runnable(){
            final /* synthetic */ TestDefinition val$testDefinition;
            {
                this.val$testDefinition = testDefinition;
            }

            @Override
            public void run() {
                if (TestWorker.this.state != State.STARTED) {
                    throw new IllegalStateException("Test classes cannot be processed until a command to start processing has been received");
                }
                try {
                    TestWorker.this.processor.processTestDefinition(this.val$testDefinition);
                }
                catch (AccessControlException e) {
                    throw e;
                }
                finally {
                    Thread.interrupted();
                }
            }
        });
    }

    @Override
    public void stop() {
        this.submitToRun(new Runnable(){

            @Override
            public void run() {
                try {
                    TestWorker.this.processor.stop();
                }
                finally {
                    TestWorker.this.state = State.STOPPED;
                    Thread.interrupted();
                }
            }
        });
    }

    private synchronized void submitToRun(Runnable command) {
        if (this.state != State.STOPPED) {
            try {
                this.runQueue.put(command);
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private static enum State {
        INITIALIZING,
        STARTED,
        STOPPED;

    }

    private static class TestFrameworkServiceRegistry
    implements ServiceRegistrationProvider {
        private final WorkerProcessContext workerProcessContext;

        public static CloseableServiceRegistry create(WorkerProcessContext workerProcessContext) {
            return ServiceRegistryBuilder.builder().displayName("test framework services").provider((ServiceRegistrationProvider)new TestFrameworkServiceRegistry(workerProcessContext)).build();
        }

        public TestFrameworkServiceRegistry(WorkerProcessContext workerProcessContext) {
            this.workerProcessContext = workerProcessContext;
        }

        @Provides
        protected Clock createClock() {
            return (Clock)this.workerProcessContext.getServiceRegistry().get(Clock.class);
        }

        @Provides
        protected IdGenerator<Object> createIdGenerator() {
            return new CompositeIdGenerator(this.workerProcessContext.getWorkerId(), (IdGenerator)new LongIdGenerator());
        }

        @Provides
        protected ExecutorFactory createExecutorFactory() {
            return new DefaultExecutorFactory();
        }

        @Provides
        protected ActorFactory createActorFactory(ExecutorFactory executorFactory) {
            return new DefaultActorFactory(executorFactory);
        }
    }
}

