/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.jspecify.annotations.Nullable;

public class DefaultMultipleCandidateResult<T>
implements MultipleCandidatesResult<T> {
    private final Set<T> candidateValues;
    private final T consumerValue;
    private T singleMatch;
    private Set<T> multipleMatches;

    public DefaultMultipleCandidateResult(@Nullable T consumerValue, Set<T> candidateValues) {
        if (candidateValues.isEmpty() || consumerValue != null && candidateValues.size() == 1) {
            throw new IllegalArgumentException("Insufficient number of candidate values: " + candidateValues.size());
        }
        for (T candidateValue : candidateValues) {
            if (candidateValue != null) continue;
            throw new IllegalArgumentException("candidateValues cannot contain null elements");
        }
        this.candidateValues = candidateValues;
        this.consumerValue = consumerValue;
    }

    @Override
    public boolean hasResult() {
        return this.singleMatch != null || this.multipleMatches != null;
    }

    @Override
    public Set<T> getMatches() {
        assert (this.hasResult());
        if (this.singleMatch != null) {
            return Collections.singleton(this.singleMatch);
        }
        return this.multipleMatches;
    }

    public @Nullable T getConsumerValue() {
        return this.consumerValue;
    }

    public Set<T> getCandidateValues() {
        return this.candidateValues;
    }

    public void closestMatch(T candidate) {
        if (this.singleMatch == null) {
            if (this.multipleMatches == null) {
                this.singleMatch = candidate;
            } else {
                this.multipleMatches.add(candidate);
            }
            return;
        }
        if (this.singleMatch.equals(candidate)) {
            return;
        }
        this.multipleMatches = Sets.newHashSetWithExpectedSize((int)this.candidateValues.size());
        this.multipleMatches.add(this.singleMatch);
        this.multipleMatches.add(candidate);
        this.singleMatch = null;
    }
}

