/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.jspecify.annotations.Nullable;

public class DependencyState {
    private final ComponentSelector requested;
    private final DependencyMetadata dependency;
    private final ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private final @Nullable ModuleVersionResolveException substitutionFailure;
    private @Nullable ModuleIdentifier moduleIdentifier;
    private boolean reasonsAlreadyAdded;

    public DependencyState(DependencyMetadata dependency, ComponentSelector requested, ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors, @Nullable ModuleVersionResolveException substitutionFailure) {
        this.dependency = dependency;
        this.requested = requested;
        this.ruleDescriptors = ruleDescriptors;
        this.substitutionFailure = substitutionFailure;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public DependencyMetadata getDependency() {
        return this.dependency;
    }

    public @Nullable ModuleVersionResolveException getSubstitutionFailure() {
        return this.substitutionFailure;
    }

    public ModuleIdentifier getModuleIdentifier(ComponentSelectorConverter componentSelectorConverter) {
        if (this.moduleIdentifier == null) {
            ComponentSelector componentSelector = this.dependency.getSelector();
            this.moduleIdentifier = componentSelector instanceof ModuleComponentSelector ? ((ModuleComponentSelector)componentSelector).getModuleIdentifier() : componentSelectorConverter.getModuleVersionId(componentSelector).getModule();
        }
        return this.moduleIdentifier;
    }

    public boolean isForced() {
        if (!this.ruleDescriptors.isEmpty()) {
            for (ComponentSelectionDescriptorInternal ruleDescriptor : this.ruleDescriptors) {
                if (!ruleDescriptor.isEquivalentToForce()) continue;
                return true;
            }
        }
        return this.isDependencyForced();
    }

    private boolean isDependencyForced() {
        return this.dependency instanceof ForcingDependencyMetadata && ((ForcingDependencyMetadata)this.dependency).isForce();
    }

    public boolean isFromLock() {
        return this.dependency instanceof LocalOriginDependencyMetadata && ((LocalOriginDependencyMetadata)this.dependency).isFromLock();
    }

    void addSelectionReasons(List<ComponentSelectionDescriptorInternal> reasons) {
        if (this.reasonsAlreadyAdded) {
            return;
        }
        this.reasonsAlreadyAdded = true;
        this.addMainReason(reasons);
        if (!this.ruleDescriptors.isEmpty()) {
            this.addRuleDescriptors(reasons);
        }
        if (this.isDependencyForced()) {
            DependencyState.maybeAddReason(reasons, ComponentSelectionReasons.FORCED);
        }
    }

    private void addRuleDescriptors(List<ComponentSelectionDescriptorInternal> reasons) {
        for (ComponentSelectionDescriptorInternal descriptor : this.ruleDescriptors) {
            DependencyState.maybeAddReason(reasons, descriptor);
        }
    }

    private void addMainReason(List<ComponentSelectionDescriptorInternal> reasons) {
        ComponentSelectionDescriptorInternal dependencyDescriptor = reasons.contains(ComponentSelectionReasons.BY_ANCESTOR) ? ComponentSelectionReasons.BY_ANCESTOR : (this.dependency.isConstraint() ? ComponentSelectionReasons.CONSTRAINT : ComponentSelectionReasons.REQUESTED);
        String reason = this.dependency.getReason();
        if (reason != null) {
            dependencyDescriptor = dependencyDescriptor.withDescription((Describable)Describables.of((Object)reason));
        }
        DependencyState.maybeAddReason(reasons, dependencyDescriptor);
    }

    private static void maybeAddReason(List<ComponentSelectionDescriptorInternal> reasons, ComponentSelectionDescriptorInternal reason) {
        if (reasons.isEmpty()) {
            reasons.add(reason);
        } else if (DependencyState.isNewReason(reasons, reason)) {
            reasons.add(reason);
        }
    }

    private static boolean isNewReason(List<ComponentSelectionDescriptorInternal> reasons, ComponentSelectionDescriptorInternal reason) {
        return reasons.size() == 1 && !reason.equals(reasons.get(0)) || !reasons.contains(reason);
    }
}

