/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.BaseLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.operations.BuildCacheLocalLoadBuildOperationType;
import org.gradle.caching.internal.operations.BuildCacheLocalStoreBuildOperationType;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;

public class OpFiringLocalBuildCacheServiceHandle
extends BaseLocalBuildCacheServiceHandle {
    private static final BuildCacheLocalStoreBuildOperationType.Result LOCAL_STORE_RESULT = new BuildCacheLocalStoreBuildOperationType.Result(){

        public boolean isStored() {
            return true;
        }
    };
    private final BuildOperationRunner buildOperationRunner;

    public OpFiringLocalBuildCacheServiceHandle(LocalBuildCacheService service, boolean pushEnabled, BuildOperationRunner buildOperationRunner) {
        super(service, pushEnabled);
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public Optional<BuildCacheLoadResult> maybeLoad(final BuildCacheKey key, final Function<File, BuildCacheLoadResult> unpackFunction) {
        return (Optional)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Optional<BuildCacheLoadResult>>(){

            public Optional<BuildCacheLoadResult> call(BuildOperationContext context) {
                AtomicReference<Long> archiveSize = new AtomicReference<Long>();
                Optional result = OpFiringLocalBuildCacheServiceHandle.super.maybeLoad(key, file -> {
                    archiveSize.set(file.length());
                    return (BuildCacheLoadResult)unpackFunction.apply(file);
                });
                context.setResult((Object)new LocalLoadResult(result, archiveSize));
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Load entry " + key.getHashCode() + " from local build cache")).details((Object)new LocalLoadDetails(key));
            }
        });
    }

    @Override
    protected void storeInner(final BuildCacheKey key, final File file) {
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) throws Exception {
                OpFiringLocalBuildCacheServiceHandle.super.storeInner(key, file);
                context.setResult((Object)LOCAL_STORE_RESULT);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Store entry " + key.getHashCode() + " in local build cache")).details((Object)new LocalStoreDetails(key, file));
            }
        });
    }

    private static class LocalStoreDetails
    implements BuildCacheLocalStoreBuildOperationType.Details {
        private final BuildCacheKey key;
        private final long archiveSize;

        public LocalStoreDetails(BuildCacheKey key, File file) {
            this.key = key;
            this.archiveSize = file.length();
        }

        public String getCacheKey() {
            return this.key.getHashCode();
        }

        public long getArchiveSize() {
            return this.archiveSize;
        }
    }

    private static class LocalLoadResult
    implements BuildCacheLocalLoadBuildOperationType.Result {
        private final Optional<BuildCacheLoadResult> result;
        private final AtomicReference<Long> archiveSize;

        public LocalLoadResult(Optional<BuildCacheLoadResult> result, AtomicReference<Long> archiveSize) {
            this.result = result;
            this.archiveSize = archiveSize;
        }

        public boolean isHit() {
            return this.result.isPresent();
        }

        public long getArchiveSize() {
            Long l = this.archiveSize.get();
            if (l != null) {
                return l;
            }
            return -1L;
        }
    }

    private static class LocalLoadDetails
    implements BuildCacheLocalLoadBuildOperationType.Details {
        private final BuildCacheKey key;

        public LocalLoadDetails(BuildCacheKey key) {
            this.key = key;
        }

        public String getCacheKey() {
            return this.key.getHashCode();
        }
    }
}

