/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.components.Service;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.SimpleModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;

@Service
public final class PsiJavaModuleModificationTracker
extends SimpleModificationTracker
implements Disposable {
    public static PsiJavaModuleModificationTracker getInstance(Project project) {
        return project.getService(PsiJavaModuleModificationTracker.class);
    }

    public PsiJavaModuleModificationTracker(Project project) {
        MessageBusConnection connect = project.getMessageBus().connect(this);
        connect.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent.getFile();
                    if (file == null || (file.isDirectory() || !PsiJavaModuleModificationTracker.isModuleFile(file.getName())) && !(vFileEvent instanceof VFileDeleteEvent) && (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName()))) continue;
                    PsiJavaModuleModificationTracker.this.incModificationCount();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiJavaModuleModificationTracker$1", "after"));
            }
        });
    }

    static boolean isModuleFile(String name2) {
        return "module-info.java".equals(name2) || "MANIFEST.MF".equalsIgnoreCase(name2);
    }

    @Override
    public void dispose() {
    }
}

