/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results.serializable;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableFailure;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializedMetadata;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.jspecify.annotations.Nullable;

public final class SerializableTestResult {
    private final String name;
    private final String displayName;
    private final @Nullable String className;
    private final @Nullable String classDisplayName;
    private final TestResult.ResultType resultType;
    private final long startTime;
    private final long endTime;
    private final @Nullable SerializableFailure assumptionFailure;
    private final ImmutableList<SerializableFailure> failures;
    private final ImmutableList<SerializedMetadata> metadatas;

    public static Builder builder() {
        return new Builder();
    }

    public SerializableTestResult(String name, String displayName, @Nullable String className, @Nullable String classDisplayName, TestResult.ResultType resultType, long startTime, long endTime, @Nullable SerializableFailure assumptionFailure, ImmutableList<SerializableFailure> failures, ImmutableList<SerializedMetadata> metadatas) {
        this.name = name;
        this.displayName = displayName;
        this.className = className;
        this.classDisplayName = classDisplayName;
        this.resultType = resultType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.assumptionFailure = assumptionFailure;
        this.failures = failures;
        this.metadatas = metadatas;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public @Nullable String getClassName() {
        return this.className;
    }

    public @Nullable String getClassDisplayName() {
        return this.classDisplayName;
    }

    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public @Nullable SerializableFailure getAssumptionFailure() {
        return this.assumptionFailure;
    }

    public ImmutableList<SerializableFailure> getFailures() {
        return this.failures;
    }

    public ImmutableList<SerializedMetadata> getMetadatas() {
        return this.metadatas;
    }

    public SerializableTestResult merge(SerializableTestResult other) {
        if (!this.name.equals(other.name)) {
            throw new IllegalArgumentException("Cannot merge test results with different names: " + this.name + " and " + other.name);
        }
        if (!this.displayName.equals(other.displayName)) {
            throw new IllegalArgumentException("Cannot merge test results with different display names: " + this.displayName + " and " + other.displayName);
        }
        if (!Objects.equals(this.className, other.className)) {
            throw new IllegalArgumentException("Cannot merge test results with different class names: " + this.className + " and " + other.className);
        }
        if (!Objects.equals(this.classDisplayName, other.classDisplayName)) {
            throw new IllegalArgumentException("Cannot merge test results with different class display names: " + this.classDisplayName + " and " + other.classDisplayName);
        }
        if (this.assumptionFailure != null && other.assumptionFailure != null) {
            throw new IllegalArgumentException("Cannot merge test results with multiple assumption failures");
        }
        TestResult.ResultType resultType = this.resultType == TestResult.ResultType.FAILURE || other.resultType == TestResult.ResultType.FAILURE ? TestResult.ResultType.FAILURE : (this.resultType == TestResult.ResultType.SKIPPED || other.resultType == TestResult.ResultType.SKIPPED ? TestResult.ResultType.SKIPPED : TestResult.ResultType.SUCCESS);
        Builder builder = new Builder().name(this.name).displayName(this.displayName).className(this.className).classDisplayName(this.classDisplayName).resultType(resultType).assumptionFailure(this.assumptionFailure != null ? this.assumptionFailure : other.assumptionFailure).startTime(Math.min(this.startTime, other.startTime)).endTime(Math.max(this.endTime, other.endTime));
        builder.failures.addAll(this.failures);
        builder.failures.addAll(other.failures);
        builder.metadatas.addAll(this.metadatas);
        builder.metadatas.addAll(other.metadatas);
        return builder.build();
    }

    public static final class Builder {
        private @Nullable String name;
        private @Nullable String displayName;
        private @Nullable String className;
        private @Nullable String classDisplayName;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable TestResult.ResultType resultType;
        private @Nullable Long startTime;
        private @Nullable Long endTime;
        private @Nullable SerializableFailure assumptionFailure;
        private final ImmutableList.Builder<SerializableFailure> failures = ImmutableList.builder();
        private final ImmutableList.Builder<SerializedMetadata> metadatas = ImmutableList.builder();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder className(@Nullable String className) {
            this.className = className;
            return this;
        }

        public Builder classDisplayName(@Nullable String classDisplayName) {
            this.classDisplayName = classDisplayName;
            return this;
        }

        public Builder resultType(TestResult.ResultType resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder assumptionFailure(@Nullable SerializableFailure failure) {
            this.assumptionFailure = failure;
            return this;
        }

        public Builder addFailure(SerializableFailure failure) {
            this.failures.add((Object)failure);
            return this;
        }

        public Builder addMetadata(SerializedMetadata metadata) {
            this.metadatas.add((Object)metadata);
            return this;
        }

        public SerializableTestResult build() {
            if (this.name == null) {
                throw new IllegalStateException("name is required");
            }
            if (this.displayName == null) {
                throw new IllegalStateException("displayName is required");
            }
            if (this.resultType == null) {
                throw new IllegalStateException("resultType is required");
            }
            if (this.startTime == null) {
                throw new IllegalStateException("startTime is required");
            }
            if (this.endTime == null) {
                throw new IllegalStateException("endTime is required");
            }
            return new SerializableTestResult(this.name, this.displayName, this.className, this.classDisplayName, this.resultType, this.startTime, this.endTime, this.assumptionFailure, (ImmutableList<SerializableFailure>)this.failures.build(), (ImmutableList<SerializedMetadata>)this.metadatas.build());
        }
    }

    public static final class Serializer {
        private Serializer() {
        }

        public static void serialize(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeString((CharSequence)result.name);
            encoder.writeString((CharSequence)result.displayName);
            encoder.writeNullableString((CharSequence)result.className);
            encoder.writeNullableString((CharSequence)result.classDisplayName);
            encoder.writeSmallInt(result.resultType.ordinal());
            encoder.writeLong(result.startTime);
            encoder.writeLong(result.endTime);
            boolean hasAssumptionFailure = result.assumptionFailure != null;
            encoder.writeBoolean(hasAssumptionFailure);
            if (hasAssumptionFailure) {
                Serializer.serializeFailure(encoder, result.assumptionFailure);
            }
            Serializer.serializeFailures(result, encoder);
            Serializer.serializeMetadatas(result, encoder);
        }

        public static SerializableTestResult deserialize(Decoder decoder) throws IOException {
            String name = decoder.readString();
            String displayName = decoder.readString();
            String className = decoder.readNullableString();
            String classDisplayName = decoder.readNullableString();
            TestResult.ResultType resultType = TestResult.ResultType.values()[decoder.readSmallInt()];
            long startTime = decoder.readLong();
            long endTime = decoder.readLong();
            SerializableFailure assumptionFailure = null;
            boolean hasAssumptionFailure = decoder.readBoolean();
            if (hasAssumptionFailure) {
                assumptionFailure = Serializer.deserializeFailure(decoder);
            }
            ImmutableList<SerializableFailure> failures = Serializer.deserializeFailures(decoder);
            ImmutableList<SerializedMetadata> metadatas = Serializer.deserializeMetadatas(decoder);
            return new SerializableTestResult(name, displayName, className, classDisplayName, resultType, startTime, endTime, assumptionFailure, failures, metadatas);
        }

        private static void serializeFailures(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeSmallInt(result.failures.size());
            for (SerializableFailure failure : result.failures) {
                Serializer.serializeFailure(encoder, failure);
            }
        }

        private static ImmutableList<SerializableFailure> deserializeFailures(Decoder decoder) throws IOException {
            ImmutableList.Builder failures = ImmutableList.builder();
            int failureCount = decoder.readSmallInt();
            for (int i = 0; i < failureCount; ++i) {
                failures.add((Object)Serializer.deserializeFailure(decoder));
            }
            return failures.build();
        }

        private static void serializeFailure(Encoder encoder, SerializableFailure failure) throws IOException {
            encoder.writeString((CharSequence)failure.getMessage());
            encoder.writeString((CharSequence)failure.getStackTrace());
            encoder.writeString((CharSequence)failure.getExceptionType());
            encoder.writeInt(failure.getCauses().size());
            for (String cause : failure.getCauses()) {
                encoder.writeString((CharSequence)cause);
            }
        }

        private static SerializableFailure deserializeFailure(Decoder decoder) throws IOException {
            String message = decoder.readString();
            String stackTrace = decoder.readString();
            String exceptionType = decoder.readString();
            int causeCount = decoder.readInt();
            ArrayList<String> causes = new ArrayList<String>(causeCount);
            for (int i = 0; i < causeCount; ++i) {
                causes.add(decoder.readString());
            }
            return new SerializableFailure(message, stackTrace, exceptionType, causes);
        }

        private static void serializeMetadatas(SerializableTestResult result, Encoder encoder) throws IOException {
            encoder.writeSmallInt(result.metadatas.size());
            for (SerializedMetadata metadata : result.metadatas) {
                encoder.writeLong(metadata.getLogTime());
                encoder.writeSmallInt(metadata.getEntries().size());
                for (SerializedMetadata.SerializedMetadataElement entry : metadata.getEntries()) {
                    encoder.writeString((CharSequence)entry.getKey());
                    encoder.writeBinary(entry.getSerializedValue());
                    encoder.writeString((CharSequence)entry.getValueType());
                }
            }
        }

        private static ImmutableList<SerializedMetadata> deserializeMetadatas(Decoder decoder) throws IOException {
            ImmutableList.Builder metadatas = ImmutableList.builder();
            int metadataCount = decoder.readSmallInt();
            for (int i = 0; i < metadataCount; ++i) {
                long logTime = decoder.readLong();
                int entryCount = decoder.readSmallInt();
                ImmutableList.Builder entries = ImmutableList.builder();
                for (int j = 0; j < entryCount; ++j) {
                    String key = decoder.readString();
                    byte[] value = decoder.readBinary();
                    String valueType = decoder.readString();
                    entries.add((Object)new SerializedMetadata.SerializedMetadataElement(key, value, valueType));
                }
                metadatas.add((Object)new SerializedMetadata(logTime, (ImmutableList<SerializedMetadata.SerializedMetadataElement>)entries.build()));
            }
            return metadatas.build();
        }
    }
}

