/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CamelCaseUtil {
    private static final Pattern WORD_SEPARATOR = Pattern.compile("\\W+");
    private static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase(Locale.ROOT);
        }
    };
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");
    private static final Joiner KEBAB_JOINER = Joiner.on((String)"-");

    public static String camelToKebabCase(String camelCase) {
        return KEBAB_JOINER.join(Iterables.transform(Arrays.asList(UPPER_CASE.split(camelCase)), TO_LOWERCASE));
    }

    public static String toCamelCase(CharSequence string) {
        return CamelCaseUtil.toCamelCase(string, false);
    }

    public static String toLowerCamelCase(CharSequence string) {
        return CamelCaseUtil.toCamelCase(string, true);
    }

    private static String toCamelCase(CharSequence string, boolean lower) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = WORD_SEPARATOR.matcher(string);
        int pos = 0;
        boolean first = true;
        while (matcher.find()) {
            String chunk = string.subSequence(pos, matcher.start()).toString();
            pos = matcher.end();
            if (chunk.isEmpty()) continue;
            if (lower && first) {
                chunk = StringUtils.uncapitalize((String)chunk);
                first = false;
            } else {
                chunk = StringUtils.capitalize((String)chunk);
            }
            builder.append(chunk);
        }
        String rest = string.subSequence(pos, string.length()).toString();
        rest = lower && first ? StringUtils.uncapitalize((String)rest) : StringUtils.capitalize((String)rest);
        builder.append(rest);
        return builder.toString();
    }
}

