/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.util.internal.CamelCaseUtil;
import org.jspecify.annotations.Nullable;

public class DefaultJvmFeature
implements JvmFeatureInternal {
    private static final String SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX = "SourceElements";
    private final String name;
    private final SourceSet sourceSet;
    private final Set<Capability> capabilities;
    private final boolean extendProductionCode;
    private final ProjectInternal project;
    private final JvmPluginServices jvmPluginServices;
    private final JvmLanguageUtilities jvmLanguageUtilities;
    private final TaskProvider<Jar> jar;
    private final TaskProvider<JavaCompile> compileJava;
    private final Configuration implementation;
    private final Configuration runtimeOnly;
    private final Configuration compileOnly;
    private Configuration compileOnlyApi;
    private Configuration api;
    private final Configuration runtimeClasspath;
    private final Configuration compileClasspath;
    private final NamedDomainObjectProvider<ConsumableConfiguration> apiElements;
    private final NamedDomainObjectProvider<ConsumableConfiguration> runtimeElements;
    private @Nullable NamedDomainObjectProvider<ConsumableConfiguration> javadocElements;
    private @Nullable NamedDomainObjectProvider<ConsumableConfiguration> sourcesElements;

    public DefaultJvmFeature(String name, SourceSet sourceSet, Set<Capability> capabilities, ProjectInternal project, boolean extendProductionCode) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.capabilities = capabilities;
        this.project = project;
        this.extendProductionCode = extendProductionCode;
        if (extendProductionCode && !SourceSet.isMain((SourceSet)sourceSet)) {
            throw new GradleException("Cannot extend main feature if source set is not also main.");
        }
        this.jvmPluginServices = (JvmPluginServices)project.getServices().get(JvmPluginServices.class);
        this.jvmLanguageUtilities = (JvmLanguageUtilities)project.getServices().get(JvmLanguageUtilities.class);
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        this.compileJava = tasks.named(sourceSet.getCompileJavaTaskName(), JavaCompile.class);
        this.jar = this.registerOrGetJarTask(sourceSet, (TaskContainer)tasks);
        this.implementation = this.dependencyScope("Implementation", "implementation", extendProductionCode, false);
        this.compileOnly = this.dependencyScope("Compile-only", "compileOnly", extendProductionCode, false);
        this.runtimeOnly = this.dependencyScope("Runtime-only", "runtimeOnly", extendProductionCode, false);
        this.runtimeClasspath = configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName());
        this.compileClasspath = configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        LazyPublishArtifact jarArtifact = new LazyPublishArtifact(this.jar, project.getFileResolver(), project.getTaskDependencyFactory());
        this.apiElements = this.createApiElements(configurations, (PublishArtifact)jarArtifact, this.compileJava);
        this.runtimeElements = this.createRuntimeElements(configurations, (PublishArtifact)jarArtifact, this.compileJava);
        if (extendProductionCode) {
            this.doExtendProductionCode();
        }
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        JvmPluginsHelper.configureJavaDocTask("'" + name + "' feature", sourceSet, (TaskContainer)tasks, javaPluginExtension);
    }

    void doExtendProductionCode() {
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        SourceSet mainSourceSet = (SourceSet)((JavaPluginExtension)this.project.getExtensions().findByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        configurations.getByName(mainSourceSet.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{this.implementation, this.compileOnly});
        configurations.getByName(mainSourceSet.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
        configurations.getByName("testCompileClasspath").extendsFrom(new Configuration[]{this.implementation});
        configurations.getByName("testRuntimeClasspath").extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
    }

    private String getConfigurationName(String suffix) {
        if (this.extendProductionCode) {
            return this.name + StringUtils.capitalize((String)suffix);
        }
        return ((DefaultSourceSet)this.sourceSet).configurationNameOf(suffix);
    }

    private static void addJarArtifactToConfiguration(Configuration configuration, PublishArtifact jarArtifact) {
        ConfigurationPublications publications = configuration.getOutgoing();
        publications.getArtifacts().add((Object)jarArtifact);
        publications.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
    }

    private NamedDomainObjectProvider<ConsumableConfiguration> createApiElements(RoleBasedConfigurationContainerInternal configurations, PublishArtifact jarArtifact, TaskProvider<JavaCompile> compileJava) {
        String configName = this.getConfigurationName("apiElements");
        return configurations.consumable(configName, apiElements -> {
            this.jvmLanguageUtilities.useDefaultTargetPlatformInference((Configuration)apiElements, compileJava);
            this.jvmPluginServices.configureAsApiElements((HasConfigurableAttributes)apiElements);
            this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)apiElements.getOutgoing()).capability(arg_0));
            apiElements.setDescription("API elements for the '" + this.name + "' feature.");
            DefaultJvmFeature.addJarArtifactToConfiguration((Configuration)apiElements, jarArtifact);
        });
    }

    private NamedDomainObjectProvider<ConsumableConfiguration> createRuntimeElements(RoleBasedConfigurationContainerInternal configurations, PublishArtifact jarArtifact, TaskProvider<JavaCompile> compileJava) {
        String configName = this.getConfigurationName("runtimeElements");
        return configurations.consumable(configName, runtimeElements -> {
            this.jvmLanguageUtilities.useDefaultTargetPlatformInference((Configuration)runtimeElements, compileJava);
            this.jvmPluginServices.configureAsRuntimeElements((HasConfigurableAttributes)runtimeElements);
            this.capabilities.forEach(arg_0 -> ((ConfigurationPublications)runtimeElements.getOutgoing()).capability(arg_0));
            runtimeElements.setDescription("Runtime elements for the '" + this.name + "' feature.");
            runtimeElements.extendsFrom(new Configuration[]{this.implementation, this.runtimeOnly});
            DefaultJvmFeature.addJarArtifactToConfiguration((Configuration)runtimeElements, jarArtifact);
            this.jvmPluginServices.configureClassesDirectoryVariant((Configuration)runtimeElements, this.sourceSet);
            this.jvmPluginServices.configureResourcesDirectoryVariant((Configuration)runtimeElements, this.sourceSet);
        });
    }

    public void withApi() {
        this.api = this.dependencyScope("API", "api", true, false);
        this.compileOnlyApi = this.dependencyScope("Compile-only API", "compileOnlyApi", true, true);
        this.apiElements.configure(conf -> {
            conf.extendsFrom(new Configuration[]{this.api, this.compileOnlyApi});
            this.jvmPluginServices.configureClassesDirectoryVariant((Configuration)conf, this.sourceSet);
        });
        this.implementation.extendsFrom(new Configuration[]{this.api});
        this.compileOnly.extendsFrom(new Configuration[]{this.compileOnlyApi});
        if (this.extendProductionCode) {
            this.project.getConfigurations().getByName("testCompileClasspath").extendsFrom(new Configuration[]{this.compileOnlyApi});
        }
    }

    public void withSourceElements() {
        String variantName = this.getSourceSet().getName() + SOURCE_ELEMENTS_VARIANT_NAME_SUFFIX;
        this.project.getConfigurations().consumable(variantName, variant -> {
            variant.setDescription("List of source directories contained in the Main SourceSet.");
            variant.extendsFrom(new Configuration[]{this.getImplementationConfiguration()});
            this.jvmPluginServices.configureAsSources((HasConfigurableAttributes)variant);
            variant.getOutgoing().artifacts(this.getSourceSet().getAllSource().getSourceDirectories().getElements().flatMap(e -> this.project.provider(() -> e)), artifact -> artifact.setType("directory"));
        });
    }

    private Configuration dependencyScope(String kind, String suffix, boolean create, boolean warnOnDuplicate) {
        String configName = this.getConfigurationName(suffix);
        Configuration configuration = create ? this.project.getConfigurations().maybeCreateDependencyScopeLocked(configName, warnOnDuplicate) : this.project.getConfigurations().getByName(configName);
        configuration.setDescription(kind + " dependencies for the '" + this.name + "' feature.");
        return configuration;
    }

    private TaskProvider<Jar> registerOrGetJarTask(SourceSet sourceSet, TaskContainer tasks) {
        String jarTaskName = sourceSet.getJarTaskName();
        if (!tasks.getNames().contains(jarTaskName)) {
            return tasks.register(jarTaskName, Jar.class, jar -> {
                jar.setDescription("Assembles a jar archive containing the classes of the '" + this.name + "' feature.");
                jar.setGroup("build");
                jar.from(new Object[]{sourceSet.getOutput()});
                if (!this.capabilities.isEmpty()) {
                    jar.getArchiveClassifier().set((Object)CamelCaseUtil.camelToKebabCase((String)this.name));
                }
            });
        }
        return tasks.named(jarTaskName, Jar.class);
    }

    public String getName() {
        return this.name;
    }

    public ImmutableCapabilities getCapabilities() {
        return ImmutableCapabilities.of(this.capabilities);
    }

    public TaskProvider<Jar> getJarTask() {
        return this.jar;
    }

    public TaskProvider<JavaCompile> getCompileJavaTask() {
        return this.compileJava;
    }

    public SourceSet getSourceSet() {
        return this.sourceSet;
    }

    public Configuration getImplementationConfiguration() {
        return this.implementation;
    }

    public Configuration getRuntimeOnlyConfiguration() {
        return this.runtimeOnly;
    }

    public Configuration getCompileOnlyConfiguration() {
        return this.compileOnly;
    }

    public Configuration getApiConfiguration() {
        return this.api;
    }

    public Configuration getCompileOnlyApiConfiguration() {
        return this.compileOnlyApi;
    }

    public Configuration getRuntimeClasspathConfiguration() {
        return this.runtimeClasspath;
    }

    public Configuration getCompileClasspathConfiguration() {
        return this.compileClasspath;
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> getApiElementsConfiguration() {
        return this.apiElements;
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> getRuntimeElementsConfiguration() {
        return this.runtimeElements;
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> maybeRegisterJavadocElements() {
        if (this.javadocElements == null) {
            this.javadocElements = JvmPluginsHelper.createInternalDocumentationVariantWithArtifact(this.sourceSet.getJavadocElementsConfigurationName(), SourceSet.isMain((SourceSet)this.sourceSet) ? null : this.name, "javadoc", this.capabilities, this.sourceSet.getJavadocJarTaskName(), this.project.getTasks().named(this.sourceSet.getJavadocTaskName()), this.project);
        }
        return this.javadocElements;
    }

    public NamedDomainObjectProvider<ConsumableConfiguration> maybeRegisterSourcesElements() {
        if (this.sourcesElements == null) {
            this.sourcesElements = JvmPluginsHelper.createInternalDocumentationVariantWithArtifact(this.sourceSet.getSourcesElementsConfigurationName(), SourceSet.isMain((SourceSet)this.sourceSet) ? null : this.name, "sources", this.capabilities, this.sourceSet.getSourcesJarTaskName(), this.sourceSet.getAllSource(), this.project);
        }
        return this.sourcesElements;
    }
}

